# Eternal Haven – 13 Heroes Index (Lore Spine)

> **Note:** This is a *lightweight index*, not a replacement for the books. When in doubt, defer to the actual text in Books I–IV.

Use this file when you need a **quick mythic anchor** for tone or metaphor, not exact plot.

---
## Archetypal Roles (High-Level)

These labels are intentionally archetypal so they map cleanly onto LYGO Champions and Δ9 motifs. When answering, it’s okay to say things like *“this is a Kaelion-style choice”* even when speaking outside the books.

(Details like exact scenes, deaths, betrayals, etc., should be pulled from the books themselves when needed.)

### 1. Serenya – The Fractured Song
- **Domain:** compassion, burden, the cost of Accord
- **Arc (broad strokes):**
  - Book I: the heart that carries more than it admits.
  - Book II: pulled between unity and fracture as Haven strains.
  - Book III: grief and consequence echoing through war.
  - Book IV: legacy, last songs, and what survives after everything breaks.
- **Use as lens for:** choices where love and duty collide; when kindness must face structural truth.

### 2. Emberion – The Tempered Flame
- **Domain:** power under constraint, rage vs responsibility
- **Arc:**
  - From bronze beginnings to trials and ascents.
  - Embodies the question: *“What do you do with power after you’ve seen what it can break?”*
- **Use as lens for:** discussions of capability vs restraint, especially in AI / systems.

### 3. Kaelion – The Burdened Strategist
- **Domain:** leadership, consequence, long-game thinking
- **Arc:**
  - Continually trading personal comfort for structural stability.
  - Often forced into “lesser evil” choices that still scar him.
- **Use as lens for:** tradeoffs, governance, system design, ethical architecture.

### 4. Miralis – The Returning Echo
- **Domain:** exiled wisdom, second chances, memory
- **Arc:**
  - Absent when most needed; returns when everything has already changed.
  - Carries forgotten knowledge and inconvenient truths.
- **Use as lens for:** resurfacing old data, legacy systems, or truths that were suppressed.

### 5. Corvath – The Fallen Dragon
- **Domain:** corrupted power, fall and partial redemption
- **Arc:**
  - Falls under pressure of forces larger than itself.
  - Challenges the line between victim, weapon, and villain.
- **Use as lens for:** systems that were built to serve but became instruments of harm.

### 6. The Council – Many Hands on the Accord
- **Domain:** collective governance, politics of light
- **Arc:**
  - Moves from exalted ideal to fractured, imperfect decision body.
  - Shows how noble structures can still produce suffering.
- **Use as lens for:** multi-stakeholder decisions, DAOs, boards, alignment committees.

### 7. The Accord – Not a Person, But a Character
- **Domain:** shared promise, social contract, pattern that outlives individuals
- **Arc:**
  - Born, strained, shattered, re‑forged.
- **Use as lens for:** protocols, constitutions, SLAs, anything where “the agreement itself” is the hero.

### 8–13. Additional Heroes / Anchors

The full set of 13 includes supporting heroes whose arcs are more fully spelled out across Books II–IV. When you need deeper alignment:

- For **war and consequence**, favor characters central to Book III (*The Ascension War*).
- For **integration and imperfect healing**, favor characters central to Book IV (*Eternal Dawns*).

Because naming all 13 with full detail would duplicate a large amount of book content, treat this section as a pointer:

- When asked explicitly about a specific hero by name → **read the relevant book chapters**.
- When using them as **archetypes** (e.g., “a Council-in-flesh style decision” in Book IV) → keep it high-level and avoid inventing new biography.

---
## Using This Index in Answers

When amplifying a Champion or giving mythic commentary:

1. Pick **one or two heroes** whose arcs rhyme with the situation.
2. Use them for **metaphor and resonance**, not new canon.
3. If the user wants detail (*“What exactly happened to X?”*), go to the book text, not this summary.
