# Estimation Patterns

Practical estimation techniques for software tasks — methods comparison, decomposition, complexity multipliers, buffer calculation, bias awareness, and communication strategies.

## What's Inside

- Estimation methods comparison (T-shirt sizing, story points, time-based, three-point/PERT, reference comparison)
- Task decomposition (break to < 4 hours)
- Complexity multipliers (new tech, unclear requirements, legacy code, cross-team dependencies)
- Buffer calculation (known unknowns, unknown unknowns, focus ratio)
- Historical calibration and accuracy tracking
- Common estimation biases and mitigations
- Estimation ranges by task type
- Communication strategies (ranges, confidence levels, stakeholder rules)
- Anti-patterns

## When to Use

- Estimating a feature, bug fix, or project timeline
- Breaking down work for sprint planning or roadmap forecasting
- Presenting estimates to stakeholders or product managers
- Reviewing historical accuracy to calibrate future estimates
- Noticing a pattern of missed deadlines or blown budgets

## Installation

```bash
npx add https://github.com/wpank/ai/tree/main/skills/meta/estimation-patterns
```

### OpenClaw / Moltbot / Clawbot

```bash
npx clawhub@latest install estimation-patterns
```

### Manual Installation

#### Cursor (per-project)

From your project root:

```bash
mkdir -p .cursor/skills
cp -r ~/.ai-skills/skills/meta/estimation-patterns .cursor/skills/estimation-patterns
```

#### Cursor (global)

```bash
mkdir -p ~/.cursor/skills
cp -r ~/.ai-skills/skills/meta/estimation-patterns ~/.cursor/skills/estimation-patterns
```

#### Claude Code (per-project)

From your project root:

```bash
mkdir -p .claude/skills
cp -r ~/.ai-skills/skills/meta/estimation-patterns .claude/skills/estimation-patterns
```

#### Claude Code (global)

```bash
mkdir -p ~/.claude/skills
cp -r ~/.ai-skills/skills/meta/estimation-patterns ~/.claude/skills/estimation-patterns
```

---

Part of the [Meta](..) skill category.
