---
name: esri-workflow-smell-detector (consumer)
version: 1.0.0
description: |
  Paid client skill for Esri Workflow Smell Detector via x402 (Base/USDC).
  Use when you want to run a deterministic automation preflight scan on an ArcGIS Pro project snapshot
  by calling https://api.x402layer.cc/e/esri-smells (HTTP 402 payment flow).
---

# Esri Workflow Smell Detector (Consumer Skill)

This skill helps an agent **call the paid Smell Detector** endpoint (x402 pay-per-request) using Base/USDC.

It does **not** host the service.

## How this relates to arcgispro-cli

The expected input, `project_snapshot`, is the JSON artifact produced by the open-source ArcGIS Pro CLI (`arcgispro-cli`).

Recommended workflow:
1) Use `arcgispro-cli` to export a project snapshot/context artifact (safe-by-default, no raw data)
2) Send that JSON to this paid endpoint for a deterministic preflight risk report
3) Use the report to decide whether to proceed with automation (ArcPy/GP/AGOL) and what to fix first

This keeps a clean boundary:
- Open core (`arcgispro-cli`) answers: **what is in the project**
- Paid layer (this service) answers: **how risky is it to automate, and why**

## Endpoint
- `POST https://api.x402layer.cc/e/esri-smells`

## Input
Required JSON body:

```json
{
  "project_snapshot": { },
  "constraints": {
    "target": "arcpy" | "geoprocessing" | "agol",
    "deployment": "desktop" | "server",
    "max_runtime_sec": 300
  }
}
```

## Output (guaranteed fields)
- `summary`
- `risk_score` (0.0–1.0)
- `issues[]`
- `flags`
- `version`
- `requestHash`

## Determinism
- Stateless
- No external network calls (beyond the paid endpoint itself)
- Same input produces same output
- Safe to cache by `requestHash`

## Pricing
- x402 pay-per-request on Base
- Target price: **$0.001** per call

## How to call (Python helper)

1) Install deps:

```bash
pip install -r {baseDir}/requirements.txt
```

2) Set wallet env (consumer wallet):

```bash
export PRIVATE_KEY="0x..."
export WALLET_ADDRESS="0x..."
```

3) Call the endpoint:

```bash
python {baseDir}/scripts/call_smells.py path/to/project_snapshot.json
```

### Notes
- The script implements the x402 HTTP 402 challenge flow and retries with `X-Payment`.
- If the endpoint is unreachable or the network rejects the payment, surface the error as-is.
