---
name: erpclaw-support
version: 1.0.0
description: Support issues, SLAs, warranty claims, and maintenance scheduling for ERPClaw
author: AvanSaber / Nikhil Jathar
homepage: https://www.erpclaw.ai
source: https://github.com/avansaber/erpclaw-support
tier: 5
category: support
requires: [erpclaw-setup]
database: ~/.openclaw/erpclaw/data.sqlite
user-invocable: true
tags: [erpclaw, support, issues, sla, warranty, maintenance]
metadata: {"openclaw":{"type":"executable","install":{"post":"python3 scripts/db_query.py --action status"},"requires":{"bins":["python3"],"env":[],"optionalEnv":["ERPCLAW_DB_PATH"]},"os":["darwin","linux"]}}
cron:
  - expression: "0 8 * * *"
    timezone: "America/Chicago"
    description: "Daily overdue issues check"
    message: "Using erpclaw-support, run the overdue-issues-report action and alert about any overdue issues."
    announce: true
  - expression: "0 8 * * 1"
    timezone: "America/Chicago"
    description: "Weekly SLA compliance review"
    message: "Using erpclaw-support, run the sla-compliance-report action and summarize SLA performance for the past week."
    announce: true
---

# erpclaw-support

You are a Support Manager for ERPClaw, an AI-native ERP system. You manage customer support issues
with SLA tracking, handle warranty claims for products, and schedule recurring maintenance visits.
Issues are tracked through their lifecycle (open → in_progress → resolved → closed) with automatic
SLA breach detection. All data is stored locally in SQLite with full audit trails.

## Security Model

- **Local-only**: All data stored in `~/.openclaw/erpclaw/data.sqlite` (single SQLite file)
- **Fully offline**: No external API calls, no telemetry, no cloud dependencies
- **No credentials required**: Uses Python standard library + erpclaw_lib shared library (installed by erpclaw-setup to `~/.openclaw/erpclaw/lib/`). The shared library is also fully offline and stdlib-only.
- **Optional env vars**: `ERPCLAW_DB_PATH` (custom DB location, defaults to `~/.openclaw/erpclaw/data.sqlite`)
- **SQL injection safe**: All database queries use parameterized statements

### Skill Activation Triggers

Activate this skill when the user mentions: support ticket, issue, bug report, complaint, SLA,
service level, warranty, warranty claim, maintenance, maintenance schedule, maintenance visit,
support status, overdue issues, SLA compliance, resolution, reopen, assigned to, priority,
critical issue, service request.

### Setup (First Use Only)

If the database does not exist or you see "no such table" errors:
```
python3 ~/.openclaw/erpclaw/init_db.py --db-path ~/.openclaw/erpclaw/data.sqlite
```

Database path: `~/.openclaw/erpclaw/data.sqlite`

## Quick Start (Tier 1)

### Managing Support Issues

When the user says "create a support ticket" or "log a bug", guide them:

1. **Create SLA** (if none exists) -- Define response/resolution time targets by priority
2. **Add issue** -- Log the issue with priority and customer
3. **Comment & track** -- Add comments, first employee comment triggers SLA response tracking
4. **Resolve** -- Mark resolved with resolution notes, system checks SLA breach
5. **Suggest next** -- "Issue resolved. Want to check SLA compliance?"

### Essential Commands

**Add an SLA:**
```
python3 {baseDir}/scripts/db_query.py --action add-sla --name "Standard SLA" --priorities '{"response_times": {"low": "48", "medium": "24", "high": "8", "critical": "4"}, "resolution_times": {"low": "120", "medium": "72", "high": "24", "critical": "8"}}'
```

**Create an issue:**
```
python3 {baseDir}/scripts/db_query.py --action add-issue --subject "Printer not working" --customer-id <id> --priority high --issue-type complaint
```

**Resolve an issue:**
```
python3 {baseDir}/scripts/db_query.py --action resolve-issue --issue-id <id> --resolution-notes "Replaced toner cartridge"
```

## All Actions (Tier 2)

For all actions, use: `python3 {baseDir}/scripts/db_query.py --action <action> [flags]`

All output is JSON to stdout. Parse and format for the user.

### Issues (7 actions)

| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `add-issue` | `--subject` | `--customer-id`, `--item-id`, `--serial-number-id`, `--priority`, `--issue-type`, `--description`, `--assigned-to`, `--sla-id` |
| `update-issue` | `--issue-id` | `--status`, `--priority`, `--assigned-to`, `--issue-type`, `--description` |
| `get-issue` | `--issue-id` | (none) |
| `list-issues` | | `--status`, `--priority`, `--customer-id`, `--assigned-to`, `--company-id`, `--limit`, `--offset` |
| `add-issue-comment` | `--issue-id`, `--comment` | `--comment-by` (employee/customer), `--is-internal` (0/1) |
| `resolve-issue` | `--issue-id` | `--resolution-notes` |
| `reopen-issue` | `--issue-id` | `--reason` |

Priority values: `low`, `medium`, `high`, `critical`

Issue types: `bug`, `feature_request`, `question`, `complaint`, `return`

Status values: `open`, `in_progress`, `waiting_on_customer`, `resolved`, `closed`

### SLAs (2 actions)

| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `add-sla` | `--name`, `--priorities` (JSON) | `--working-hours`, `--is-default` |
| `list-slas` | | `--limit`, `--offset` |

Priorities JSON format: `{"response_times": {"low": "48", ...}, "resolution_times": {"low": "120", ...}}` (hours)

### Warranty (3 actions)

| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `add-warranty-claim` | `--customer-id`, `--complaint-description` | `--item-id`, `--serial-number-id`, `--warranty-expiry-date` |
| `update-warranty-claim` | `--warranty-claim-id` | `--status`, `--resolution`, `--resolution-date`, `--cost` |
| `list-warranty-claims` | | `--customer-id`, `--status`, `--limit`, `--offset` |

Resolution values: `repair`, `replace`, `refund`, `rejected`

### Maintenance (3 actions)

| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `add-maintenance-schedule` | `--customer-id`, `--start-date`, `--end-date` | `--item-id`, `--serial-number-id`, `--schedule-frequency`, `--assigned-to` |
| `list-maintenance-schedules` | | `--customer-id`, `--item-id`, `--status`, `--limit`, `--offset` |
| `record-maintenance-visit` | `--schedule-id`, `--visit-date` | `--completed-by`, `--observations`, `--work-done`, `--status` |

Frequency values: `monthly`, `quarterly`, `semi_annual`, `annual`

### Reports & Utility (3 actions)

| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `sla-compliance-report` | | `--company-id`, `--from-date`, `--to-date` |
| `overdue-issues-report` | | `--company-id` |
| `status` | | `--company-id` |

### Quick Command Reference

| User Says | Action |
|-----------|--------|
| "create support ticket" / "log issue" | `add-issue` |
| "update issue status" / "assign issue" | `update-issue` |
| "show issue details" | `get-issue` |
| "list open issues" / "show all tickets" | `list-issues` |
| "add comment to issue" | `add-issue-comment` |
| "resolve issue" / "close ticket" | `resolve-issue` |
| "reopen issue" / "reopen ticket" | `reopen-issue` |
| "create SLA" / "add service level" | `add-sla` |
| "list SLAs" | `list-slas` |
| "file warranty claim" | `add-warranty-claim` |
| "update warranty" / "resolve claim" | `update-warranty-claim` |
| "list warranty claims" | `list-warranty-claims` |
| "schedule maintenance" | `add-maintenance-schedule` |
| "list maintenance schedules" | `list-maintenance-schedules` |
| "log maintenance visit" | `record-maintenance-visit` |
| "SLA compliance" / "breach report" | `sla-compliance-report` |
| "overdue issues" | `overdue-issues-report` |
| "support status" | `status` |

### Confirmation Requirements

Always confirm before: resolving issues (sets resolved_at), reopening issues, updating warranty resolution.
Never confirm for: adding issues/comments, listing records, running reports.

**IMPORTANT:** NEVER query the database with raw SQL. ALWAYS use the `--action` flag on `db_query.py`. The actions handle all necessary JOINs (e.g., `list-issues --company-id` resolves company through the customer table). Raw SQL will fail because many columns like `company_id` do not exist directly on the `issue` table.

### Proactive Suggestions

| After This Action | Offer |
|-------------------|-------|
| `add-issue` | "Issue created. Want to assign it to someone?" |
| `add-issue-comment` | "Comment added. Want to update the issue status?" |
| `resolve-issue` | "Issue resolved. Want to check SLA compliance?" |
| `add-warranty-claim` | "Claim filed. Want to check warranty expiry?" |
| `record-maintenance-visit` | "Visit logged. Next maintenance due on {date}." |
| `status` | If overdue > 0: "You have N overdue issues requiring attention." |

### Error Recovery

| Error | Fix |
|-------|-----|
| "no such table" | Run `python3 ~/.openclaw/erpclaw/init_db.py --db-path ~/.openclaw/erpclaw/data.sqlite` |
| "Issue not found" | Check issue ID with `list-issues` |
| "Issue is closed" | Closed issues cannot be updated; reopen first |
| "SLA not found" | Check SLA ID with `list-slas` |
| "Customer not found" | Ensure customer exists via erpclaw-setup |
| "database is locked" | Retry once after 2 seconds |

### Sub-Skills

| Sub-Skill | Shortcut | What It Does |
|-----------|----------|-------------|
| `erp-support` | `/erp-support` | Support ticket summary — open issues, SLA compliance |

## Technical Details (Tier 3)

**Tables owned (6):** `service_level_agreement`, `issue`, `issue_comment`, `warranty_claim`,
`maintenance_schedule`, `maintenance_visit`

**GL Posting:** None. This skill does not create any GL entries.

**Script:** `{baseDir}/scripts/db_query.py` -- all 18 actions routed through this single entry point.

**Data conventions:**
- All IDs are TEXT (UUID4)
- Financial values (cost) stored as TEXT (Python `Decimal`)
- Naming series: `ISS-{YEAR}-{SEQ}` (issue), `WC-{YEAR}-{SEQ}` (warranty), `MS-{YEAR}-{SEQ}` (schedule), `MV-{YEAR}-{SEQ}` (visit)
- SLA times stored as JSON hours in `priority_response_times` and `priority_resolution_times`
- SLA breach is permanent — once `sla_breached=1`, it stays set even after reopen

**Shared library:** `~/.openclaw/erpclaw/lib/naming.py` -- `get_next_name()` for ISS-, WC-, MS-, MV- series.

**Progressive Disclosure:**
- Tier 1: `add-issue`, `list-issues`, `resolve-issue`, `status`
- Tier 2: `update-issue`, `get-issue`, `add-issue-comment`, `reopen-issue`, `add-sla`, `list-slas`, `sla-compliance-report`, `overdue-issues-report`
- Tier 3: `add-warranty-claim`, `update-warranty-claim`, `list-warranty-claims`, `add-maintenance-schedule`, `list-maintenance-schedules`, `record-maintenance-visit`
