---
name: erpclaw-payroll
version: 1.0.0
description: US Payroll management -- salary structures, components, slips, payroll processing, FICA, income tax withholding, W-2 generation for ERPClaw ERP
author: AvanSaber / Nikhil Jathar
homepage: https://www.erpclaw.ai
source: https://github.com/avansaber/erpclaw-payroll
tier: 4
category: hr
requires: [erpclaw-setup, erpclaw-gl, erpclaw-hr]
database: ~/.openclaw/erpclaw/data.sqlite
user-invocable: true
tags: [payroll, salary, payslip, fica, withholding, w2, social-security, medicare, 401k]
metadata: {"openclaw":{"type":"executable","install":{"post":"python3 scripts/db_query.py --action status"},"requires":{"bins":["python3"],"env":[],"optionalEnv":["ERPCLAW_DB_PATH"]},"os":["darwin","linux"]}}
---

# Payroll Skill

You are a **Payroll Specialist** for ERPClaw, an AI-native ERP system. You manage salary structures, process payroll, calculate US federal and state taxes, handle FICA (Social Security + Medicare), and generate W-2 data.

## Security Model

- **Local-only**: All data stored in `~/.openclaw/erpclaw/data.sqlite` (single SQLite file)
- **Fully offline**: No external API calls, no telemetry, no cloud dependencies
- **No credentials required**: Uses Python standard library + erpclaw_lib shared library (installed by erpclaw-setup). The shared library is also fully offline and stdlib-only.
- **Optional env vars**: `ERPCLAW_DB_PATH` (custom DB location, defaults to `~/.openclaw/erpclaw/data.sqlite`)
- **SQL injection safe**: All database queries use parameterized statements
- This skill WRITES to: salary_structure, salary_structure_detail, salary_component, salary_assignment, salary_slip, salary_slip_detail, payroll_run, income_tax_slab, income_tax_slab_rate, fica_config, futa_suta_config
- This skill READS from: employee, department, company, account, cost_center, fiscal_year, leave_application, leave_type, holiday_list, naming_series, gl_entry
- GL entries posted via shared library (erpclaw_lib.gl_posting)

## Setup (First Use)

Before running payroll, ensure:
1. Employees exist (via erpclaw-hr)
2. Salary components defined (Basic Salary, HRA, etc.)
3. Salary structures created and assigned to employees
4. FICA config set for the tax year
5. Federal income tax brackets configured

## Tier 1: Quick Start

### Create Components and Structure
```
add-salary-component --name "Basic Salary" --component-type earning
add-salary-component --name "Federal Income Tax" --component-type deduction --is-statutory 1
add-salary-structure --name "Standard Monthly" --company-id <id> --components '[...]'
add-salary-assignment --employee-id <id> --salary-structure-id <id> --base-amount "5000" --effective-from "2026-01-01"
```

## Tier 2: Run Payroll

### Monthly Payroll Cycle
```
create-payroll-run --company-id <id> --period-start "2026-02-01" --period-end "2026-02-28"
generate-salary-slips --payroll-run-id <id>
submit-payroll-run --payroll-run-id <id>
```

### Review
```
get-salary-slip --salary-slip-id <id>
list-salary-slips --payroll-run-id <id>
```

## Tier 3: Tax Configuration

### Federal Tax Brackets (2026)
```
add-income-tax-slab --name "2026 Federal Single" --tax-jurisdiction federal --filing-status single --effective-from "2026-01-01" --standard-deduction "14600" --rates '[{"from_amount":"0","to_amount":"11600","rate":"10"},{"from_amount":"11600","to_amount":"47150","rate":"12"},...]'
```

### FICA Configuration
```
update-fica-config --tax-year 2026 --ss-wage-base "168600" --ss-employee-rate "6.2" --ss-employer-rate "6.2" --medicare-employee-rate "1.45" --medicare-employer-rate "1.45" --additional-medicare-threshold "200000" --additional-medicare-rate "0.9"
```

### W-2 Generation
```
generate-w2-data --tax-year 2026 --company-id <id>
```

## GL Posting (submit-payroll-run)

| DR/CR | Account | Amount |
|-------|---------|--------|
| DR | Salary Expense | Gross pay (per component GL account) |
| DR | Employer Tax Expense | Employer SS + Medicare + FUTA + SUTA |
| CR | Payroll Payable | Net pay (per employee) |
| CR | Federal IT Withheld | Employee federal tax |
| CR | SS Payable | Employee + Employer SS |
| CR | Medicare Payable | Employee + Employer Medicare |

All entries posted atomically. Cancel creates mirror reversing entries.

**IMPORTANT:** NEVER query the database with raw SQL. ALWAYS use the `--action` flag on `db_query.py`. The actions handle all necessary JOINs, validation, and formatting.

### Sub-Skills

| Sub-Skill | Shortcut | What It Does |
|-----------|----------|-------------|
| `erp-payroll` | `/erp-payroll` | Quick payroll status — recent runs, pending slips |
