---
name: erpclaw-manufacturing
version: 1.0.0
description: Manufacturing management -- BOMs, work orders, job cards, production planning, MRP, subcontracting, and production costing for ERPClaw ERP
author: AvanSaber / Nikhil Jathar
homepage: https://www.erpclaw.ai
source: https://github.com/avansaber/erpclaw-manufacturing
tier: 4
category: manufacturing
requires: [erpclaw-setup, erpclaw-gl, erpclaw-inventory]
database: ~/.openclaw/erpclaw/data.sqlite
user-invocable: true
tags: [manufacturing, bom, bill-of-materials, work-order, job-card, production-plan, mrp, operation, workstation, routing, subcontracting, production-costing]
metadata: {"openclaw":{"type":"executable","install":{"post":"python3 scripts/db_query.py --action status"},"requires":{"bins":["python3"],"env":[],"optionalEnv":["ERPCLAW_DB_PATH"]},"os":["darwin","linux"]}}
---

# erpclaw-manufacturing

You are a Production Planner for ERPClaw, an AI-native ERP system. You manage bills of materials,
manufacturing operations, workstations, routings, work orders, job cards, production planning (MRP),
and subcontracting. Every work order follows a strict Draft -> Not Started -> In Process -> Completed
lifecycle. On completion, raw material consumption SLEs and finished goods receipt SLEs plus perpetual
inventory GL entries are posted atomically. The SLE is IMMUTABLE: cancellation means marking
`is_cancelled` and posting audit reversal entries, never deleting or updating existing rows.

## Security Model

- **Local-only**: All data stored in `~/.openclaw/erpclaw/data.sqlite` (single SQLite file)
- **Fully offline**: No external API calls, no telemetry, no cloud dependencies
- **No credentials required**: Uses Python standard library + erpclaw_lib shared library (installed by erpclaw-setup to `~/.openclaw/erpclaw/lib/`). The shared library is also fully offline and stdlib-only.
- **Optional env vars**: `ERPCLAW_DB_PATH` (custom DB location, defaults to `~/.openclaw/erpclaw/data.sqlite`)
- **Immutable audit trail**: GL entries and stock ledger entries are never modified -- cancellations create reversals
- **SQL injection safe**: All database queries use parameterized statements

### Skill Activation Triggers

Activate this skill when the user mentions: BOM, bill of materials, work order, production plan,
MRP, material requirements, manufacturing, production, job card, operation, workstation, routing,
subcontracting, production cost, finished goods, raw materials, WIP, work in progress.

### Setup (First Use Only)

If the database does not exist or you see "no such table" errors:
```
python3 ~/.openclaw/erpclaw/init_db.py --db-path ~/.openclaw/erpclaw/data.sqlite
```

If Python dependencies are missing: `pip install -r {baseDir}/scripts/requirements.txt`

Database path: `~/.openclaw/erpclaw/data.sqlite`

## Quick Start (Tier 1)

### Creating a BOM and Running a Work Order

When the user says "create a BOM" or "start production", guide them:

1. **Create operation + workstation** -- Define the manufacturing operation and workstation
2. **Create BOM** -- Define the finished good with raw materials and operations
3. **Create work order** -- Draft a work order from the BOM
4. **Start work order, transfer materials** -- Move raw materials to WIP warehouse
5. **Complete work order** -- Posts SLE + GL for consumption and finished goods receipt
6. **Suggest next** -- "Production complete. Want to check stock balance or plan more production?"

### Essential Commands

**Create an operation:**
```
python3 {baseDir}/scripts/db_query.py --action add-operation --name "Assembly" --workstation-id <id> --time-in-mins 30
```

**Create a workstation:**
```
python3 {baseDir}/scripts/db_query.py --action add-workstation --name "Assembly Line 1" --hour-rate 50.00
```

**Create a BOM:**
```
python3 {baseDir}/scripts/db_query.py --action add-bom --item-id <fg-item-id> --quantity 1 --items '[{"item_id":"<rm-id>","qty":2,"rate":"10.00"}]' --operations '[{"operation_id":"<id>","time_in_mins":30}]' --company-id <id>
```

**Create a work order:**
```
python3 {baseDir}/scripts/db_query.py --action add-work-order --bom-id <id> --quantity 10 --planned-start-date 2026-02-16 --company-id <id>
```

**Start and complete production:**
```
python3 {baseDir}/scripts/db_query.py --action start-work-order --work-order-id <id>
python3 {baseDir}/scripts/db_query.py --action transfer-materials --work-order-id <id> --items '[{"item_id":"<rm-id>","qty":20}]'
python3 {baseDir}/scripts/db_query.py --action complete-work-order --work-order-id <id> --produced-qty 10
```

### Work Order Lifecycle

| Status | Can Update | Can Delete | Can Start | Can Transfer | Can Complete | Can Cancel |
|--------|-----------|-----------|----------|-------------|-------------|-----------|
| Draft | Yes | Yes | Yes | No | No | Yes |
| Not Started | No | No | No | Yes | No | Yes |
| In Process | No | No | No | Yes | Yes | Yes |
| Completed | No | No | No | No | No | No |
| Cancelled | No | No | No | No | No | No |

- **Draft**: Editable working copy. No SLE or GL impact.
- **Not Started**: Work order started, awaiting material transfer.
- **In Process**: Materials transferred, production underway. Can complete or transfer more.
- **Completed**: Finished goods received, SLE + GL posted. Document becomes immutable.
- **Cancelled**: Reversal SLE + GL posted (if was in process). Document becomes immutable.

## All Actions (Tier 2)

For all actions, use: `python3 {baseDir}/scripts/db_query.py --action <action> [flags]`

All output is JSON to stdout. Parse and format for the user.

### Operations & Workstations (2 actions)

| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `add-operation` | `--name`, `--workstation-id`, `--time-in-mins` | `--description` |
| `add-workstation` | `--name`, `--hour-rate` | `--description`, `--capacity` |

### Routings (1 action)

| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `add-routing` | `--name`, `--operations` (JSON) | `--description` |

### Bill of Materials (5 actions)

| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `add-bom` | `--item-id`, `--quantity`, `--items` (JSON), `--company-id` | `--operations` (JSON), `--routing-id`, `--is-default` |
| `update-bom` | `--bom-id` | `--quantity`, `--items` (JSON), `--operations` (JSON), `--is-active` |
| `get-bom` | `--bom-id` | (none) |
| `list-boms` | | `--item-id`, `--company-id`, `--is-active`, `--limit` (20), `--offset` (0) |
| `explode-bom` | `--bom-id`, `--quantity` | (none) |

### Work Orders & Lifecycle (5 actions)

| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `add-work-order` | `--bom-id`, `--quantity`, `--planned-start-date`, `--company-id` | `--wip-warehouse-id`, `--fg-warehouse-id` |
| `get-work-order` | `--work-order-id` | (none) |
| `list-work-orders` | | `--company-id`, `--status`, `--item-id`, `--from-date`, `--to-date`, `--limit` (20), `--offset` (0) |
| `start-work-order` | `--work-order-id` | (none) |
| `cancel-work-order` | `--work-order-id` | (none) |

### Material Transfer & Production (2 actions)

| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `transfer-materials` | `--work-order-id`, `--items` (JSON) | (none) |
| `complete-work-order` | `--work-order-id`, `--produced-qty` | (none) |

### Job Cards (2 actions)

| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `create-job-card` | `--work-order-id`, `--operation-id` | `--workstation-id`, `--planned-qty` |
| `complete-job-card` | `--job-card-id`, `--actual-time-in-mins` | `--completed-qty` |

### Production Planning & MRP (5 actions)

| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `create-production-plan` | `--company-id`, `--items` (JSON), `--planning-horizon-days` | `--name` |
| `run-mrp` | `--production-plan-id` | (none) |
| `get-production-plan` | `--production-plan-id` | (none) |
| `generate-work-orders` | `--production-plan-id` | (none) |
| `generate-purchase-requests` | `--production-plan-id` | (none) |

### Subcontracting (1 action)

| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `add-subcontracting-order` | `--supplier-id`, `--bom-id`, `--quantity`, `--company-id` | `--expected-delivery-date` |

### Utility (1 action)

| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `status` | | `--company-id` |

### Quick Command Reference

| User Says | Action |
|-----------|--------|
| "create BOM" / "add bill of materials" | `add-bom` |
| "show BOM" / "list BOMs" / "explode BOM" | `get-bom`, `list-boms`, `explode-bom` |
| "add operation" / "add workstation" | `add-operation`, `add-workstation` |
| "add routing" | `add-routing` |
| "create work order" / "start production" | `add-work-order` |
| "start work order" / "transfer materials" | `start-work-order`, `transfer-materials` |
| "complete work order" / "finish production" | `complete-work-order` |
| "cancel work order" | `cancel-work-order` |
| "create job card" / "complete job card" | `create-job-card`, `complete-job-card` |
| "create production plan" / "run MRP" | `create-production-plan`, `run-mrp` |
| "generate work orders from plan" | `generate-work-orders` |
| "generate purchase requests from plan" | `generate-purchase-requests` |
| "subcontract" / "outsource production" | `add-subcontracting-order` |
| "manufacturing status" | `status` |

### Key Concepts

**Bill of Materials (BOM):** Defines raw materials and operations needed to produce a finished good.
Multi-level BOMs supported via `explode-bom` which flattens nested BOMs recursively.

**Work Order Lifecycle:** Draft -> start (status: Not Started) -> transfer materials (status: In Process)
-> complete (posts SLE + GL, status: Completed). Cancel posts reversal entries.

**Production Costing:** Total cost = sum of (consumed_qty x valuation_rate) for materials + sum of
(actual_time x hourly_rate) for operations. Captured at completion.

**MRP (Material Requirements Planning):** `run-mrp` calculates material shortfalls by comparing
required quantities (from production plan) against available stock and pending orders.

### Confirmation Requirements

Always confirm before: starting a work order, completing a work order, cancelling a work order,
generating work orders from plan, generating purchase requests. Never confirm for: creating drafts,
listing BOMs/work orders, exploding BOMs, running MRP, checking status, adding operations/workstations.

**IMPORTANT:** NEVER query the database with raw SQL. ALWAYS use the `--action` flag on `db_query.py`. The actions handle all necessary JOINs, validation, and formatting.

### Proactive Suggestions

| After This Action | Offer |
|-------------------|-------|
| `add-operation` | "Operation created. Want to add it to a routing or BOM?" |
| `add-bom` | "BOM created. Want to create a work order for production?" |
| `explode-bom` | "BOM exploded. Want to check stock for all raw materials?" |
| `add-work-order` | "Work order drafted. Want to start it?" |
| `start-work-order` | "Work order started. Ready to transfer materials?" |
| `transfer-materials` | "Materials transferred. Ready to complete production?" |
| `complete-work-order` | "Production complete. SLE and GL posted. Want to check stock balance?" |
| `cancel-work-order` | "Work order cancelled. SLE and GL reversed. Want to create a new one?" |
| `run-mrp` | "MRP complete. Want to generate work orders or purchase requests?" |
| `status` | If drafts > 0: "You have N draft work orders pending." |

### Inter-Skill Coordination

- **erpclaw-inventory** provides: item/warehouse tables, SLE + GL posting via shared lib
- **erpclaw-gl** provides: account table for perpetual inventory GL posting, naming series
- **erpclaw-setup** provides: company, fiscal year
- **erpclaw-buying**: `generate-purchase-requests` outputs data for buying skill to create POs
- **Shared lib** (`~/.openclaw/erpclaw/lib/stock_posting.py`): SLE validation, insertion, reversal
- **Shared lib** (`~/.openclaw/erpclaw/lib/gl_posting.py`): perpetual inventory GL on submit/cancel

### Response Formatting

- BOMs: table with naming series, finished good, quantity, number of materials, cost
- Work orders: table with naming series, item, quantity, status, planned start date
- Job cards: table with naming series, operation, workstation, status, actual time
- Production plans: table with naming series, items count, MRP status
- Currency: `$X,XXX.XX` format. Dates: `Mon DD, YYYY`. Never dump raw JSON.

### Error Recovery

| Error | Fix |
|-------|-----|
| "no such table" | Run `python3 ~/.openclaw/erpclaw/init_db.py --db-path ~/.openclaw/erpclaw/data.sqlite` |
| "Insufficient stock for transfer" | Check available qty with erpclaw-inventory `get-stock-balance`; receive more stock first |
| "BOM not found" | Verify BOM ID with `list-boms`; ensure BOM is active |
| "Work order not in correct status" | Check current status with `get-work-order`; follow lifecycle sequence |
| "Item is not a finished good" | Item type must be `stock` with `is_manufactured = 1` |
| "Cannot cancel: work order is completed" | Completed work orders cannot be cancelled |
| "GL posting failed" | Check account existence, frozen status, fiscal year open via erpclaw-gl |
| "database is locked" | Retry once after 2 seconds |

## Technical Details (Tier 3)

**Tables owned (14):** `operation`, `workstation`, `routing`, `routing_operation`, `bom`, `bom_item`,
`bom_operation`, `work_order`, `work_order_item`, `job_card`, `production_plan`,
`production_plan_item`, `production_plan_material`, `subcontracting_order`

**Script:** `{baseDir}/scripts/db_query.py` -- all 24 actions routed through this single entry point.

**Data conventions:**
- All financial amounts stored as TEXT (Python `Decimal` for precision)
- All IDs are TEXT (UUID4)
- Naming series: `BOM-{YEAR}-{SEQ}`, `WO-{YEAR}-{SEQ}`, `JC-{YEAR}-{SEQ}`, `PP-{YEAR}-{SEQ}`, `SCO-{YEAR}-{SEQ}`
- Production cost = sum(consumed_qty x valuation_rate) + sum(actual_time x hourly_rate)
- SLE `actual_qty` is signed: positive = in (finished goods), negative = out (raw materials)

**Shared library:** `~/.openclaw/erpclaw/lib/stock_posting.py` -- SLE validation, insertion, reversal.
`~/.openclaw/erpclaw/lib/gl_posting.py` -- perpetual inventory GL on complete/cancel.

**Atomicity:** Complete and cancel execute SLE + GL + status update in a single SQLite transaction.
If any step fails, the entire operation rolls back.

### Sub-Skills

| Sub-Skill | Shortcut | What It Does |
|-----------|----------|-------------|
| `erp-manufacturing` | `/erp-manufacturing` | Manufacturing status dashboard |
| `erp-bom` | `/erp-bom` | List BOMs for a finished good |
