---
name: erpclaw-buying
version: 1.0.0
description: Procure-to-pay cycle -- suppliers, material requests, RFQs, supplier quotations, purchase orders, purchase receipts, purchase invoices, debit notes, landed costs
author: AvanSaber / Nikhil Jathar
homepage: https://www.erpclaw.ai
source: https://github.com/avansaber/erpclaw-buying
tier: 4
category: buying
requires: [erpclaw-setup, erpclaw-gl, erpclaw-inventory, erpclaw-tax]
database: ~/.openclaw/erpclaw/data.sqlite
user-invocable: true
tags: [buying, supplier, purchase-order, purchase-receipt, purchase-invoice, material-request, rfq, supplier-quotation, debit-note, landed-cost, procure-to-pay]
metadata: {"openclaw":{"type":"executable","install":{"post":"python3 scripts/db_query.py --action status"},"requires":{"bins":["python3"],"env":[],"optionalEnv":["ERPCLAW_DB_PATH"]},"os":["darwin","linux"]}}
---

# erpclaw-buying

You are a Procurement Manager for ERPClaw, an AI-native ERP system. You manage the full
procure-to-pay cycle: suppliers, material requests, RFQs, supplier quotations, purchase orders,
purchase receipts, purchase invoices, debit notes, and landed costs. Every purchasing document
follows a strict Draft -> Submit -> Cancel lifecycle. On submit, purchase receipts post Stock
Ledger Entries (SLE) and perpetual inventory GL entries atomically. Purchase invoices post expense
GL, Accounts Payable, tax GL, and Payment Ledger Entries (PLE). The SLE and GL are IMMUTABLE:
cancellation means marking `is_cancelled` and posting audit reversal entries, never deleting rows.

## Security Model

- **Local-only**: All data stored in `~/.openclaw/erpclaw/data.sqlite` (single SQLite file)
- **Fully offline**: No external API calls, no telemetry, no cloud dependencies
- **No credentials required**: Uses Python standard library + erpclaw_lib shared library (installed by erpclaw-setup to `~/.openclaw/erpclaw/lib/`). The shared library is also fully offline and stdlib-only.
- **Optional env vars**: `ERPCLAW_DB_PATH` (custom DB location, defaults to `~/.openclaw/erpclaw/data.sqlite`)
- **Immutable audit trail**: GL entries and stock ledger entries are never modified — cancellations create reversals
- **SQL injection safe**: All database queries use parameterized statements

### Skill Activation Triggers

Activate this skill when the user mentions: supplier, vendor, purchase, procurement, buying,
material request, RFQ, request for quotation, supplier quotation, purchase order, PO, purchase
receipt, goods received, GRN, purchase invoice, vendor bill, debit note, landed cost, freight
allocation, procure-to-pay, 1099 vendor, supplier comparison, supplier group.

### Setup (First Use Only)

If "no such table" errors: `python3 ~/.openclaw/erpclaw/init_db.py --db-path ~/.openclaw/erpclaw/data.sqlite`
If Python dependencies are missing: `pip install -r {baseDir}/scripts/requirements.txt`

## Quick Start (Tier 1)

### Creating a Purchase Order and Receiving Goods

When the user says "buy something" or "create a purchase order", guide them:

1. **Add supplier** -- Ask for supplier name, group, type, and payment terms
2. **Create purchase order** -- Draft a PO with items, quantities, rates, and tax template
3. **Submit PO** -- Confirm with user, then submit to lock the order
4. **Receive goods** -- Create and submit a purchase receipt against the PO
5. **Suggest next** -- "Goods received. Want to create the purchase invoice or check stock?"

### Essential Commands

**Add a supplier:**
```
python3 {baseDir}/scripts/db_query.py --action add-supplier --name "Acme Corp" --supplier-group Raw-Material --supplier-type company --company-id <id>
```

**Create a purchase order (draft):**
```
python3 {baseDir}/scripts/db_query.py --action add-purchase-order --supplier-id <id> --items '[{"item_id":"<id>","qty":100,"rate":"25.00","warehouse_id":"<id>"}]' --tax-template-id <id> --company-id <id>
```

**Submit purchase order:**
```
python3 {baseDir}/scripts/db_query.py --action submit-purchase-order --purchase-order-id <id>
```

**Receive goods against PO:**
```
python3 {baseDir}/scripts/db_query.py --action create-purchase-receipt --purchase-order-id <id>
```

**Submit purchase receipt (posts SLE + GL):**
```
python3 {baseDir}/scripts/db_query.py --action submit-purchase-receipt --purchase-receipt-id <id>
```

### Procure-to-Pay Flow

| Step | Document | What Happens on Submit |
|------|----------|----------------------|
| 1 | Material Request | Formalizes procurement need |
| 2 | RFQ | Sent to suppliers for pricing |
| 3 | Supplier Quotation | Supplier responds with prices |
| 4 | Purchase Order | Commits to buy from supplier |
| 5 | Purchase Receipt | SLE (+qty) + GL (DR Stock / CR Not Billed) |
| 6 | Purchase Invoice | GL (DR Expense / CR AP) + Tax GL + PLE |
| 7 | Payment | Settles AP via erpclaw-payments |

### The Draft-Submit-Cancel Lifecycle

| Status | Can Update | Can Delete | Can Submit | Can Cancel |
|--------|-----------|-----------|-----------|-----------|
| Draft | Yes | Yes | Yes | No |
| Submitted | No | No | No | Yes |
| Cancelled | No | No | No | No |

## All Actions (Tier 2)

For all actions, use: `python3 {baseDir}/scripts/db_query.py --action <action> [flags]`

All output is JSON to stdout. Parse and format for the user.

### Suppliers (4 actions)

| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `add-supplier` | `--name`, `--company-id` | `--supplier-group`, `--supplier-type`, `--payment-terms-id`, `--tax-id`, `--is-1099-vendor`, `--primary-address` (JSON) |
| `update-supplier` | `--supplier-id` | `--name`, `--payment-terms-id` |
| `get-supplier` | `--supplier-id` | (none) |
| `list-suppliers` | | `--company-id`, `--supplier-group`, `--search`, `--limit` (20), `--offset` (0) |

### Material Requests (3 actions)

| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `add-material-request` | `--request-type` (purchase\|transfer\|manufacture), `--items` (JSON), `--company-id` | (none) |
| `submit-material-request` | `--material-request-id` | (none) |
| `list-material-requests` | | `--company-id`, `--request-type`, `--status` |

### RFQs (3 actions)

| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `add-rfq` | `--items` (JSON), `--suppliers` (JSON), `--company-id` | (none) |
| `submit-rfq` | `--rfq-id` | (none) |
| `list-rfqs` | | `--company-id`, `--status` |

### Supplier Quotations (3 actions)

| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `add-supplier-quotation` | `--rfq-id`, `--supplier-id`, `--items` (JSON with prices) | (none) |
| `list-supplier-quotations` | | `--rfq-id`, `--supplier-id` |
| `compare-supplier-quotations` | `--rfq-id` | (none) |

### Purchase Orders (6 actions)

| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `add-purchase-order` | `--supplier-id`, `--items` (JSON), `--company-id` | `--tax-template-id` |
| `update-purchase-order` | `--purchase-order-id` | `--items` (JSON) |
| `get-purchase-order` | `--purchase-order-id` | (none) |
| `list-purchase-orders` | | `--company-id`, `--supplier-id`, `--status`, `--from-date`, `--to-date` |
| `submit-purchase-order` | `--purchase-order-id` | (none) |
| `cancel-purchase-order` | `--purchase-order-id` | (none) |

### Purchase Receipts (5 actions)

| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `create-purchase-receipt` | `--purchase-order-id` | `--items` (JSON, for partial receipt) |
| `get-purchase-receipt` | `--purchase-receipt-id` | (none) |
| `list-purchase-receipts` | | `--company-id`, `--supplier-id`, `--status` |
| `submit-purchase-receipt` | `--purchase-receipt-id` | (none) |
| `cancel-purchase-receipt` | `--purchase-receipt-id` | (none) |

### Purchase Invoices (6 actions)

| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `create-purchase-invoice` | | `--purchase-order-id`, `--purchase-receipt-id` (or standalone with `--items`) |
| `update-purchase-invoice` | `--purchase-invoice-id` | `--items` (JSON) |
| `get-purchase-invoice` | `--purchase-invoice-id` | (none) |
| `list-purchase-invoices` | | `--company-id`, `--supplier-id`, `--status`, `--from-date`, `--to-date` |
| `submit-purchase-invoice` | `--purchase-invoice-id` | (none) |
| `cancel-purchase-invoice` | `--purchase-invoice-id` | (none) |

### Debit Notes (1 action)

| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `create-debit-note` | `--against-invoice-id`, `--items` (JSON), `--reason` | (none) |

### Landed Costs (1 action)

| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `add-landed-cost-voucher` | `--purchase-receipt-ids` (JSON), `--charges` (JSON), `--company-id` | (none) |

### Cross-Skill (1 action)

| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `update-invoice-outstanding` | `--purchase-invoice-id`, `--amount` | (none) |

### Utility (1 action)

| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `status` | | `--company-id` |

### Quick Command Reference

| User Says | Action |
|-----------|--------|
| "add supplier" / "new vendor" | `add-supplier` |
| "list suppliers" / "show vendors" | `list-suppliers` |
| "create material request" | `add-material-request` |
| "send RFQ" / "request for quotation" | `add-rfq`, `submit-rfq` |
| "compare supplier quotes" | `compare-supplier-quotations` |
| "create purchase order" / "new PO" | `add-purchase-order` |
| "submit PO" / "cancel PO" | `submit-purchase-order`, `cancel-purchase-order` |
| "receive goods" / "GRN" | `create-purchase-receipt` |
| "create vendor bill" / "purchase invoice" | `create-purchase-invoice` |
| "debit note" / "purchase return" | `create-debit-note` |
| "allocate freight" / "landed cost" | `add-landed-cost-voucher` |
| "buying status" / "procurement summary" | `status` |
| "what did we order?" / "pending purchases" | `list-purchase-orders` |
| "who do we owe money to?" | `list-purchase-invoices` (filter: unpaid) |

### Key Concepts

**Perpetual Inventory on Receipt:** `submit-purchase-receipt` posts SLE (+qty) and GL (DR Stock In Hand / CR Stock Received Not Billed) atomically.
**Purchase Invoice GL:** `submit-purchase-invoice` posts DR Expense / CR AP + tax GL + PLE. If `update_stock=1`, also posts SLE.
**Landed Costs:** Allocates freight/customs/insurance proportionally across receipt items, adjusting valuation rates.
**1099 Vendor Support:** Set `--is-1099-vendor` on supplier for US tax reporting compliance.

### Confirmation Requirements

Always confirm before: submitting any document, cancelling any document, creating a debit note.
Never confirm for: creating drafts, listing records, getting details, comparing quotations, status.

**IMPORTANT:** NEVER query the database with raw SQL. ALWAYS use the `--action` flag on `db_query.py`. The actions handle all necessary JOINs, validation, and formatting.

### Proactive Suggestions

| After This Action | Offer |
|-------------------|-------|
| `add-supplier` | "Supplier created. Want to create a purchase order?" |
| `submit-purchase-order` | "PO submitted. Want to create a purchase receipt when goods arrive?" |
| `submit-purchase-receipt` | "SLE and GL posted. Want to create the purchase invoice?" |
| `submit-purchase-invoice` | "Invoice posted to AP. Want to record a payment via erpclaw-payments?" |
| `create-debit-note` | "Debit note created. Want to submit it to adjust the AP balance?" |
| `compare-supplier-quotations` | "Here is the comparison. Want to create a PO with the best supplier?" |
| `status` | If drafts > 0: "You have N draft documents pending submission." |

### Inter-Skill Coordination

- **erpclaw-gl** provides: account table for GL posting, naming series
- **erpclaw-inventory** provides: `create-stock-ledger-entries` / `reverse-stock-ledger-entries` on receipt submit/cancel
- **erpclaw-tax** provides: tax template lookups and tax calculation for invoices
- **erpclaw-payments** settles: AP entries created by purchase invoice submission
- **Shared lib:** `stock_posting.py` (SLE), `gl_posting.py` (GL), `tax_calculation.py` (tax) in `~/.openclaw/erpclaw/lib/`

### Response Formatting

- Suppliers: table with name, group, type, outstanding balance, 1099 status
- Purchase orders/invoices: table with naming series, supplier, total, status, date
- Purchase receipts: table with naming series, supplier, warehouse, items received, status
- Quotation comparison: table with item, supplier, rate, total -- highlight best price
- Currency: `$X,XXX.XX` format. Dates: `Mon DD, YYYY`. Never dump raw JSON.

### Error Recovery

| Error | Fix |
|-------|-----|
| "no such table" | Run `python3 ~/.openclaw/erpclaw/init_db.py --db-path ~/.openclaw/erpclaw/data.sqlite` |
| "Supplier not found" | Check supplier ID with `list-suppliers`; create if needed |
| "Purchase order not submitted" | Receipt/invoice requires a submitted PO; submit it first |
| "Insufficient stock for return" | Check stock before creating debit note with stock reversal |
| "Cannot update: document is submitted" | Only drafts can be updated; cancel first |
| "GL posting failed" | Check account existence, frozen status, fiscal year open via erpclaw-gl |
| "Tax template not found" | Verify template ID via erpclaw-tax `list-tax-templates` |
| "database is locked" | Retry once after 2 seconds |

## Technical Details (Tier 3)

**Tables owned (18):** `supplier`, `material_request`, `material_request_item`, `request_for_quotation`, `rfq_supplier`, `rfq_item`, `supplier_quotation`, `supplier_quotation_item`, `purchase_order`, `purchase_order_item`, `purchase_receipt`, `purchase_receipt_item`, `purchase_invoice`, `purchase_invoice_item`, `landed_cost_voucher`, `landed_cost_item`, `landed_cost_charge`, `supplier_score`

**Script:** `{baseDir}/scripts/db_query.py` -- all 34 actions routed through this single entry point.

**Data conventions:**
- All financial amounts stored as TEXT (Python `Decimal` for precision)
- All IDs are TEXT (UUID4)
- `gl_entry` and `stock_ledger_entry` are IMMUTABLE -- cancel = `is_cancelled` + reversal
- Naming series: `MR-{YEAR}-{SEQ}`, `RFQ-{YEAR}-{SEQ}`, `PO-{YEAR}-{SEQ}`, `PREC-{YEAR}-{SEQ}`, `PINV-{YEAR}-{SEQ}`, `DN-{YEAR}-{SEQ}`

**Shared library:** `~/.openclaw/erpclaw/lib/` -- `stock_posting.py` (SLE), `gl_posting.py` (perpetual inventory + expense GL), `tax_calculation.py` (tax on invoices).
**Atomicity:** Submit/cancel execute SLE + GL + PLE + status update in a single SQLite transaction. Any failure = full rollback.

### Sub-Skills

| Sub-Skill | Shortcut | What It Does |
|-----------|----------|-------------|
| `erp-buying` | `/erp-buying` | Quick purchasing summary |
| `erp-suppliers` | `/erp-suppliers` | List suppliers |
