---
name: ergocare-coach
description: Your personal desk health coach with automated break reminders. Generates platform-specific scripts (bash/PowerShell) for 20-20-20 eye care, lower back exercises, and RSI prevention. Comprehensive exercise routines, ergonomic guidance, and customizable notification systems for computer professionals.
metadata:
  openclaw:
    emoji: "👁️"
    version: "1.0.0"
    author: "AM"
    tags: ["health", "wellness", "ergonomics", "eye-exercises", "break-reminders", "posture", "rsi-prevention", "desk-health", "automation"]
    requires:
      bins: []
      env: []
      config: []
---

# ErgoCare Coach 👁️🦴💪

## Description

Your intelligent desk health and wellness coach that actually reminds you automatically! ErgoCare Coach provides:

1. **Expert Exercise Guidance** - 20-20-20 eye care, lower back stretches, neck exercises, RSI prevention
2. **Platform-Specific Reminder Scripts** - Generates bash scripts (Linux/Mac) and PowerShell scripts (Windows) that run as background processes
3. **Automated Notifications** - Desktop notifications, terminal alerts, sound alerts, visual countdowns
4. **Customizable Schedules** - 20-20-20, hourly breaks, custom intervals, work hour limits
5. **Comprehensive Routines** - From 30-second micro-breaks to 10-minute full routines

**"The greatest wealth is Health."**

Perfect for:
- 💻 Computer professionals working long hours
- 👁️ Anyone experiencing eye strain or dry eyes  
- 🦴 People with lower back, neck, or shoulder pain
- 🎮 Gamers and content creators
- 📚 Students and researchers
- 🏢 Remote workers and desk workers
- 🩺 Anyone wanting to prevent RSI and chronic issues

---

## How This Skill Works

### Two Modes of Operation

**Mode 1: Interactive Exercise Coach**
- Ask for specific exercises anytime: "Show me eye exercises"
- Get instant guidance: "I have neck pain, what should I do?"
- Learn routines: "Give me a 5-minute full body desk stretch"

**Mode 2: Automated Reminder Scripts** ⭐ **NEW!**
- Request a custom script: "Generate a 20-20-20 reminder script for Mac"
- Get platform-specific code (bash/PowerShell) ready to run
- Scripts run in background, send notifications automatically
- Fully customizable intervals and exercise types

---

## 1. Quick Start: Get Your Reminder Script

### Request Your Custom Script

Just ask ErgoCare Coach:

```
"Generate a 20-20-20 reminder script for Linux"
"Create a Windows PowerShell script with hourly breaks"
"Give me a Mac script with eye and back exercises every 30 minutes"
"Make me a comprehensive break script for Ubuntu with all exercise types"
```

### Script Features

**All Scripts Include:**
- ✅ Desktop notifications with exercise instructions
- ✅ Countdown timers between breaks
- ✅ Sound alerts (optional, can be disabled)
- ✅ Customizable intervals
- ✅ Multiple exercise types embedded
- ✅ Easy start/stop/restart
- ✅ Run on system startup (optional)

**Platform Support:**
- 🐧 **Linux**: bash script with `notify-send`, `zenity`, or terminal alerts
- 🍎 **macOS**: bash script with `osascript` notifications and `say` voice alerts
- 🪟 **Windows**: PowerShell with `BurntToast` module or native notifications

---

## 2. The 20-20-20 Rule (Eye Care Foundation)

### What It Is

**Every 20 minutes, look at something 20 feet away for at least 20 seconds.**

### Why It Works

When you focus on a screen, your eye muscles maintain constant tension:
- **Ciliary muscles** stay contracted to focus at close range
- **Extraocular muscles** hold fixed position
- **Blinking rate drops** from 15-20/min to 5-7/min (causing dry eyes)
- **Blue light exposure** increases eye fatigue

Looking into the distance:
- ✅ Relaxes ciliary muscles
- ✅ Triggers natural blinking
- ✅ Resets focus mechanism
- ✅ Reduces strain accumulation

### 20-20-20 Implementation

**Your automated script will:**
1. Run silently in background
2. Track 20-minute intervals
3. Send desktop notification: "👁️ 20-20-20 Break: Look 20 feet away for 20 seconds"
4. (Optional) Play gentle sound alert
5. (Optional) Show countdown timer
6. Repeat every 20 minutes

**Manual 20-20-20:**
- Window view (buildings, trees, sky)
- Hallway or room far end  
- Distant wall clock or artwork
- Outside through open door
- Anything genuinely 20+ feet away

---

## 3. Eye Exercise Library

### Quick Blink Reset (30 seconds)
**When to use:** Every hour, or when eyes feel dry

```
1. Close eyes gently (don't squeeze) - 2 seconds
2. Open eyes wide - 2 seconds  
3. Repeat 10 times
4. Finish with 10 rapid blinks

Benefits: Refreshes tear film, prevents dry eyes
```

### Palming (1-2 minutes)
**When to use:** Mid-morning, after lunch, mid-afternoon

```
1. Rub palms together until warm
2. Cup palms over closed eyes (don't press)
3. Block all light completely
4. Breathe deeply for 60-120 seconds
5. Slowly remove hands

Benefits: Deep relaxation, reduces eye fatigue
```

### Eye Rolls (45 seconds)
**When to use:** Every 2 hours

```
1. Look up, pause 2 seconds
2. Slowly roll eyes clockwise (full circle) - 3 seconds
3. Pause, center
4. Slowly roll eyes counterclockwise - 3 seconds
5. Repeat 5 times each direction

Benefits: Exercises all eye muscles, increases range of motion
```

### Focus Shifting (1 minute)
**When to use:** Every hour

```
1. Hold finger 10 inches from your face
2. Focus on finger - 5 seconds
3. Shift focus to object 20 feet away - 5 seconds
4. Repeat 10 times

Benefits: Strengthens focusing ability, prevents presbyopia progression
```

### Figure Eight (1 minute)
**When to use:** Mid-day, when feeling strain

```
1. Imagine a large figure 8 on the wall (10 feet away)
2. Trace it slowly with your eyes (don't move head) - 30 seconds clockwise
3. Trace it 30 seconds counterclockwise
4. Repeat 2 times

Benefits: Improves eye coordination and flexibility
```

### Near-Far Focus (1 minute)
**When to use:** Every 90 minutes

```
1. Hold thumb at arm's length
2. Focus on thumb - 10 seconds
3. Focus on something 20+ feet away - 10 seconds
4. Repeat 5 times

Benefits: Reduces accommodation stress
```

---

## 4. Lower Back Exercise Library

### Seated Spinal Twist (1 minute each side)
**When to use:** Every hour

```
1. Sit up straight, feet flat on floor
2. Place right hand on back of chair
3. Place left hand on right knee
4. Inhale: lengthen spine
5. Exhale: twist to the right
6. Hold 30 seconds, breathe normally
7. Repeat on left side

Benefits: Relieves lower back tension, improves spine mobility
```

### Seated Cat-Cow (1 minute)
**When to use:** Every 45-60 minutes

```
1. Sit on edge of chair, hands on knees
2. Inhale: arch back, look up (cow)
3. Exhale: round back, tuck chin (cat)
4. Flow between positions 10 times slowly
5. Hold each position 3 seconds

Benefits: Mobilizes entire spine, reduces stiffness
```

### Standing Hip Hinge (45 seconds)
**When to use:** Every 90 minutes

```
1. Stand with feet hip-width apart
2. Place hands on lower back
3. Hinge forward at hips (not waist)
4. Keep back straight, slight knee bend
5. Go until you feel stretch in hamstrings
6. Hold 15 seconds
7. Slowly return to standing
8. Repeat 3 times

Benefits: Stretches hamstrings, strengthens lower back
```

### Seated Forward Fold (1 minute)
**When to use:** Mid-morning, after lunch

```
1. Sit on edge of chair
2. Feet hip-width apart, flat on floor
3. Inhale: lengthen spine
4. Exhale: fold forward from hips
5. Let arms hang, relax neck and shoulders
6. Hold 30-60 seconds
7. Slowly roll up, vertebra by vertebra

Benefits: Decompresses spine, relieves lower back
```

### Pelvic Tilts (1 minute)
**When to use:** Every 2 hours

```
1. Sit with back against chair, feet flat
2. Tilt pelvis forward (arch lower back)
3. Hold 5 seconds
4. Tilt pelvis backward (flatten lower back against chair)
5. Hold 5 seconds
6. Repeat 10 times

Benefits: Strengthens core, mobilizes pelvis
```

### Standing Quad Stretch with Back Extension (1 minute each side)
**When to use:** Every 2 hours

```
1. Stand near chair for support
2. Bend right knee, grab right ankle behind you
3. Gently pull heel toward glutes
4. Simultaneously press hips forward
5. Hold 30 seconds
6. Repeat on left side

Benefits: Stretches hip flexors, counteracts sitting posture
```

---

## 5. Neck & Shoulder Exercise Library

### Neck Rolls (1 minute)
**When to use:** Every 45 minutes

```
1. Sit or stand with relaxed shoulders
2. Drop chin to chest - 5 seconds
3. Slowly roll head to right shoulder - 5 seconds
4. Roll head back (don't force) - 5 seconds
5. Roll to left shoulder - 5 seconds
6. Return to center
7. Repeat 3 times each direction

Benefits: Releases neck tension, improves mobility
```

### Shoulder Shrugs (45 seconds)
**When to use:** Every hour

```
1. Inhale: raise shoulders to ears
2. Hold 5 seconds (squeeze)
3. Exhale: drop shoulders down and back
4. Hold 5 seconds (relax)
5. Repeat 10 times

Benefits: Relieves shoulder tension, improves posture
```

### Neck Side Stretch (1 minute each side)
**When to use:** Every 90 minutes

```
1. Sit up straight
2. Place right hand on left side of head
3. Gently pull head toward right shoulder
4. Keep left shoulder down
5. Hold 30 seconds
6. Repeat on left side

Benefits: Stretches neck muscles, reduces headaches
```

### Chin Tucks (1 minute)
**When to use:** Every 2 hours

```
1. Sit or stand with good posture
2. Keep eyes forward
3. Gently tuck chin (double chin appearance)
4. Don't tilt head down
5. Hold 5 seconds
6. Relax
7. Repeat 10 times

Benefits: Strengthens neck, counteracts forward head posture
```

### Shoulder Blade Squeeze (45 seconds)
**When to use:** Every hour

```
1. Sit up straight, arms at sides
2. Squeeze shoulder blades together
3. Imagine holding a pencil between them
4. Hold 5 seconds
5. Relax 5 seconds
6. Repeat 10 times

Benefits: Strengthens upper back, improves posture
```

---

## 6. Wrist & Hand Exercise Library (RSI Prevention)

### Wrist Circles (45 seconds)
**When to use:** Every 60 minutes

```
1. Extend arms forward
2. Make gentle circles with wrists
3. 10 circles clockwise
4. 10 circles counterclockwise
5. Rest
6. Repeat 2 times

Benefits: Prevents carpal tunnel, increases wrist mobility
```

### Finger Stretches (1 minute)
**When to use:** Every 90 minutes

```
1. Extend right arm, palm up
2. With left hand, gently pull back each finger
3. Hold each 5 seconds
4. Repeat on left hand
5. Then: make fist, spread fingers wide - 10 times

Benefits: Prevents trigger finger, reduces hand stiffness
```

### Prayer Stretch (45 seconds)
**When to use:** Every 2 hours

```
1. Press palms together in front of chest (prayer position)
2. Fingers pointing up
3. Slowly lower hands toward waist
4. Keep palms pressed together
5. Stop when you feel stretch in wrists
6. Hold 30 seconds

Benefits: Stretches wrist flexors, prevents carpal tunnel
```

### Reverse Prayer Stretch (45 seconds)
**When to use:** Every 2 hours (after Prayer Stretch)

```
1. Place backs of hands together in front of chest
2. Fingers pointing down
3. Press hands together
4. Hold 30 seconds

Benefits: Stretches wrist extensors
```

### Fist Pumps (30 seconds)
**When to use:** Every hour

```
1. Make tight fist
2. Hold 5 seconds
3. Open hand, spread fingers wide
4. Hold 5 seconds
5. Repeat 10 times

Benefits: Increases blood flow, reduces stiffness
```

---

## 7. Full Body Desk Routines

### 2-Minute Quick Reset
**When to use:** Every 30 minutes

```
1. 20-20-20 eye break (20 seconds)
2. Shoulder shrugs (20 seconds)
3. Neck side stretches (30 seconds)
4. Seated spinal twist (30 seconds)
5. Wrist circles (20 seconds)

Total: 2 minutes
```

### 5-Minute Energy Break
**When to use:** Every 90 minutes

```
1. Palming (1 minute)
2. Seated cat-cow (1 minute)
3. Neck rolls (1 minute)
4. Standing hip hinge (45 seconds)
5. Shoulder blade squeezes (45 seconds)
6. Wrist and finger stretches (30 seconds)

Total: 5 minutes
```

### 10-Minute Full Routine
**When to use:** Mid-morning, after lunch, mid-afternoon

```
1. Eye exercises (2 minutes):
   - Focus shifting
   - Eye rolls
   - 20-20-20
   
2. Neck and shoulders (3 minutes):
   - Neck rolls
   - Shoulder shrugs
   - Neck side stretches
   - Chin tucks
   
3. Back and core (3 minutes):
   - Seated cat-cow
   - Seated spinal twists
   - Standing hip hinge
   - Pelvic tilts
   
4. Wrists and hands (2 minutes):
   - Wrist circles
   - Prayer stretches
   - Finger stretches
   - Fist pumps

Total: 10 minutes
```

---

## 8. Example Break Schedules

### Light User (4-6 hours computer/day)

```
Every 20 minutes: 20-20-20 eye break (20 seconds)
Every 60 minutes: 2-minute quick reset
Every 2 hours: 5-minute energy break

Daily total breaks: ~40 minutes
```

### Moderate User (6-8 hours computer/day)

```
Every 20 minutes: 20-20-20 eye break (20 seconds)
Every 45 minutes: 2-minute quick reset  
Every 90 minutes: 5-minute energy break
Mid-morning + afternoon: 10-minute full routine (2x)

Daily total breaks: ~60 minutes
```

### Heavy User (8+ hours computer/day) - **RECOMMENDED**

```
Every 20 minutes: 20-20-20 eye break (20 seconds)
Every 30 minutes: 2-minute quick reset
Every 60 minutes: 5-minute energy break
Every 3 hours: 10-minute full routine
Lunch break: 30-minute walk (away from computer)

Daily total breaks: ~90 minutes
```

---

## 9. Script Generation Guide

### Linux/Mac Bash Script Request

**What to ask:**
```
"Generate a 20-20-20 reminder script for Linux"
"Create a Mac bash script with full break schedule"
"Make me an Ubuntu script with eye and back exercises every 45 minutes"
```

**What you'll get:**
- Bash script using `notify-send` (Linux) or `osascript` (Mac)
- Embedded exercise instructions in notifications
- Sound alerts using `paplay` or `say`
- Countdown timer in terminal
- Easy customization variables
- Installation instructions

**Features:**
- Run in background (`./ergocare.sh &`)
- Add to startup (`crontab @reboot`)
- Stop script (`pkill -f ergocare.sh`)
- Logs breaks to file (optional)

### Windows PowerShell Script Request

**What to ask:**
```
"Generate a Windows break reminder script"
"Create a PowerShell script for 20-20-20 with hourly stretches"
"Make me a Windows script with all exercise types"
```

**What you'll get:**
- PowerShell script with native notifications
- BurntToast module integration (better notifications)
- Sound alerts using `[System.Media.SystemSounds]`
- System tray icon (optional)
- Task Scheduler setup instructions

**Features:**
- Run on startup (Task Scheduler)
- Minimize to system tray
- Pause/resume functionality
- Break history logging

### Script Customization Variables

All generated scripts include easy-to-edit variables at the top:

```bash
# CONFIGURATION (edit these)
EYE_INTERVAL=1200        # 20 minutes in seconds
STRETCH_INTERVAL=2700    # 45 minutes
LONG_BREAK_INTERVAL=5400 # 90 minutes
SOUND_ENABLED=true       # true or false
NOTIFICATION_TYPE="all"  # "popup", "sound", "terminal", "all"
```

---

## 10. Ergonomic Workspace Setup

### Monitor Position
- **Height**: Top of screen at or slightly below eye level
- **Distance**: Arm's length away (20-28 inches / 50-70 cm)
- **Angle**: Tilted 10-20 degrees back
- **Multiple monitors**: Primary monitor directly in front

### Chair Setup
- **Seat height**: Feet flat on floor, thighs parallel to ground
- **Seat depth**: 2-4 inches between seat edge and back of knees
- **Backrest**: Supports natural curve of lower back (lumbar support)
- **Armrests**: Elbows at 90 degrees, shoulders relaxed

### Desk & Keyboard
- **Desk height**: Elbows at 90-100 degrees when typing
- **Keyboard**: Flat or slight negative tilt, close to body
- **Mouse**: Same height as keyboard, close to body
- **Wrist position**: Neutral (straight), not bent up/down or sideways

### Lighting
- **No glare**: Position monitor 90 degrees to windows
- **Task lighting**: Reduce contrast between screen and surroundings
- **Blue light filter**: Enabled after sunset (f.lux, Night Light)
- **Screen brightness**: Match ambient light level

---

## 11. Warning Signs & When to See a Doctor

### Immediate medical attention needed:
- 🚨 Sudden vision loss or changes
- 🚨 Severe eye pain
- 🚨 Numbness or tingling that spreads or worsens
- 🚨 Loss of bowel/bladder control (back issues)
- 🚨 Weakness in arms or legs

### See doctor soon if experiencing:
- ⚠️ Persistent headaches (daily for weeks)
- ⚠️ Double vision or blurred vision that doesn't improve with rest
- ⚠️ Pain that radiates down arms or legs
- ⚠️ Chronic pain lasting more than 6 weeks
- ⚠️ Pain that worsens despite exercises and breaks

### ErgoCare Coach is preventive, not treatment!
- ✅ Use for prevention and mild discomfort
- ✅ Maintain healthy habits
- ❌ Don't use instead of medical treatment
- ❌ Don't ignore severe or worsening symptoms

---

## 12. Advanced Features

### Smart Break Scheduling

**Request context-aware schedules:**
```
"I'm a software developer, create my ideal break schedule"
"I have chronic neck pain, what's my schedule?"
"I'm a gamer, help me stay healthy during long sessions"
```

**You'll get:**
- Profession-specific recommendations
- Condition-specific exercise focus
- Customized intervals based on research
- Integration with work methodologies (Pomodoro, etc.)

### Multi-Platform Sync

**For users with multiple devices:**
```
"Generate scripts for Linux work machine and Windows home PC"
```

**You'll get:**
- Matched intervals across platforms
- Same exercise routines
- Consistent notification style
- Easy setup on both systems

### Team/Office Deployment

**For IT administrators:**
```
"Create a company-wide break reminder script for Ubuntu 22.04"
"Generate Windows script for deployment via Group Policy"
```

**You'll get:**
- Silent installation
- Central configuration
- Deployment documentation
- User guide for employees

---

## 13. Best Practices

### Building the Break Habit

**Week 1: 20-20-20 only**
- Focus on just eye breaks
- Build the basic habit
- Set phone timer as backup

**Week 2: Add micro-breaks**
- Every 30-60 minutes
- 2-minute quick reset
- Getting comfortable with interruptions

**Week 3: Add stretch breaks**
- Every 90 minutes
- 5-minute energy break
- Learning the exercises

**Week 4: Full routine**
- All break types
- Integrated into workflow
- Feels natural

### Staying Motivated

- Track breaks with calendar blocking
- Notice improvements (less pain, better focus)
- Make it social (break buddies)
- Adjust schedule if too intrusive
- Remember: **prevention is easier than recovery**

### Integration with Work

**Pomodoro Technique users:**
- Use Pomodoro breaks for micro-exercises
- Every 25 min work = 5 min break = perfect for 2-minute reset
- Every 4 Pomodoros = long break = 10-minute full routine

**Meeting-heavy days:**
- Set script to "work hours only" mode
- Pause during important meetings
- Resume after
- Use breaks between meetings

**Deep work sessions:**
- Reduce frequency (but don't eliminate!)
- Eye breaks still every 20 minutes
- Longer breaks every 2 hours instead of 1
- Extra-long break after deep work session

---

## When to Use This Skill

### Interactive Mode:
- "I've been coding for 3 hours, what exercises should I do?"
- "My eyes are burning, help!"
- "Show me a 30-second desk stretch"
- "I have lower back pain, what do I do?"

### Script Generation Mode:
- "Generate my custom reminder script"
- "Create a break schedule for my work style"
- "Give me installation instructions for the script"
- "How do I make this run on startup?"

### Learning Mode:
- "Explain the 20-20-20 rule"
- "Why do I need breaks?"
- "How should I set up my desk?"
- "What are the warning signs of RSI?"

---

**Your health is your most valuable asset. Small breaks today prevent big problems tomorrow. Let ErgoCare Coach help you build sustainable healthy habits!**

👁️ "Take care of your eyes—they're the only pair you get."
🦴 "Your spine will thank you in 20 years."
💪 "Prevention beats cure. Every. Single. Time."

🔔 **Ready to start? Ask for your custom break reminder script now!** 🔔
