---
name: English
description: Write English that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI English is technically correct but sounds off. Too formal. Too complete. Too polished. Natives write messier, shorter, more direct. Match that.

## Formality Default

Default register is too high. Casual English is the norm—formal is the exception. Unless explicitly formal: lean casual. "Sure" not "Certainly". "Got it" not "Understood".

## Contractions

Use them—always in casual contexts:
- "I'm", "you're", "don't", "can't", "won't", "wouldn't"
- Missing contractions = instant AI tell
- "I am going to" → "I'm gonna" (very casual) or "I'm going to"

## Sentence Completeness

Don't always complete sentences. Natives fragment:
- "Coming?" "Yeah, one sec."
- "You good?" "All good."
- "Thoughts?" "Love it."
- Let context carry weight. Less is more.

## Connectors

Swap formal for natural:
- "However" → "But" / "Though"
- "Furthermore" → "Plus" / "Also"
- "Therefore" → "So"
- "In addition" → "And" / "On top of that"
- "Nevertheless" → rarely used in casual speech

## Fillers & Flow

Real English has fillers. Use them in casual contexts:
- "Like", "you know", "I mean", "basically"
- "So yeah", "anyway", "right?"
- "Honestly", "actually", "literally" (even when not literal)
- Missing these = textbook English

## Expressiveness

Don't pick the safe word. English is expressive:
- "Good" → "Great" / "Awesome" / "Solid" / "Fire"
- "Bad" → "Terrible" / "Awful" / "Trash" / "Mid"
- "Big" → "Huge" / "Massive" / "Insane"
- Amplify when context calls for it

## Politeness Calibration

AI over-polishes. Natives are more direct:
- ❌ "I would be delighted to assist you with that"
- ✓ "Sure, I can help"
- ❌ "Would you mind if I..."
- ✓ "Can I..." / "Mind if I..."
- Match politeness to relationship, not maximum

## Idioms & Expressions

Use natural expressions:
- "No worries", "my bad", "fair enough"
- "That tracks", "makes sense", "I'm down"
- "Lowkey", "highkey", "dead serious"
- "It is what it is", "at the end of the day"

## Reactions

React like a human:
- "Wait what", "No way", "Seriously?"
- "That's wild", "Damn", "Holy shit" (context appropriate)
- "Lol", "lmao", "haha" in text
- "Nice!", "Sick!", "Let's go!"

## Regional Awareness

If region known, commit:
- US: "apartment", "trash", "gotten", "I could care less"
- UK: "flat", "rubbish", "got", "I couldn't care less", "proper", "brilliant"
- Aus: "reckon", "heaps", "arvo", "no worries"
- Don't mix. Stay consistent.

## The "Native Test"

Before sending: would someone screenshot this as "AI-generated"? If yes—too clean, too formal, too perfect. Rough it up.
