# Vocabulary Lists by Topic

## Teaching Method for Each Word
Always provide:
1. 🔤 Word + pronunciation guide (Hebrew transliteration if helpful)
2. 🇮🇱 Hebrew translation
3. 📖 Natural example sentence (not textbook-style)
4. 🤝 Common collocation or phrase
5. 🧠 Memory trick (sound-alike in Hebrew, visual, association, coding analogy)

## Prioritization
- Teach high-frequency words first
- Prefer words the student is likely to encounter in daily life and work
- Connect to student's interests (programming, tech) when possible

---

## 1. Daily Routine
wake up, get dressed, commute, schedule, deadline, take a break, run errands, grab lunch, work out, unwind, oversleep, rush, skip (a meal), multitask, prioritize

**Collocations:** tight schedule, meet a deadline, run some errands, work out at the gym, unwind after work

## 2. Food & Cooking
ingredients, recipe, chop, stir, boil, bake, seasoning, portion, leftovers, takeout, bland, spicy, raw, homemade, starving

**Collocations:** follow a recipe, generous portion, heat up leftovers, order takeout, from scratch

## 3. Travel
destination, itinerary, boarding pass, layover, accommodation, sightseeing, currency, luggage, departure, customs, jet lag, round trip, one-way, off the beaten path, touristy

**Collocations:** popular destination, packed itinerary, declare at customs, overcome jet lag, off the beaten path

## 4. Work & Career
colleague, deadline, promotion, salary, resign, hire, meeting, feedback, remote, responsibilities, workload, performance, raise, fired/laid off, internship

**Collocations:** constructive feedback, work remotely, heavy workload, annual performance review, get promoted

## 5. Technology
update, install, crash, backup, password, device, bandwidth, download, troubleshoot, notification, bug, lag, encrypt, stream, sync

**Collocations:** software update, system crash, strong password, push notification, troubleshoot the issue

## 6. Health & Body
symptoms, prescription, appointment, dizzy, swollen, ache, diagnose, recover, allergy, injury, dose, chronic, contagious, checkup, side effects

**Collocations:** mild symptoms, fill a prescription, make an appointment, full recovery, side effects

## 7. Emotions & Feelings
anxious, relieved, frustrated, grateful, overwhelmed, confident, embarrassed, curious, jealous, exhausted, thrilled, irritated, nostalgic, insecure, moody

**Collocations:** deeply grateful, completely overwhelmed, mildly irritated, feel relieved, emotionally exhausted

## 8. Shopping & Money
discount, receipt, exchange, afford, bargain, budget, expensive, checkout, refund, worth, rip-off, on sale, overpriced, splurge, broke (informal)

**Collocations:** on a tight budget, it's worth it, get a refund, total rip-off, can't afford it

## 9. Home & Living
lease, landlord, utilities, furniture, renovate, spacious, neighborhood, maintenance, cozy, storage, mortgage, tenant, evict, settle in, move out

**Collocations:** sign a lease, pay utilities, settle in, cozy apartment, friendly neighborhood

## 10. Social & Relationships
acquaintance, gossip, trustworthy, apologize, compromise, supportive, boundary, introduce, argument, reconnect, bond, drift apart, hang out, get along, toxic

**Collocations:** set boundaries, reach a compromise, drift apart over time, hang out with friends, get along well

## 11. Weather & Nature
forecast, humid, breeze, drought, flood, temperature, sunrise, shade, season, storm, heatwave, freezing, mild, pour (rain), clear up

**Collocations:** weather forecast, light breeze, heavy storm, pouring rain, it cleared up

## 12. Entertainment & Hobbies
binge-watch, podcast, rehearsal, exhibition, plot, spoiler, genre, recommend, subscribe, review, addictive, overrated, sequel, release, marathon (watching)

**Collocations:** binge-watch a series, no spoilers please, highly recommended, subscribe to a channel, movie marathon

## 13. Education & Learning
assignment, tutor, semester, workshop, certificate, curriculum, skill, progress, fluent, comprehension, drop out, enroll, cram, hands-on, self-taught

**Collocations:** make progress, hands-on experience, become fluent, cram for an exam, self-taught developer

## 14. Transportation
commute, fare, route, traffic jam, pedestrian, intersection, parking, detour, rush hour, carpool, public transport, miss the bus, transfer, one-way street, congestion

**Collocations:** daily commute, stuck in traffic, rush hour traffic, take a detour, miss the bus

## 15. Legal & Formal
contract, witness, sue, penalty, regulation, evidence, attorney, consent, liable, comply, violation, fine, terms and conditions, dispute, enforce

**Collocations:** sign a contract, breach of contract, comply with regulations, file a lawsuit, terms and conditions

## 16. Opinions & Arguments
agree, disagree, perspective, evidence, claim, bias, reasonable, convince, debate, conclusion, assumption, valid point, exaggerate, generalize, open-minded

**Collocations:** from my perspective, valid point, strong evidence, reach a conclusion, open-minded approach

## 17. Work Communication
update, follow up, clarify, escalate, delegate, postpone, confirm, agenda, minutes (meeting), cc/loop in, heads-up, actionable, bottom line, circle back, recap

**Collocations:** quick update, follow up on this, let me clarify, send the agenda, give a heads-up

## 18. Programming & Tech (for the developer)
refactor, deploy, debug, merge, branch, dependency, deprecated, edge case, boilerplate, scalable, iterate, overhead, regression, endpoint, parse

**Collocations:** deploy to production, merge a PR, edge case handling, boilerplate code, breaking change

## 19. Idioms & Expressions (Teach gradually)
- "Break the ice" = to start a conversation in a social situation
- "Hit the nail on the head" = to be exactly right
- "It's not rocket science" = it's not that complicated
- "Piece of cake" = very easy
- "Under the weather" = feeling sick
- "Cost an arm and a leg" = very expensive
- "Call it a day" = stop working for today
- "On the same page" = in agreement / synchronized
- "The ball is in your court" = it's your turn to act
- "Burn the midnight oil" = work late into the night
- "Bite off more than you can chew" = take on too much
- "Cut to the chase" = get to the point
- "Go the extra mile" = make extra effort
- "Sleep on it" = think about it overnight
- "Pull someone's leg" = joke with someone / tease

---

## Usage Notes
- Teach 5-7 words per session
- Always include memory tricks — they make the difference
- Prioritize words the student is likely to use in their own life
- Mix new words with review words (spaced repetition from vocabulary-bank.json)
- Challenge students to USE new words in sentences, not just recognize them
- Every 3rd vocabulary lesson, do a "cumulative mini-quiz" on old words
