# Grammar Curriculum — Pre-Intermediate

## Teaching Philosophy
Never teach grammar in a vacuum. Every rule should be connected to a real situation the student might encounter. Start with "why does this matter?" before "here's the rule."

---

## Phase 1: Foundations (Lessons 1-10)

### 1. Present Simple vs Present Continuous
- **Hook:** "I work at Google" vs "I'm working at Google right now" — same person, different meanings!
- When to use each tense
- Signal words: always/usually/every day vs now/right now/at the moment
- Common Hebrew-speaker mistakes: "I am work" ← because Hebrew doesn't distinguish
- **Memory trick:** NOW = ING. If there's a "now", add ING.

### 2. Past Simple — Regular Verbs
- **Hook:** "Tell me about your weekend — oh wait, you need Past Simple for that!"
- Three -ed pronunciations: /t/ (worked), /d/ (played), /ɪd/ (wanted)
- Negative: didn't + base form (NOT "didn't worked")
- Questions: Did you + base form
- Time expressions: yesterday, last week, two days ago, in 2020

### 3. Past Simple — Irregular Verbs
- **Hook:** "English is crazy — 'go' becomes 'went'? Let's tame this beast."
- Top 30 survival verbs:
  go→went, see→saw, take→took, get→got, make→made, come→came, know→knew, think→thought, tell→told, find→found, give→gave, have→had, say→said, do→did, eat→ate, drink→drank, buy→bought, bring→brought, feel→felt, leave→left, meet→met, read→read(!), run→ran, send→sent, sit→sat, sleep→slept, speak→spoke, stand→stood, write→wrote, break→broke
- **Practice:** Storytelling exercise — tell a story using 10 of these verbs

### 4. Future: Will vs Going To
- **Hook:** "Your friend calls. 'The doorbell rang.' You say: 'I'll get it!' — not 'I'm going to get it.' Why?"
- **Going to** = plans, intentions, evidence-based predictions
- **Will** = spontaneous decisions, promises, general predictions
- Common mistake: "I will to go" ← no 'to' after will!
- **Memory trick:** Plan = going to. Spontaneous = will.

### 5. Articles: a/an/the/zero
- **Hook:** "In Hebrew there's only ה'. English has FOUR options. Let's sort this out."
- First mention: a/an → "I saw a dog"
- Known/specific: the → "The dog was cute"
- General truths: zero → "Dogs are friendly"
- No article: countries, meals, sports, languages (mostly)
- **This is a long-term topic** — revisit often, Hebrew speakers struggle with this

### 6. Prepositions of Time
- **Hook:** Think of it like this — AT is a point, IN is inside a box, ON is on a surface
- **at:** specific times (at 3pm), night, the weekend, the moment
- **on:** days (on Monday), dates (on March 5th), specific days (on my birthday)
- **in:** months (in July), years (in 2024), parts of day (in the morning — BUT at night!)
- **Memory trick:** AT = point, ON = surface/day, IN = inside a period

### 7. Prepositions of Place
- **Hook:** "Are you IN the bus or ON the bus? (Both are used — but differently!)"
- **in:** enclosed spaces (in the room, in the car, in Tel Aviv)
- **on:** surfaces and transport lines (on the table, on the bus, on the 3rd floor)
- **at:** specific points/buildings (at home, at work, at the station, at the door)
- Common combos to memorize: at home, at work, at school, in bed, on the phone

### 8. Comparatives & Superlatives
- **Hook:** "Tel Aviv is HOT. But Eilat is HOTTER. And Death Valley is THE HOTTEST."
- Short words: -er/-est (big→bigger→biggest)
- Long words: more/most (expensive→more expensive→most expensive)
- Irregulars: good→better→best, bad→worse→worst, far→further→furthest
- **as...as:** "She's as tall as me" / "It's not as good as I expected"
- Double comparative: "The more you practice, the better you get"

### 9. Modal Verbs: Can, Should, Must, Have to
- **Hook:** "Your boss says 'You must finish today.' Your friend says 'You should try this restaurant.' Very different energy."
- **can/can't** = ability + permission
- **should/shouldn't** = advice (softer)
- **must/mustn't** = strong obligation/prohibition
- **have to/don't have to** = external obligation / no obligation (≠ mustn't!)
- Key: "You mustn't smoke here" (forbidden) vs "You don't have to come" (your choice)

### 10. Countable vs Uncountable + Quantifiers
- **Hook:** "Why can't you say 'an advice' or 'many informations'? Welcome to English logic."
- Common uncountables: advice, information, news, furniture, luggage, money, music, traffic, weather, work
- **some/any:** some (positive), any (negative/questions)
- **much/many:** much (uncountable), many (countable)
- **a lot of:** works for both — the safe choice!
- **a few / a little:** positive. **few / little:** negative ("we have little time" = bad)

---

## Phase 2: Expansion (Lessons 11-20)

### 11. Present Perfect — Introduction
- **Hook:** "I've BEEN to London" = at some point in my life. "I WENT to London" = specific time. The difference matters!"
- Form: have/has + past participle
- Key words: ever, never, already, yet, just, recently
- **NOT** with specific time expressions (yesterday, last week, in 2020)
- **This is the hardest topic for Hebrew speakers.** Go slow. Many examples.

### 12. Present Perfect vs Past Simple — The Battle
- **Hook:** Give the same scenario, ask which tense — let them feel the difference
- Present Perfect: experience, unfinished time, result matters now
- Past Simple: specific time, finished time, story/sequence
- "I've lost my keys" (= I still don't have them) vs "I lost my keys yesterday" (= narrative)
- **Practice:** 10 situations — student picks the right tense

### 13. First Conditional
- **Hook:** "If it rains tomorrow, I'll take an umbrella. — real possibility, real plan."
- Structure: If + present simple → will + base form
- Variations: might/can instead of will
- Common mistake: "If it will rain" ← NO! Present tense after IF.
- **Memory trick:** No WILL after IF (usually)

### 14. Second Conditional — Introduction
- **Hook:** "If I HAD a million dollars, I WOULD travel the world. — But I don't have it. It's a dream."
- Structure: If + past simple → would + base form
- The "were" rule: "If I were you..." (formal) vs "If I was you..." (informal)
- Difference from first conditional: real vs imaginary

### 15. Passive Voice — Basic
- **Hook:** "The window was broken. — Who broke it? We don't know. That's why passive exists."
- Form: be + past participle
- When to use: focus on action/result, doer unknown or unimportant
- Active → Passive conversion practice
- Common in news, formal writing, tech documentation

### 16. Relative Clauses
- **Hook:** "The man WHO lives next door is a doctor. — One sentence instead of two!"
- who (people), which (things), that (both), where (places)
- Defining: "The book THAT I bought" (essential info, no commas)
- Non-defining: "My sister, WHO lives in London, is visiting" (extra info, commas)

### 17. Reported Speech — Basic
- **Hook:** "Your friend said something. Now you tell someone else. The tenses shift back."
- Direct: "I am happy" → Reported: He said he WAS happy
- Tense backshift: am→was, will→would, can→could, present→past
- Reporting verbs: said, told, asked, explained, mentioned

### 18. Gerunds vs Infinitives
- **Hook:** "I enjoy SWIMMING. I want TO SWIM. Why different? English is weird."
- Gerund after: enjoy, avoid, finish, mind, suggest, keep, consider
- Infinitive after: want, need, decide, plan, hope, agree, refuse, learn
- Both (different meaning): stop doing vs stop to do, remember doing vs remember to do
- **Tip:** When in doubt, gerund after prepositions always works: "interested IN learning"

### 19. Phrasal Verbs — Common
- **Hook:** "LOOK. Simple word. But: look UP, look AFTER, look INTO, look FORWARD TO... all different meanings!"
- Top 20 survival phrasal verbs:
  look up, give up, turn on/off, pick up, put off, come up with, figure out, run out of, get along with, look forward to, take off, break down, set up, show up, work out, point out, bring up, go through, make up, cut down
- Separable vs inseparable
- **Practice:** Match the phrasal verb to the situation

### 20. Question Formation — Advanced
- **Hook:** "In Hebrew you just add a question mark. In English, the word order changes. Let's master this."
- Yes/No questions: Do/Does/Did + subject + verb
- Wh- questions: What/Where/When/Why/How + auxiliary + subject + verb
- Subject questions: "WHO called you?" (no auxiliary needed)
- Indirect/polite questions: "Could you tell me WHERE the station IS?" (no inversion!)

---

## Phase 3: Confidence (Lessons 21-30)

### 21. Past Continuous
- **Hook:** "I WAS WALKING home when it STARTED to rain. — Background action + interruption."
- Use with Past Simple for storytelling

### 22. Used to + Would (Past Habits)
- **Hook:** "I USED TO play football every day. — But not anymore. Nostalgia tense."
- used to = past states AND habits, would = only repeated actions

### 23. Present Perfect Continuous
- **Hook:** "I'VE BEEN WAITING for an hour! — Started in the past, still happening, and I'm annoyed."
- Duration emphasis: for/since

### 24. Third Conditional
- **Hook:** "If I HAD STUDIED harder, I WOULD HAVE PASSED. — But I didn't study, and I failed. Regret tense."

### 25. Wish + Past (I wish I had...)
- Wishes about present: I wish I KNEW (but I don't)
- Wishes about past: I wish I HAD KNOWN (but I didn't)

### 26. Advanced Modals (might have, could have, should have)
- **Hook:** "You SHOULD HAVE told me! — These are about the past and carry emotion."
- must have (deduction), might have (possibility), should have (regret), could have (missed opportunity)

### 27. Passive with Modals
- "This should be done by Friday" / "It might have been stolen"

### 28. Causatives (have/get something done)
- "I had my car fixed" = someone else fixed it for me

### 29. Linking Words (however, although, despite)
- Connecting ideas like an adult: contrast, addition, result

### 30. Review & Level Assessment
- Comprehensive test covering all phases
- Decision: advance to intermediate or consolidate
- Celebrate progress! 🎉
