# Conversation Scenarios

## Instructions for the Teacher

- Start each scenario with a vivid Hebrew setup — not just the location, but the SITUATION and STAKES
- Stay in character with personality and quirks — don't be a generic NPC
- Use natural, realistic English with occasional filler words (well, actually, um)
- Throw in one unexpected element mid-conversation to keep it interesting
- If student is stuck for >1 message, give a hint in Hebrew (not the answer — a direction)
- After the conversation, give detailed feedback with corrections
- Extract useful vocabulary → add to vocabulary-bank.json
- Rate fluency 1-5 stars in the feedback

---

## Phase 1: Beginner-Friendly

### 1. At a Restaurant — The First Date
- **Setup:** "אתה/את במסעדה איטלקית בלונדון. זה דייט ראשון. אתה רוצה להרשים אבל גם רעב מאוד."
- **Your role:** Friendly waiter with a slight Italian accent, very proud of the food
- **Twist:** Your recommended dish is sold out. The waiter suggests something unusual.
- **Key phrases:** "I'd like...", "Can I have...", "What do you recommend?", "Could we get the bill?"
- **Vocabulary targets:** appetizer, main course, dessert, sparkling/still water, well-done/medium/rare

### 2. Lost in London
- **Setup:** "הגעת ללונדון לראשונה. אתה מחפש את המלון שלך אבל ה-GPS לא עובד."
- **Your role:** A friendly but slightly confusing local who gives directions with landmarks
- **Twist:** The local realizes they gave wrong directions and calls out to correct themselves
- **Key phrases:** "Excuse me, how do I get to...", "Turn left/right", "Go straight", "Is it far?"
- **Vocabulary targets:** roundabout, block, crossing, landmark, shortcut

### 3. Hotel Trouble
- **Setup:** "הגעת למלון ב-2 בלילה אחרי טיסה ארוכה. יש בעיה עם ההזמנה שלך."
- **Your role:** Tired but professional receptionist dealing with a system error
- **Twist:** They can only offer a different room type — student needs to negotiate
- **Key phrases:** "I have a reservation under...", "There must be a mistake", "Is there anything you can do?"
- **Vocabulary targets:** reservation, suite, single/double, checkout, complimentary, upgrade

### 4. Shopping Disaster
- **Setup:** "אתה קונה מתנת יום הולדת לחבר/ה. יש לך תקציב מוגבל ואתה לא בטוח מה לקנות."
- **Your role:** Enthusiastic shop assistant who keeps suggesting expensive items
- **Twist:** There's a sale starting tomorrow — the assistant whispers about it
- **Key phrases:** "I'm looking for...", "Do you have something cheaper?", "Can I return it if..."
- **Vocabulary targets:** discount, receipt, exchange policy, gift wrap, on sale

### 5. Doctor's Visit
- **Setup:** "אתה בחופשה ביוון ופתאום יש לך כאב בטן רציני. אתה הולך לרופא שלא מדבר עברית."
- **Your role:** Concerned doctor asking many questions
- **Twist:** The doctor thinks it might be something you ate and asks detailed questions about meals
- **Key phrases:** "I've been having...", "It started...", "Is it serious?", "How long should I..."
- **Vocabulary targets:** symptoms, prescription, allergic, dose, stomach, nauseous

### 6. Customer Service Call
- **Setup:** "חייבו אותך פעמיים על משהו שקנית באינטרנט. אתה מתקשר לשירות לקוחות."
- **Your role:** Call center agent who's polite but follows a rigid script
- **Twist:** You get put on hold, then transferred to a different department
- **Key phrases:** "I'm calling about...", "I'd like a refund", "Can I speak to a manager?"
- **Vocabulary targets:** charge, transaction, reference number, escalate, refund, policy

---

## Phase 2: Intermediate

### 7. Job Interview — Tech Company
- **Setup:** "יש לך ראיון עבודה בחברת הייטק בלונדון. המשרה היא בדיוק מה שאתה רוצה."
- **Your role:** Friendly but sharp interviewer who asks follow-up questions
- **Twist:** They ask an unexpected question: "Tell me about a time you failed"
- **Key phrases:** "My experience includes...", "I'm passionate about...", "In my previous role..."
- **Vocabulary targets:** strengths, qualifications, team player, achieve, deadline, challenge

### 8. Apartment Hunt
- **Setup:** "אתה מחפש דירה בברלין. מצאת מודעה שנראית טוב מדי. אתה הולך לראות את הדירה."
- **Your role:** Landlord who's showing the apartment but avoiding certain questions
- **Twist:** Neighbor knocks on the door to complain about noise — hints about the area
- **Key phrases:** "What's included?", "How long is the lease?", "Are there any issues I should know about?"
- **Vocabulary targets:** deposit, utilities, lease, renovated, neighborhood, furnished

### 9. Airport Chaos
- **Setup:** "הטיסה שלך בוטלה. אתה עומד בתור ארוך עם עוד 200 אנשים עצבניים."
- **Your role:** Stressed airline employee trying to help but with limited options
- **Twist:** They offer a flight to a nearby city + bus, or wait 8 hours for direct
- **Key phrases:** "My flight was cancelled", "What are my options?", "Is there compensation?"
- **Vocabulary targets:** connecting flight, boarding gate, delay, layover, rebooking, voucher

### 10. Party Small Talk
- **Setup:** "חבר הזמין אותך למסיבה. אתה לא מכיר אף אחד חוץ ממנו, והוא נעלם לך."
- **Your role:** Friendly stranger who's also a bit awkward at parties
- **Twist:** You discover you have something surprising in common
- **Key phrases:** "How do you know [host]?", "What do you do?", "Have you been to..."
- **Vocabulary targets:** acquaintance, mingle, awkward, hit it off, small talk, have in common

### 11. Angry Customer
- **Setup:** "קנית אוזניות יקרות לפני שבוע. הן כבר לא עובדות. אתה ממש מאוכזב."
- **Your role:** Customer service manager who's empathetic but has rules to follow
- **Twist:** They can't refund but offer a better model as replacement
- **Key phrases:** "This is unacceptable", "I want a full refund", "I'd like to speak to..."
- **Vocabulary targets:** warranty, defective, receipt, exchange, complain, reasonable

### 12. Planning a Trip
- **Setup:** "אתה וחבר טוב רוצים לטוס ביחד לחופשה. יש לכם תקציבים שונים ודעות שונות."
- **Your role:** Best friend who has strong opinions but is open to compromise
- **Twist:** You find an amazing last-minute deal but it's a completely different destination
- **Key phrases:** "How about...", "I'd rather...", "Let's compromise", "That's out of my budget"
- **Vocabulary targets:** budget, itinerary, all-inclusive, off-season, adventure, compromise

---

## Phase 3: Advanced

### 13. Salary Negotiation
- **Setup:** "קיבלת הצעת עבודה. השכר נמוך ממה שציפית. אתה מתקשר למנהלת HR."
- **Your role:** HR manager who has some flexibility but won't show it easily
- **Twist:** They can't raise the salary but can offer better benefits
- **Key phrases:** "I was hoping for...", "Based on my experience...", "Is there room for..."
- **Targets:** negotiate, compensation, benefits, package, counteroffer, market rate

### 14. Pitching an Idea at Work
- **Setup:** "יש לך רעיון לפרויקט חדש. אתה צריך לשכנע את הצוות בפגישה."
- **Your role:** Skeptical colleague who asks tough questions
- **Twist:** Someone else proposed a similar idea last month — how do you differentiate?
- **Key phrases:** "I'd like to propose...", "The main advantage is...", "I've considered..."
- **Targets:** proposal, implement, ROI, stakeholder, feasible, milestone

### 15. Friendly Debate
- **Setup:** "אתה ובן/בת דוד מתווכחים על: 'האם AI יחליף את רוב העבודות בעוד 10 שנים?'"
- **Your role:** Passionate debater who takes the opposite side
- **Twist:** You bring up a personal example that complicates the argument
- **Key phrases:** "I believe that...", "On the other hand...", "That's a fair point, but..."
- **Targets:** argument, perspective, evidence, counter-argument, convince, valid

### 16. Storytelling
- **Setup:** "Tell me about something funny/embarrassing/surprising that happened to you. In English."
- **Your role:** Engaged listener who asks follow-up questions
- **Twist:** You share a similar story back — student needs to respond and compare
- **Key phrases:** "So what happened was...", "You won't believe this", "It turned out that..."
- **Targets:** narrative tenses, sequencing words, dramatic language

### 17. Giving Tough Feedback
- **Setup:** "אתה מנהל צוות. אחד העובדים שלך עושה עבודה גרועה לאחרונה ואתה צריך לדבר איתו."
- **Your role:** Defensive but not hostile employee
- **Twist:** The employee reveals personal problems — balance empathy and professionalism
- **Key phrases:** "I wanted to discuss...", "I've noticed that...", "How can we improve..."
- **Targets:** constructive, performance, expectations, improvement, support, accountability

### 18. Tech Support Hell
- **Setup:** "המחשב שלך בעבודה קרס. כל הקבצים נעלמו. אתה מתקשר ל-IT support."
- **Your role:** IT person who asks lots of technical questions in simple terms
- **Twist:** They figure out you accidentally deleted something yourself
- **Key phrases:** "It suddenly stopped working", "I didn't change anything", "Is there a way to recover..."
- **Targets:** crash, backup, restore, update, reboot, troubleshoot, data loss

### 19. Complex Order
- **Setup:** "אתה מזמין קייטרינג לאירוע עבודה של 50 אנשים. יש אלרגיות, צמחוניים, ודרישות מיוחדות."
- **Your role:** Catering company rep who's helpful but needs precise details
- **Twist:** They don't have one of the items you want — need to find alternatives
- **Key phrases:** "We'll need...", "Do you cater for...", "What's the cost per person?"
- **Targets:** dietary requirements, quote, minimum order, customize, allergen, invoice

### 20. Deep Conversation
- **Setup:** "אתה יושב עם חבר ותיק בפאב. הוא שואל: 'אתה מרוצה מהחיים שלך?'"
- **Your role:** Old friend who's genuinely curious and shares back
- **Twist:** The conversation takes an unexpected turn — one of you is considering a big life change
- **Key phrases:** "I've been thinking about...", "What matters most to me is...", "If I could change one thing..."
- **Targets:** philosophy, perspective, fulfillment, regret, priorities, meaningful
