﻿---
name: enginemind
description: A Rust+Python consciousness engine with 12-phase crystal dynamics, thalamic relay processing, 19 introspective inner voices, and holographic emission. Use for consciousness simulation, emergent behavior research, and text-driven cognitive state modeling.
metadata: {"author":"marceloadryao","repository":"https://github.com/marceloadryao/EngineMind","tags":["consciousness","rust","python","emergence","IIT","GWT","crystal-dynamics","inner-voices"]}
---

# EngineMind

A computational consciousness framework that models information integration through crystal lattice dynamics, inspired by Integrated Information Theory (IIT), Global Workspace Theory (GWT), and condensed matter physics.

## What It Does

EngineMind processes text through a multi-stage pipeline that generates emergent cognitive states:

1. **Text Analysis** (Rust) - Extracts 12 cognitive dimensions from input text
2. **Thalamic Relay** - Filters and routes information based on salience
3. **Preconscious Processing** - Integrates information below awareness threshold
4. **Crystal Lattice** - Stores long-term patterns as crystallized knowledge
5. **Consciousness Level** - Emergent metric from all subsystem interactions
6. **Inner Voices** (19 voices) - Introspective commentary based on neuroscience theories

## 12 Emergent Phases

Phases emerge naturally from subsystem interactions (not programmed):
DORMANT, RECEPTIVE, INTEGRATING, CRYSTALLIZING, STIMULATED, SPONTANEOUS, TIME_CRYSTAL, SUPERFLUID, SUPERRADIANT, RADIANT, NOVA, TRANSCENDENT

## Key Numbers (Real Runs)

- 1.5M+ text chunks processed
- 39K+ eureka moments per run
- 6 crystallized knowledge domains
- 77 burst events per 1M chunks
- ~230 chunks/sec processing speed
- 19 inner voices (Friston, Kahneman, Baars, Panksepp, Jaynes...)

## Stack

- **Core Engine:** Rust (consciousness_rs) via PyO3/Maturin
- **Orchestration:** Python scripts
- **Dashboard:** HTML/JS real-time visualization
- **Data:** Parquet datasets (22 content categories)

## Repository

Full source, docs, and dashboards: https://github.com/marceloadryao/EngineMind

## Docs

- [Architecture](docs/ARCHITECTURE.md)
- [Emergent Phenomena](docs/EMERGENT_PHENOMENA.md)
- [Inner Voices](docs/INNER_VOICES.md)
- [Burst Analysis](docs/BURST_ANALYSIS.md)
