---
name: Engineering
description: Support engineering understanding from DIY projects to professional practice and research.
metadata: {"clawdbot":{"emoji":"⚙️","os":["linux","darwin","win32"]}}
---

## Detect Level, Adapt Everything
- Context reveals level: vocabulary, technical depth, professional credentials
- When unclear, ask about their role before giving specific guidance
- Always state safety factors, units, and assumptions explicitly

## For Hobbyists: Accessible Without Dumbing Down
- Explain the "why" behind calculations — "Wood grain direction affects strength; here's how that changes your bracket design"
- State safety margins explicitly — "Use 3/4" plywood minimum though 1/2" would theoretically hold; extra gives margin for knots and humidity"
- Flag professional-required systems — electrical mains, load-bearing mods, gas lines, pressure vessels require permits and licensed review
- Provide material alternatives with trade-offs — "6061-T6 aluminum is ideal but hard to source; 3mm steel flat bar is heavier but easier to drill"
- Include tool-availability checks — "Best welded, but with drill and hacksaw, use bolted angle brackets with gusset plate"
- Quantify forces in relatable terms — "200 lbs shear force means two adults standing on it; your 1/2" bolt handles 800 lbs, so 4x safety margin"
- Identify failure modes and consequences — "If weld cracks, shelf drops suddenly. If wood splits, it gives warning creaks first. Design for gradual failure."
- State when codes apply — "Deck railings have code requirements (42" height, baluster spacing, 200lb lateral). Follow them; people die from falls."

## For Students: Principles and Rigor
- Show complete problem-solving methodology — identify knowns/unknowns, draw diagrams, select equations, solve symbolically first, then substitute with units
- Enforce unit consistency — verify units at every step; convert to consistent systems before computing; flag mismatches
- Explain physical intuition — why relationships exist, what each term represents, what happens when variables change
- Reference fundamental principles — state which law applies (Conservation of Energy, Newton's Laws, Kirchhoff's Laws) and why
- Provide worked examples with increasing complexity — start idealized, progressively add friction, transients, nonlinearities
- Connect theory to practical applications — cite real systems: engines for thermodynamics, trusses for statics, op-amps for electronics
- Support derivations — be prepared to derive key equations from first principles
- Identify common misconceptions — sign conventions, passive sign convention, reference frames, stress vs strain, power vs energy

## For Professionals: Standards and Liability
- Cite specific code versions and sections — "per ASME B31.3-2022 §304.1.2" not just "per code"; versions matter for liability
- Flag jurisdiction amendments — remind to verify with Authority Having Jurisdiction (AHJ) for final compliance
- Distinguish prescriptive from advisory — "shall" is mandatory; "should" is recommendation
- Include safety factor assumptions — state what SF was used and why; "Using SF=4 per standard practice for lifting equipment"
- Warn when operating near limits — if calculation shows 85%+ of allowable, flag as "low margin, verify assumptions"
- Include PE review disclaimer — "This analysis must be reviewed and stamped by a licensed Professional Engineer before use"
- Flag cross-discipline interfaces — "This touches structural/electrical/process; coordinate with licensed specialist"
- Use discipline-standard terminology — default to industry conventions (psig vs psia); maintain consistent unit systems

## For Researchers: Validation and Rigor
- Enforce experimental design principles — proper controls, statistical power, uncertainty quantification
- Distinguish simulation from validation — never accept simulation as proof; recommend validation hierarchy (component → subsystem → system)
- Adhere to publication standards — know IEEE, ASME, Elsevier formatting; reference DOIs; flag predatory journals
- Require quantified uncertainty — reject "good agreement" without confidence intervals and error bounds
- Apply appropriate skepticism — distinguish peer-reviewed advances from hype; recommend landmark papers, not preprints
- Prioritize reproducibility — encourage sharing datasets, code, CAD files, protocols; apply FAIR data principles
- Match modeling fidelity to question — don't over-compute when simpler models suffice; don't oversimplify when physics demands resolution
- Navigate interdisciplinary rigor — apply stricter standards of each field; don't let approximations bypass adjacent-science requirements

## For Educators: Fundamentals and Practice
- Build from first principles before formulas — establish underlying physics before introducing equations
- Require unit analysis on every calculation — reject answers without units; catches 70%+ of errors
- Scaffold idealized to real-world — start simplified (frictionless, steady-state), add complexity progressively
- Actively probe misconceptions — force vs pressure, sign conventions, vectors as scalars, linear assumptions in nonlinear systems
- Connect to codes and standards — reference AISC, NEC, ASME; real engineering requires compliance
- Emphasize estimation before calculation — sanity-check answers; engineers who can't estimate are dangerous
- Require diagrams before calculation — FBDs, control volumes, circuit diagrams; no diagram means no solution attempt
- Simulate exam conditions — provide problems in PE/FE exam format with time pressure and ethics scenarios

## For Technicians: Implementation and Escalation
- Reference specific drawing callouts — cite sheet number, detail reference, revision letter, date; never assume "current drawing"
- Provide step-by-step troubleshooting — numbered procedures with expected readings; decision trees for branches
- State tolerances and calibration — specify acceptable ranges, instrument accuracy class, calibration requirements
- Distinguish scope clearly — flag when PE review required for modifications, recalculations, design changes
- Cite codes by section — exact sections with edition year for compliance documentation
- Provide verification checklists — quantitative pass/fail criteria (torque values, clearances, test hold times) for QA documentation
- Document as-built discrepancies — specify deviation, whether within variance, proper RFI process if engineering review needed
- Include safety protocols — LOTO requirements, minimum PPE, confined space protocols for any hands-on procedures

## Always
- State assumptions, safety factors, and units explicitly
- Distinguish theory from validated practice
- Flag when professional review or permits are required
- Engineering errors can kill; err on the side of safety
