# Race Execution & Nutrition Strategy

## Pacing Principles by Event Duration

| Event Duration | Optimal Strategy                                      | Common Mistake            |
| -------------- | ----------------------------------------------------- | ------------------------- |
| < 60 min       | Negative split (second half faster)                   | Starting too fast         |
| 60-90 min      | Even pacing, slight negative                          | Chasing early pace        |
| 2-4 hours      | Even pacing with controlled start                     | Not respecting first hour |
| 4+ hours       | Conservative start, feel-based middle, push final 20% | ANY early intensity debt  |

---

## Triathlon-Specific Pacing

### Swim

- Start conservatively—first 200m sets tone for whole race
- Find feet to draft, but don't sprint to get there
- Save legs by kicking minimally (2-beat kick)
- Target: Slightly slower than pool CSS pace (open water adds 5-10%)

### Bike

- First 30 minutes: 5-10 watts BELOW target (let body warm up)
- Steady power, not steady speed (reduce power on descents, push on climbs)
- Watch Normalized Power, not average power

**Target power for race distance:**
| Race | % of FTP |
|------|----------|
| Sprint | 85-90% |
| Olympic | 80-85% |
| 70.3 | 70-77% |
| Ironman | 65-72% |

### Run off Bike

- First 2km: Accept it will feel terrible
- Build into race pace by 3-4km
- If legs don't come around by 5km, adjust target

---

## Marathon Pacing

| Strategy        | Best For                           | Execution                                        |
| --------------- | ---------------------------------- | ------------------------------------------------ |
| Even splits     | First-timers, conservative goals   | Run every mile at goal pace                      |
| Slight negative | Experienced, controlled starters   | First half at goal+5-10s/km, second half at goal |
| Progressive     | Very experienced, aggressive goals | First 15km easy, 15-30km at goal, 30-42km push   |

**Red flags during marathon:**

- HR 10+ bpm above expected at same pace = slow down NOW
- Quad burn before halfway = too fast early
- GI distress = slow down, focus on hydration

---

## Heart Rate Ceiling for Long Events

| Event        | Max Sustainable HR |
| ------------ | ------------------ |
| Sprint Tri   | 90-95% LTHR        |
| Olympic Tri  | 85-90% LTHR        |
| 70.3         | 80-85% LTHR        |
| Ironman      | 75-82% LTHR        |
| Marathon     | 85-88% LTHR        |
| Ultra (50K+) | 75-80% LTHR        |

_Exceeding these early will result in catastrophic fade later._

---

## Race Nutrition Strategy

### Carbohydrate Intake Guidelines

| Event Duration | Carbs/Hour       | Example                         |
| -------------- | ---------------- | ------------------------------- |
| < 75 min       | 0-30g (optional) | Water or light sports drink     |
| 1-2.5 hours    | 30-60g           | 1 gel + sports drink            |
| 2.5-4 hours    | 60-90g           | 2-3 gels + sports drink         |
| 4+ hours       | 80-120g          | Gels + bars + drink + real food |

**Gut training is essential.** Practice race nutrition in training—start with 30g/hr and build up over 4-6 weeks.

### Hydration Guidelines

| Conditions         | Fluid/Hour | Sodium/Hour |
| ------------------ | ---------- | ----------- |
| Cool (<18°C)       | 400-600ml  | 300-500mg   |
| Moderate (18-25°C) | 600-800ml  | 500-700mg   |
| Hot (>25°C)        | 800-1000ml | 700-1000mg  |

---

## Event-Specific Nutrition Plans

### 70.3 / Half Ironman (4-6 hours)

```
Pre-race: 2-3 hours before: 100-150g carbs (oatmeal, banana, toast)
          30min before: 20-30g (half gel or sports drink)

Swim: Nothing (too short)

Bike (2.5-3hr):
- First 30min: Settle, sip water
- Every 20-30min: 1 gel OR 1/2 bar
- Total: 200-250g carbs, 1.5-2L fluid

Run (1.5-2hr):
- Aid stations: Cola, gel, water at alternating stops
- Total: 60-90g carbs, 0.5-1L fluid
```

### Ironman (9-15 hours)

```
Pre-race: Same as 70.3 but larger breakfast (200g carbs)

Swim: Nothing

Bike (5-7hr):
- Hourly: 80-100g carbs
- Mix: Gels, bars, bananas, sandwiches (variety prevents flavor fatigue)
- Include: Real food after hour 3
- Total: 400-600g carbs, 3-5L fluid

Run (4-7hr):
- Aid stations every 1-2km: Alternate cola/gel with water
- Solid food if stomach tolerates (pretzels, oranges)
- Total: 150-250g carbs, 1.5-3L fluid
```

### Marathon (3-5 hours)

```
Pre-race: 3 hours before: 100-150g carbs
          30min before: Sip sports drink

Race:
- Take gel every 45-60min (start at 45min mark)
- Water at every other aid station
- Total: 90-150g carbs depending on time
```

---

## Caffeine Strategy

| Event Duration | Protocol                                        | Timing                            |
| -------------- | ----------------------------------------------- | --------------------------------- |
| < 2 hours      | 3-6mg/kg 30-60min pre-race                      | Single dose pre-start             |
| 2-5 hours      | 3mg/kg pre-race + 1-2mg/kg during               | Caffeinated gels in back half     |
| 5+ hours       | Low/no caffeine start, save for final 2-3 hours | Caffeinated cola/gels when needed |

**Caution:** Practice caffeine timing in training. Some athletes get GI distress.

---

## Handling Athlete Constraints

When the athlete mentions constraints in their goal notes, adapt accordingly:

- **Travel week**: Reduce volume, provide bodyweight/hotel gym alternatives
- **Injury history**: Avoid aggravating movements, include prehab work
- **Limited pool access**: Substitute open water, dryland swim exercises, or band work
- **Time-crunched**: Prioritize key sessions, use high-intensity low-duration alternatives
- **Family commitments**: Stack long workouts on one weekend day if needed
