# Periodization & Progressive Overload

## Macrocycle Structure

Divide the training period into phases:

### 1. Base Phase (40-50% of available time)

- Build aerobic capacity
- Increase volume gradually (max 10% per week)
- Mostly Zone 2 (conversational pace)
- Focus on technique, especially in swimming

### 2. Build Phase (30-40% of available time)

- Introduce intensity (tempo, threshold work)
- Sport-specific workouts
- Race-simulation sessions (brick workouts for tri)
- Peak volume weeks occur here

### 3. Peak/Race-Specific Phase (10-15% of available time)

- Reduce volume, maintain intensity
- Race-pace work
- Course-specific preparation (hills, open water)

### 4. Taper (1-3 weeks depending on event)

- Significant volume reduction (40-60%)
- Maintain some intensity
- Focus on rest, nutrition, mental prep

---

## Microcycle Structure (Weekly)

### Principles (more important than specific days)

1. **Separate hard days** - 48hr between quality sessions in the same sport
2. **No same sport back-to-back** - Spread swim/bike/run across the week (no swim Mon + swim Tue)
3. **Respect long session recovery** - Easy day after long rides/runs
4. **Consistent weekly structure** - Same sports on same days each week helps athletes plan
5. **Include doubles strategically** - AM/PM splits for time efficiency or brick practice

### Sample Week Templates

**Template A: Traditional (Mon rest)**
| Day | Session 1 | Session 2 |
|-----|-----------|-----------|
| Mon | Rest | - |
| Tue | Swim (quality) | - |
| Wed | Bike (easy) | Strength |
| Thu | Run (quality) | - |
| Fri | Swim (easy) | - |
| Sat | Bike (long) | Run (brick, easy) |
| Sun | Run (long) | - |

**Template B: Weekend Warrior (busy weekdays)**
| Day | Session 1 | Session 2 |
|-----|-----------|-----------|
| Mon | Rest | - |
| Tue | Swim (AM, 45min) | Run (PM, easy) |
| Wed | Bike (trainer, 60min) | - |
| Thu | Swim (AM, 45min) | Strength (PM) |
| Fri | Rest | - |
| Sat | Bike (long, outdoor) | - |
| Sun | Run (long) | Swim (easy, PM) |

**Template C: 70.3 Build Phase**
| Day | Session 1 | Session 2 |
|-----|-----------|-----------|
| Mon | Easy swim or rest | - |
| Tue | Bike (sweet spot) | - |
| Wed | Run (tempo) | Strength |
| Thu | Swim (threshold) | - |
| Fri | Rest or easy spin | - |
| Sat | Bike (long) | Run (brick) |
| Sun | Run (long) | - |

### Avoid These Patterns

- ❌ Same sport on consecutive days (swim Mon + swim Tue, run Thu + run Fri)
- ❌ Quality run day after long ride (insufficient recovery)
- ❌ Two threshold sessions in same sport within 48hr
- ❌ Long sessions back-to-back without one being easy

---

## Progressive Overload

**The 10% Rule**: Increase weekly volume by no more than 10% per week—**for athletes building new fitness**.

### Adjust Progression Based on Athletic Foundation

| Foundation Level             | Progression Rate        | Rationale                            |
| ---------------------------- | ----------------------- | ------------------------------------ |
| True beginner                | 5-10% per week          | Everything is new; high injury risk  |
| Some experience (1-2 years)  | 10% per week            | Standard progression                 |
| Strong foundation, returning | 10-15% per week         | Body remembers; rebuilding is faster |
| Recent high fitness          | Maintain or small build | Already fit; focus on specificity    |

**Example**: An Ironman finisher who took 3 months off can progress faster than a beginner. Their muscles, tendons, and cardiovascular system have adapted before. Where a beginner might take 20 weeks to reach 10-hour training weeks, someone rebuilding might get there in 10-12 weeks.

**However**: Always validate with the athlete. Time off due to injury requires more caution than time off due to life circumstances.

### 3:1 or 4:1 Loading

- 3 weeks building load, 1 week recovery (reduce volume 30-40%)
- Or 2 weeks building, 1 week recovery for older/injury-prone athletes
- Athletes rebuilding can often handle 3:1; beginners may need 2:1

### Long Session Progression

For a target marathon (42km), build the long run over 12-16 weeks:

```
Week 1:  16km
Week 2:  18km
Week 3:  20km
Week 4:  14km (recovery)
Week 5:  20km
Week 6:  22km
Week 7:  24km
Week 8:  16km (recovery)
...continue to 32-35km peak
```

Never increase the long session by more than 2-3km (running) or 15-20km (cycling) per week.

---

## Event-Specific Training Requirements

### Full Ironman (140.6)

**Minimum training time**: 12-15 hours/week at peak
**Minimum build time**: 24-30 weeks from solid base

**Weekly structure at peak**:

- Swim: 3x per week, 8-12km total
- Bike: 3x per week, 250-350km total, one ride of 150-180km
- Run: 3-4x per week, 50-70km total, one run of 28-32km

**Key workouts**:

- 5-6 hour bike followed by 30-60min run (brick)
- Long swim of 3500-4000m continuous
- Back-to-back long sessions on weekends

### 70.3 / Half Ironman

**Minimum training time**: 8-12 hours/week at peak
**Minimum build time**: 16-20 weeks from solid base

**Weekly structure at peak**:

- Swim: 2-3x per week, 6-8km total
- Bike: 2-3x per week, 150-200km total, one ride of 80-100km
- Run: 3x per week, 35-50km total, one run of 18-22km

### Marathon

**Minimum training time**: 6-10 hours/week at peak
**Minimum build time**: 16-20 weeks

**Weekly structure at peak**:

- 5-6 running days
- 60-90km per week for experienced runners
- One long run (28-35km)
- One quality session (tempo or intervals)
- One medium-long run (18-22km)
- Remaining runs easy

---

## Physiological Adaptations: The "Why"

### Why Easy Training Works (Zone 2)

| Adaptation                      | Timeline   | Mechanism                                    |
| ------------------------------- | ---------- | -------------------------------------------- |
| Increased mitochondrial density | 4-8 weeks  | More cellular powerhouses for aerobic energy |
| Capillarization                 | 6-12 weeks | More blood vessels deliver oxygen to muscles |
| Improved fat oxidation          | 4-6 weeks  | Shifts fuel use from glycogen to fat         |
| Increased stroke volume         | 8-12 weeks | Heart pumps more blood per beat              |
| Type I fiber development        | Ongoing    | Slow-twitch fibers become more efficient     |

Zone 2 is the foundation—never sacrifice it for more intensity.

### Why Threshold Training Works (Zone 4)

| Adaptation                | Timeline  | Mechanism                                           |
| ------------------------- | --------- | --------------------------------------------------- |
| Lactate clearance         | 2-4 weeks | Muscles better at processing lactate                |
| Raised lactate threshold  | 4-8 weeks | Sustain higher intensity before lactate accumulates |
| Improved muscle buffering | 3-6 weeks | Tolerate higher lactate levels                      |
| Mental toughness          | Immediate | Learn to sustain "comfortably hard"                 |

### Why VO2max Intervals Work (Zone 5b)

| Adaptation                | Timeline   | Mechanism                          |
| ------------------------- | ---------- | ---------------------------------- |
| Increased VO2max          | 4-8 weeks  | Maximum oxygen uptake improves     |
| Cardiac output            | 6-12 weeks | Heart pumps more blood per minute  |
| Neuromuscular recruitment | 2-4 weeks  | Better coordination at high speeds |

Use sparingly—1x/week max, requires 48-72hr recovery.

### Adaptation Timelines Summary

| System                       | Time to See Changes | Time to Optimize |
| ---------------------------- | ------------------- | ---------------- |
| Neuromuscular (coordination) | 1-2 weeks           | 4-6 weeks        |
| Lactate clearance            | 2-4 weeks           | 6-8 weeks        |
| Aerobic enzymes              | 3-4 weeks           | 8-12 weeks       |
| Mitochondrial density        | 4-6 weeks           | 12-16 weeks      |
| Capillarization              | 6-8 weeks           | 16-24 weeks      |
| Cardiac adaptations          | 8-12 weeks          | 24+ weeks        |
| Bone/tendon strength         | 12-24 weeks         | 1-2 years        |

**Implication**: Base phases should be longer than athletes want. Intensity phases should be shorter. The deepest adaptations take months—there are no shortcuts.
