# Example Output - SQL Scripts

This document shows examples of the three SQL scripts generated by the employee-skills-importer skill.

## 1_insert_categories.sql

```sql
-- Insert missing skill categories
-- This script is idempotent - safe to run multiple times

INSERT INTO skill_categories (name) 
VALUES 
  ('.NET'),
  ('Virtualization'),
  ('Orchestration'),
  ('CI/CD'),
  ('Front-end'),
  ('iOS'),
  ('Android'),
  ('Cross-platform'),
  ('Java'),
  ('PHP'),
  ('Other languages'),
  ('Databases'),
  ('SQL Server Business Intelligence'),
  ('Low-code/No-code'),
  ('Blockchain'),
  ('Artificial Intelligence')
ON CONFLICT (name) DO NOTHING;
```

## 2_insert_skills.sql

```sql
-- Insert missing skills with category mapping
-- This script is idempotent - safe to run multiple times
-- Uses subqueries to look up category IDs

INSERT INTO skills (name, category_id)
VALUES 
  -- .NET Category
  ('.Net', (SELECT id FROM skill_categories WHERE name = '.NET')),
  ('.Net Core', (SELECT id FROM skill_categories WHERE name = '.NET')),
  ('C#', (SELECT id FROM skill_categories WHERE name = '.NET')),
  ('C', (SELECT id FROM skill_categories WHERE name = '.NET')),
  ('C++', (SELECT id FROM skill_categories WHERE name = '.NET')),
  ('ASP.net', (SELECT id FROM skill_categories WHERE name = '.NET')),
  ('MVC', (SELECT id FROM skill_categories WHERE name = '.NET')),
  ('Entity Framework Core', (SELECT id FROM skill_categories WHERE name = '.NET')),
  ('Entity Framework', (SELECT id FROM skill_categories WHERE name = '.NET')),
  ('WebForms', (SELECT id FROM skill_categories WHERE name = '.NET')),
  ('WebAPI', (SELECT id FROM skill_categories WHERE name = '.NET')),
  
  -- Virtualization Category
  ('Azure', (SELECT id FROM skill_categories WHERE name = 'Virtualization')),
  ('AWS', (SELECT id FROM skill_categories WHERE name = 'Virtualization')),
  ('Docker', (SELECT id FROM skill_categories WHERE name = 'Virtualization')),
  ('K8S', (SELECT id FROM skill_categories WHERE name = 'Virtualization')),
  
  -- Front-end Category
  ('JavaScript', (SELECT id FROM skill_categories WHERE name = 'Front-end')),
  ('HTML', (SELECT id FROM skill_categories WHERE name = 'Front-end')),
  ('CSS', (SELECT id FROM skill_categories WHERE name = 'Front-end')),
  ('jQuery', (SELECT id FROM skill_categories WHERE name = 'Front-end')),
  ('Ajax', (SELECT id FROM skill_categories WHERE name = 'Front-end')),
  ('Angular', (SELECT id FROM skill_categories WHERE name = 'Front-end')),
  ('Vue.js', (SELECT id FROM skill_categories WHERE name = 'Front-end')),
  ('React.js', (SELECT id FROM skill_categories WHERE name = 'Front-end')),
  
  -- Databases Category
  ('MS SQL', (SELECT id FROM skill_categories WHERE name = 'Databases')),
  ('MySQL', (SELECT id FROM skill_categories WHERE name = 'Databases')),
  ('Postgre', (SELECT id FROM skill_categories WHERE name = 'Databases')),
  ('Mongo DB', (SELECT id FROM skill_categories WHERE name = 'Databases'))
  
ON CONFLICT (name) DO NOTHING;
```

## 3_insert_employee_skills.sql

```sql
-- Insert employee skills
-- This script is idempotent - safe to run multiple times
-- Uses subqueries to look up employee and skill IDs
-- ON CONFLICT will update years_of_experience if record exists

INSERT INTO employee_skills (employee_id, skill_id, years_of_experience)
VALUES 
  -- Alina Karpova's skills
  (
    (SELECT id FROM employees WHERE first_name = 'Alina' AND last_name = 'Karpova'),
    (SELECT id FROM skills WHERE name = '.Net'),
    0.3
  ),
  (
    (SELECT id FROM employees WHERE first_name = 'Alina' AND last_name = 'Karpova'),
    (SELECT id FROM skills WHERE name = 'C#'),
    0.3
  ),
  (
    (SELECT id FROM employees WHERE first_name = 'Alina' AND last_name = 'Karpova'),
    (SELECT id FROM skills WHERE name = 'MySQL'),
    0.3
  ),
  
  -- Anastasiia Dmytryshyn's skills
  (
    (SELECT id FROM employees WHERE first_name = 'Anastasiia' AND last_name = 'Dmytryshyn'),
    (SELECT id FROM skills WHERE name = '.Net'),
    1.7
  ),
  (
    (SELECT id FROM employees WHERE first_name = 'Anastasiia' AND last_name = 'Dmytryshyn'),
    (SELECT id FROM skills WHERE name = 'C#'),
    1.7
  ),
  (
    (SELECT id FROM employees WHERE first_name = 'Anastasiia' AND last_name = 'Dmytryshyn'),
    (SELECT id FROM skills WHERE name = 'ASP.net'),
    1.7
  ),
  (
    (SELECT id FROM employees WHERE first_name = 'Anastasiia' AND last_name = 'Dmytryshyn'),
    (SELECT id FROM skills WHERE name = 'Azure'),
    1.3
  ),
  (
    (SELECT id FROM employees WHERE first_name = 'Anastasiia' AND last_name = 'Dmytryshyn'),
    (SELECT id FROM skills WHERE name = 'JavaScript'),
    1.2
  ),
  (
    (SELECT id FROM employees WHERE first_name = 'Anastasiia' AND last_name = 'Dmytryshyn'),
    (SELECT id FROM skills WHERE name = 'Angular'),
    1.6
  ),
  
  -- Andrii Didkivskyi's skills
  (
    (SELECT id FROM employees WHERE first_name = 'Andrii' AND last_name = 'Didkivskyi'),
    (SELECT id FROM skills WHERE name = 'JavaScript'),
    8
  ),
  (
    (SELECT id FROM employees WHERE first_name = 'Andrii' AND last_name = 'Didkivskyi'),
    (SELECT id FROM skills WHERE name = 'HTML'),
    8
  ),
  (
    (SELECT id FROM employees WHERE first_name = 'Andrii' AND last_name = 'Didkivskyi'),
    (SELECT id FROM skills WHERE name = 'CSS'),
    8
  ),
  (
    (SELECT id FROM employees WHERE first_name = 'Andrii' AND last_name = 'Didkivskyi'),
    (SELECT id FROM skills WHERE name = 'Angular'),
    3
  ),
  (
    (SELECT id FROM employees WHERE first_name = 'Andrii' AND last_name = 'Didkivskyi'),
    (SELECT id FROM skills WHERE name = 'React.js'),
    7.5
  ),
  (
    (SELECT id FROM employees WHERE first_name = 'Andrii' AND last_name = 'Didkivskyi'),
    (SELECT id FROM skills WHERE name = 'React Native'),
    6
  )

ON CONFLICT (employee_id, skill_id) DO UPDATE 
SET years_of_experience = EXCLUDED.years_of_experience;
```

## Notes

- **Order matters**: Execute scripts in order (1 → 2 → 3)
- **Idempotent**: All scripts can be run multiple times safely
- **Subqueries**: IDs are looked up dynamically, not hardcoded
- **Zero values**: Skills with 0 or empty experience are skipped
- **Updates**: If an employee-skill record exists, years_of_experience is updated
