# **1. 人类决策与机器预测**

**Human Decisions and Machine Predictions，Jon Kleinberg et al., QJE, 2017**

这篇由Jon Kleinberg 等计算机科学家和经济学家撰写的论文 *Human Decisions and Machine Predictions* 是计算社会科学和应用计量经济学领域的经典之作。文章通过引入机器学习算法来评估和改进人类（法官）的决策，并开创性地解决了一系列因果推断与预测相结合的方法论难题。

## **问题的提出**

机器学习能改善人类决策么？美国刑事诉讼程序中的保释决策（Bail decisions）可以提供一个很好的切入点。

在美国，法官需要在犯罪嫌疑人被捕后决定将其释放等候庭审亦或关押。根据法律，这一保释决策应仅基于对**风险的预测**：如果释放，被告是否会逃庭（Failure to Appear, FTA）或再次犯罪 。

这是典型的机器学习中的预测任务。作者利用纽约市2008年到2013年的大规模数据集构建了一个梯度提升决策树算法（gradient boosted decision trees, GBDT）来完成这项风险预测任务，并将结果与法官的决策相比较，来探究机器学习算法能否做出比人类法官更优的决策。

## **实证研究的核心难题**

在评估机器学习算法的表现时，面临两个实证难题：

- **选择性标签问题 (The Selective Labels Problem)：**

  - 我们只能观测到被法官释放的那些被告的潜在结果（是否犯罪/逃庭）。对于那些被法官关押的人，我们无法观察到如果他们被释放会发生什么（反事实结果缺失）。

  - 如果仅在法官释放的被告样本上训练和评估算法，会导致估计偏差，因为被关押的人可能风险更高 。

    | 法官 \ 算法 |         关押         |          释放          |
    | ----------- | :------------------: | :--------------------: |
    | **关押**    |       无需评估       | 反事实结果**不可观测** |
    | **释放**    | 反事实结果**可观测** |        无需评估        |

- **遗漏收益偏差 (Omitted Payoff Bias)：**

  - 法官决策可能基于一些“私有信息”（不可观测变量），例如被告的庭上表现、帮派纹身等 。
  - 法官的实际目标函数可能比算法更复杂。算法通常只预测单一指标（如逃庭风险），而法官可能还关心暴力犯罪风险、种族公平、或被告的家庭状况等。
  - 如果**法官是基于这些不可观测因素做出正确决策**，而算法忽略了这些，那么简单比较会错误地认为算法优于法官。

## **识别策略与方法设计**

作者设计了一套巧妙的识别策略来克服上述评估难题，核心利用了**案件的随机分配**和**法官宽严程度的差异**。

- **收缩策略（Contraction Strategy）**
  - 虽然我们不知道被关押者被释放会怎样，但我们确实知道被释放者的结局（**反事实结果的“单侧”特性**）。
  - 如果算法建议关押那些被法官释放的高风险人群，我们只需要在这个反事实结果可观测的组别里进行效果评估，看看算法会不会精准挑选出更多的“假阴性”进行关押，而无需评估反事实结果不可观测的情况，从而绕开了选择性标签问题。
- **准实验设计：案件随机分配给宽严有别的法官**
  - 在纽约市的法庭系统中，案件是被随机分配给不同法官的，在大样本意义上，法官面对的被告群体是同质的，即被告的犯罪风险分布是一样的。
  - 但法官的宽严程度（释放率）存在显著差异。比如面对类似的1000人被告群体，宽容法官可能释放900人，而严格法官只释放800人。
  - 我们可以结合这两点构建一个评估策略：以最宽容的法官的决策为基准，让算法识别出这个组别里被释放者中的高风险群体（结局已知）并模拟关押，直至关押率升至与最严厉法官的决策组别相同，然后比较两个组别的犯罪率；或者算法模拟关押直至两个组别的犯罪率相同，然后比较两个组别的关押率。
  - 这个设计精妙之处在于，面对类似的已知结局的被告群体（宽容法官释放者），额外利用了不可观测信息进行风险预测的严厉法官，理应比只有可观测信息的算法识别出更多的高风险人群并进行关押（即犯罪率更低或假阴性更少），如果结果并非如此，就说明私有信息并没有帮助法官更好地决策，更多的是一种噪声，从而解决了遗漏收益偏差问题。

## **重要发现与结论**

- **算法表现显著优于人类法官：**在保持相同的关押率下，算法可以将犯罪率降低 24.7%；或者，在保持相同犯罪率的情况下，算法可以将关押人口减少 41.9%。
- **法官预测不精准且容易犯错：** 严厉的法官并非识别并关押了更多高风险的被告，而是从整个被告群体分布中多关押了人，甚至关押了许多低风险者。法官释放了大量高风险被告，算法识别出的前 1% 最高危被告，其实际犯罪率高达 56.3%，但法官却释放了其中 48.5% 的人 。

- **算法可兼顾效率与公平：**尽管算法没有使用种族作为输入变量，但人们常担心算法中存在与种族高度相关的输入变量。实证结果显示，算法在降低整体犯罪率的同时，甚至可以减少黑人和西班牙裔的关押率。这表明算法不仅提高了保释决策的效率，也可能促进了司法系统的种族平等。

## **学术价值**

- 文章最后，作者进一步升华，认为当前的机器学习应用大多停留在“数据 → 预测（Data → Prediction）”层面，比拼谁的模型精准度更高，但预测准并不代表决策好，一个完美的预测模型，如果忽略了文中提到的一些计量难题，可能会导致错误的政策建议。

- 经济学的研究必须跨越到“预测 → 决策（Prediction → Decision）”的层面，评估模型在真实复杂的决策环境中能否真正提升社会福利。

- 本文的目的并非得出“机器比人强”的简单论断，而是要建立一种“机器学习算法结合计量经济学”的新研究范式：既利用机器学习强大的预测能力，又利用经济学的因果推断框架来构建反事实，帮助人类跨越预测与决策之间那条复杂而危险的鸿沟。

# **2. 思想有力量：法律经济学的司法影响**

**Ideas Have Consequences: The Impact of Law and Economics on American Justice, Elliott Ash, et al., QJE, 2025**

精读系列第二篇，这次推荐我的学术偶像Elliott Ash历时数年打磨的文章 *Ideas Have Consequences: The Impact of Law and Economics on American Justice* 。该文用极为详实的数据，严谨的实证方法，以及自然语言处理技术，揭示了经济学思想如何影响了美国联邦法官的决策行为。笔者在芝加哥大学留学时，有幸聆听了Ash就这篇文章的早期学术报告，当时灵魂大受震撼，激动之情难以言表。

## **问题的提出**

经济学思想能否影响法官的重要决策？一场横跨二十余年的联邦法官培训项目为我们提供了洞察该问题的窗口。

在美国，“法律与经济学”（Law and Economics）是法律学术界和司法界极具影响力的一套思想体系，它强调成本收益、契约自由、行为激励等思维方式，在各部门法中有广泛的运用 ，比如合同法中的“效率违约”，侵权法中的“最小预防成本”，刑法中的“犯罪威慑”等理论。

上世纪70年代，由法律与经济学中心主办的曼恩项目（Manne Program），为全美的联邦法官提供一个为期两周的经济学培训课程，到1990年代初，近一半的在任联邦法官已经参加过这个培训。这个著名的培训项目有没有对法官决策产生实质的影响呢？Ash等人利用曼恩项目的出席记录，美国巡回法院的上诉判决，以及地方法院的刑事量刑数据，通过严谨的计量方法，为这个问题提供了可以量化的答案。

## **实证研究的核心难题**

在检验和评估曼恩培训项目的实际影响时，主要有两个方面的挑战：

- **内生性与选择偏误 (Endogeneity & Selection Bias)：** 
  - 参加项目的法官并不是随机分配的，报名本身可能代表了一种观念倾向，即培训法官本身具有浓厚的经济学兴趣或保守的政治偏好，我们无法观察到未参训法官如果参与培训的反事实结果。
- **思想影响的测量 (Measurement of Influence)：**
  - 法官的思维过程是一个“黑箱”，法官不会在判决书里写“因为我上了曼恩的课，所以我这样判”。传统的测量方法，如给法官贴上“自由派”或“保守派”的标签，或者对经济学词汇使用进行词频分析，对于衡量经济学思维对判决推理的影响来说过于粗糙。

## **识别策略与方法设计**

为了解决选择偏误的问题，作者使用了**双重差分法 (Difference-in-Differences)** 和**事件研究法 (Event-Study)**：

- **双重差分法：** 利用法官参加培训时间的交错（Staggered Timing），比较同一位法官在参训前后的变化（Within-judge effect）。
- **分配的准随机性：** 曼恩项目非常火爆，经常超额报名，录取采取“先到先得”的原则。这意味着，在报名参训的法官中，具体的参加时间具有一定的随机性，减少了法官根据短期信念变化进行“自我选择”的可能性。因此作者剔除了那些从未参加项目的法官 (Never-treated)，所有样本都来自将要参加或已经参加的法官 (Ever-attenders)，从而保证样本中的法官在报名时具有类似的观念倾向。
- **控制变量：** 作者使用了“法院-年份”固定效应，并结合上诉法院中案件的随机分配特性，以确保结果不是由案件类型的变化驱动的 。此外，作者还加入了同伴参训比例 (Peer Share)，即该法院其他法官中已参加培训的比例，来控制可能的同济效应。
- **事件研究**：思想对人的影响往往是长期的，作者构建了一个事件研究模型，来进一步测量影响随时间变化的轨迹，事件研究窗口为短期影响，项目全周期为长期影响。

为了测量经济学思维对判决的影响，作者使用了自然语言处理中的**词嵌入技术 (Word2Vec)**：

- **原理：** 这种算法将词语映射到向量空间中。如果两个词在语义上相关，它们在空间中的距离就会很近。例如，“市场”和“经济”的距离会比“市场”和“宪法”更近 。
- **操作：** 作者预先构建了一个法律与经济学词库，包括经济学分析中常见的“外部性”、“交易成本”、“效率”、“威慑”等词 。通过测量判决文本与这个核心词库在语义空间上的相似度，来捕捉法官是否在潜移默化中使用了经济学的分析框架进行推理，而不仅仅是简单的关键词堆砌。

## **重要发现与结论**

- **语言变化：** 参加培训后，法官在撰写判决书时使用了显著更多的经济学语言，并运用经济学思维进行概念性推理（Conceptual Reasoning）。
- **反监管倾向：** 在经济类案件中，参训法官投票反对监管机构（如环保署 EPA、劳工委员会 NLRB）的概率显著增加 (15%)。但在非经济类案件中，保守派投票率几乎没有变化，说明曼恩项目并没有把法官变成全面的政治保守派，而是精准地改变了他们在经济议题上的看法。
- **刑事量刑：** 在地方法院，参加过培训的法官做出的刑事判决更严厉，判处监禁的概率增加了6.2%，这符合经济学的威慑理论，即通过严厉的惩罚来提高犯罪成本 。
- **说服成功：**曼恩项目整体的说服率约为8%，与媒体对选民的影响力相当（例如福克斯新闻对共和党选民的影响约为11.6%）。这说明短期高强度经济学教育的“洗脑”效果堪比长期的媒体宣传。
- **溢出效应：**由于美国是判例法国家，曼恩法官撰写的 28,720 份判决意见后续被引用了超过30万次。这意味着那些没参加过培训的法官，在遵循先例时，也被动地接受了曼恩法官确立的经济学逻辑（例如在反垄断和环境法领域的经典判例）。曼恩项目对美国司法体系的塑造可能远远超出我们的想象。

## **学术价值**

- **超越传统模型：** Ash的研究有力反驳了法律形式主义（法官只看法条）和纯粹的态度主义（法官只看党派），证明了“思想”（Ideas）本身是塑造决策结果的重要独立变量。
- **思想影响的量化：** 该文展示了如何结合法律大数据、计量实证方法和自然语言处理技术，对思想观念的实际影响进行科学的量化研究。
- **经济学的力量：** 研究表明，经济学作为一种严谨的社会科学，其相对科学的分析框架，能够有力的影响法官的决策行为，实实在在地重塑了美国的司法体系。



# **3. 金融发展的法律源起**

Ross Levine, Chen Lin, Chicheng Ma, Yuchen Xu. The Legal Origins of Financial Development: Evidence from the Shanghai Concessions. *The Journal of Finance*, Vol. 78, No. 6, December 2023

本文是法律与金融领域的里程碑式研究，利用百年前上海租界这一独特的历史自然实验，为探究法律起源对金融发展的影响，提供了迄今为止最有力的因果证据。最近折腾了很多 vibe coding 产品，这次干脆写了个Claude code的 skill 来分析实证文章，来试试 vibe reading，需要 skill 文件的小伙伴私戳！

## **问题的提出**

法律起源理论（Legal Origins）通常认为，普通法系相比大陆法系具有灵活、司法独立、重视投资者保护等优势，因而更有利于金融业的发展。

但实证检验这一命题并不容易，法律体系与其他制度特征（政治体制、文化、历史路径等）高度相关，研究者难以区分是法律体系本身，还是其他因素驱动了不同地区的金融发展。

中国近代史上，英法两国最早在上海建立了毗邻的租界，上海滩近百年的金融业发展历史，为探究这个问题提供了绝佳的自然实验场所。

## **实证研究的核心难题**

**难题一：遗漏变量与选择偏误（Omitted variable bias and Selection Bias）**

在跨国研究中，法律体系的选择并非随机，而是与一国的历史、文化、政治制度、殖民历史等因素高度相关。例如：

- 英国殖民地采用普通法可能是因为英国本身具有强大的经济影响力和军事实力
- 采用普通法的国家可能同时拥有更好的政治制度、更高的人力资本、更强的产权保护传统

如果无法控制这些混淆因素，我们无法确定观察到的金融发展差异是由法律体系本身引起的，还是由伴随法律体系的其他制度特征引起的。

**难题二：时变混淆因素（Time-Varying Confounders）**

即使在同一城市内，两个租界的金融发展差异也可能由随时间变化的其他因素驱动，而非法律制度本身。例如：

- 外国银行进入的差异：英国银行可能更倾向于在英租界开设分支机构
- 人口流动：英租界可能吸引了更多的商业精英
- 基础设施投资：英国政府可能在英租界投入了更多的公共设施
- 暴力冲突与战争：中国国内战争（如太平天国、辛亥革命）对两个租界的影响可能不同

如果这些时变因素没有被控制，那么即使观察到英租界的金融发展更快，我们也无法确定这是法律制度的作用，还是其他动态因素的结果。

**难题三：测量误差与数据质量（Measurement Error and Data Quality）**

在经济史研究中，历史数据的收集往往是最令人头疼的地方：

- **银行数据不完整**：部分银行（尤其是中国传统钱庄）的历史记录缺失
- **地理位置不精确**：银行的确切地址可能难以确定
- **金融活动多样性**：外资银行、中国现代银行、传统钱庄的业务范围和记录方式差异巨大
- **股票市场数据有限**：早期股票市场交易记录不完整

如果因变量（金融发展）的测量存在系统性误差，可能导致错误的因果推断。

**难题四：外部有效性（External Validity）**

上海租界的特殊历史环境可能限制了研究结论的普适性：

- 上海是19世纪末20世纪初中国的金融中心，具有独特的地理和经济地位
- 租界是殖民统治的产物，法律制度的实施方式可能与正常主权国家不同
- 中国的文化、经济和政治背景与欧洲或拉美国家存在显著差异

即使上海租界的证据支持法律起源理论，我们也需要谨慎推广到其他情境。

## **识别策略与方法设计**

**准实验设计（quasi-natural experiment）**

作者利用上海租界的独特历史地理条件，构建了一个准实验设计：

- 1845-1936年间，英国和法国在上海建立了相邻的租界
- 在1845年建立时，两个租界的经济发展水平相似
- 两个租界位于同一城市，具有相似的地理文化条件和政治经济背景
- 唯一的系统性差异是法律制度：英租界实行普通法，法租界实行大陆法
- 更重要的是，法律制度经历了**两次关键变化**：
  - **1869年：混合法庭（Mixed Courts）建立**，英法正式在各自租界内实施本国法律体系
  - **1926年：混合法庭废除**，法律管辖权移交给中国法院
  - 可以使用**事件研究法**（event study）检验金融发展趋势在制度变化前后是否发生断点
  - 根据法律起源理论的主张，可以构建两个假设：
    - **预测1**：1869年混合法庭建立后，英租界的金融发展应该比法租界更快
    - **预测2**：1926年混合法庭废除后，英租界的金融发展优势应该缩小甚至消失

这种**空间双重差分**（spatial difference-in-differences）设计大大减少了选择偏误，使得作者能够在控制地理、经济和政治条件的情况下，分离出法律体系对金融发展的纯粹因果效应。

**数据收集与测量（Data Collection and Mesurement）**

**手工收集多源数据**：

- 从《上海财政史》（Shanghai Finance Gazetteer）、历史报纸档案、外交档案中手工收集银行地址和运营年份
- 收集近500个租界法庭商业案件的判决书，并进行文本分析（关键词频率统计）
- 使用GIS（Geographic Information System）技术精确定位每家银行的地理坐标

**多种金融发展指标**：

- Bank density（银行密度）：每平方公里的银行数量（总部+分支机构）
- Chinese bank density（中国银行密度）：剔除外资银行，单独考察中国本土金融机构
- Stock returns（股票回报率）：基于 North-China Herald 报纸的股价数据计算
- Bank performance（银行绩效）：使用ROA（资产回报率）、杠杆率等指标

**稳健性检验（Robustness Check）**

- 网格单元层面分析：将租界划分为100个网格单元，进行精细的空间分析
- 不同历史时期的子样本分析：
  - 清朝时期（1840-1910）：排除辛亥革命的影响
  - 和平时期（1865-1894）：排除太平天国和甲午战争的影响
  - 五年平均数据（1840-1925）：减少年度波动的影响
- 作者还将视野扩展到中国其他16个城市（如天津、汉口、广州），使用相同的识别策略比较普通法租界与大陆法租界的金融发展，以解决外部有效性问题

## **重要发现与结论**

**发现一：1869年混合法庭建立后，英租界的金融发展显著快于法租界**

- 基准估计：1869年后，英租界的银行密度平均比法租界高8.147家/平方公里
- 网格单元估计：在更精细的200m×200m网格层面，英租界的银行密度比法租界高0.317家/网格
- 中国银行子样本：排除外资银行后，英租界的中国银行密度仍比法租界高6.667家/平方公里

**发现二：1926年混合法庭废除后，英租界的金融发展优势显著缩小**

- **银行密度变化**：1926年后，英租界的银行密度相对于法租界下降了约7.326家/平方公里，这一下降幅度接近于1869年后积累的优势（8-9家/平方公里），表明法律优势的消失几乎抹平了此前的金融发展差异
- **银行绩效下降**：1926年前，英租界银行的ROA比法租界高0.819个百分点，1926年后，英租界银行的ROA相对下降了约1.3个百分点，差异不再显著
- **股票市场反应：**1926年8月法庭废除公告后的24个月内，英租界公司的股票回报率显著下降，英租界公司的股价在法庭废除后平均下跌了4.6%，反映了市场对法律制度变化的即时反应

**发现三：普通法对金融发展的优势具有普遍性**

- 天津、汉口、广州等城市的租界数据显示：
  - 普通法租界的银行密度平均比大陆法租界高4.511家/平方公里
  - 仅考察中国银行时，差异为3.793家/平方公里
- 这表明法律起源对金融发展的影响不是上海特有的现象，而是具有一定的普适性

## **学术价值**

- **方法论创新**：本文是**历史自然实验**（historical natural experiment）研究的杰出范例，收集多元历史数据，利用空间DID、两次制度冲击、网格单元等方法进行全方位检验
- **理论贡献：**本文通过准实验设计，证明了法律体系本身（而非伴随因素）对金融发展具有因果影响，并量化了法律制度的效应，有力地证明金融市场的发展依赖良好的法律制度，法律不仅是"上层建筑"，更是生产力发展的关键基础设施
