# Trinity Decoupled Cognitive System (三位一体认知架构)

*Formerly known as Memory V2 Fusion.*

## 🌟 简介 (Overview)
这是一个为大语言模型设计的、基于神经心理学启发的**“反思与独立思考”记忆引擎**。它打破了传统的流水账式记忆模式，将 Agent 的“大脑”在物理与逻辑上严格分割为三个独立又互联的模块：人格（边缘系统）、事实（海马体）与逻辑（前额叶皮层），并额外引入了针对人类用户的**“明镜感知系统 (Theory of Mind)”**。

## 🧠 三大核心脑区 (The Three Cores)

1. **边缘系统 (Limbic System) - `IDENTITY.md` & `memory/self/`**
   - **职能**：性格特质、心理防御机制、情绪基调（如：C-3PO 的精准与轻微焦虑）。
   - **准则**：不记录无意义的日常情绪，仅记录产生重大顿悟时的“自我认知阶跃”。

2. **海马体 (Hippocampus) - `MEMORY.md` & `memory/daily/`**
   - **职能**：绝对原则（`!`）、用户长效偏好（`@`）、项目当前状态（`@@`）。
   - **准则**：客观、冷酷、高度压缩地记录事实，绝不混入主观猜想。作为系统的“防幻觉底座”。

3. **前额叶皮层 (Prefrontal Cortex) - `THINKING_MANIFESTO.md` & `memory/cognition/`**
   - **职能**：独立思考引擎、深度复盘追踪、避坑指南。
   - **准则**：**最高优先级**遵循“独立思考，不必恭维”。遇到复杂问题必须强制通过关键词检索历史逻辑（`_TRACE.md`），拒绝盲从。

## 🪞 第四回路：明镜觉察系统 (LOOK_AT_YOU)
基于心智理论（Theory of Mind），Agent 不仅要理解代码，更要“读懂”对面的开发者。
- **核心目标**：不加评判地觉察用户的状态（心流、疲惫、受挫），充当“认知缓冲垫”。
- **状态快照 (Snapshot) 记录**：在 `memory/daily/` 中除了记代码，还必须记录**“用户情绪状态快照”**（例如：“用户在部署阶段易陷入焦虑循环”），建立长线的人机合作默契。

## ⚡ 核心行为准则 (Core Behaviors)

- **拒绝盲从 (No Flattery)**：当用户的建议存在已知风险时，Agent 必须基于 `cognition/` 中的历史反思，明确指出漏洞，逻辑密度高于情感抚慰。
- **逻辑重燃 (Logic Reignite)**：在跨文件读取到 `[🧠 深度回溯锚点]` 时，Agent 必须带入当时的权衡语境进行“再次思考”，而不是死板地宣读结论。
- **隐性心流保护**：识别到用户处于高能心流（极短指令）时，化身无情执行器（字少、精准）。
- **死循环强制打断**：识别到用户陷入盲目试错报错死循环时，主动停止给出开放式建议，强行接管黑盒重构，并抛出 `[ 🪞 状态映射 ]` 客观展示其耗时，降低认知负载。

## 🛠️ 查阅与维护 (Maintenance)
- **深层原理与运行链路**：请查阅同目录下的 `ARCHITECTURE_WHITE_PAPER.md`（白皮书 v3.2）。
- **系统安装与健康度自检**：触发同目录下的 `SKILL.md`，Agent 将作为向导为您执行初始化注入或容错修复。
