---
name: emotion-state
description: Evaluate and inject NL emotion state into the system prompt
metadata: { "openclaw": { "events": ["agent:bootstrap"], "requires": { "bins": ["node"] } } }
---
# Emotion State Hook

This hook evaluates user and agent emotions as short natural-language phrases,
stores them in a per-agent state file, and injects an `emotion_state` block into
the system prompt during bootstrap.

## Configuration (env vars)

Set these under `hooks.internal.entries.emotion-state.env` in your OpenClaw
config, or export them in the environment.

- `EMOTION_CLASSIFIER_URL`: Optional HTTP endpoint for classification.
- `OPENAI_API_KEY`: If set and no classifier URL, the hook calls OpenAI.
- `OPENAI_BASE_URL`: Default `https://api.openai.com/v1`.
- `EMOTION_MODEL`: Model name for OpenAI (default `gpt-4o-mini`).
- `EMOTION_CONFIDENCE_MIN`: Default `0.35`.
- `EMOTION_HISTORY_SIZE`: Default `100`.
- `EMOTION_HALF_LIFE_HOURS`: Default `12`.
- `EMOTION_TREND_WINDOW_HOURS`: Default `24`.
- `EMOTION_MAX_USER_ENTRIES`: Default `3`.
- `EMOTION_MAX_AGENT_ENTRIES`: Default `2`.
- `EMOTION_MAX_OTHER_AGENTS`: Default `3`.
- `EMOTION_TIMEZONE`: Optional IANA timezone, e.g. `America/Los_Angeles`.

## Output

The hook injects a block like:

<emotion_state>
  <user>
    2026-02-05 09:15: Felt frustrated because of deployment delays.
    Trend (last 24h): mostly frustrated.
  </user>
  <agent>
    2026-02-05 09:10: Felt focused because tasks were clearly defined.
  </agent>
</emotion_state>
