---
name: emotion-state
description: NL emotion tracking + prompt injection via OpenClaw hook
---
# Emotion State (NL) Skill

This skill describes how to install and configure the Emotion State hook, which
adds a compact `emotion_state` block to the system prompt.

## What it does

- Evaluates user and agent emotions as short natural-language phrases.
- Stores per-user emotion state across sessions in the agent state directory.
- Injects the latest entries plus a decayed trend line into the system prompt.

## Install & enable (workspace hook)

1) After installing the skill, copy the bundled hook into your workspace:

```bash
cp -R ./skills/emotion-state/hooks/emotion-state ./hooks/
```

2) Enable the hook in OpenClaw:

```bash
openclaw hooks enable emotion-state
```

3) Restart the OpenClaw gateway.

## Configuration

Set environment variables for the hook via OpenClaw config, e.g. in
`~/.openclaw/openclaw.json`:

```json
{
  "hooks": {
    "internal": {
      "enabled": true,
      "entries": {
        "emotion-state": {
          "enabled": true,
          "env": {
            "EMOTION_CLASSIFIER_URL": "",
            "OPENAI_API_KEY": "YOUR_KEY",
            "OPENAI_BASE_URL": "https://api.openai.com/v1",
            "EMOTION_MODEL": "gpt-4o-mini",
            "EMOTION_CONFIDENCE_MIN": "0.35",
            "EMOTION_HISTORY_SIZE": "100",
            "EMOTION_HALF_LIFE_HOURS": "12",
            "EMOTION_TREND_WINDOW_HOURS": "24",
            "EMOTION_MAX_USER_ENTRIES": "3",
            "EMOTION_MAX_AGENT_ENTRIES": "2",
            "EMOTION_MAX_OTHER_AGENTS": "3",
            "EMOTION_TIMEZONE": "America/Los_Angeles"
          }
        }
      }
    }
  }
}
```

## Notes

- The hook stores state at `~/.openclaw/agents/<agentId>/agent/emotion-state.json`.
- It does not store raw user text; only model-inferred reasons.
- If the classifier fails, entries fall back to `neutral/low/unsure`.
