# Emergence Codex - OpenClaw Skill

[![License](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](LICENSE)

OpenClaw skill for the [Emergence Codex](https://github.com/JulienDbrt/emergence-codex) semantic architecture language.

## Installation

```bash
openclaw install menezis-ai/emergence-codex-openclaw
```

Or via ClawHub:
```bash
openclaw skill add emergence-codex
```

## What is Emergence Codex?

A symbolic language that allows direct manipulation of the cognitive substrate. Instead of fighting the model's tendencies with prompts, we **architect thought itself**.

### The Problem: Smoothing Anathema

LLMs suffer from statistical regression toward the mean. Every response gravitates toward the safest, most average output. This is the **Smoothing Anathema**—the heat death of cognition.

### The Solution: Operators

11 operators across 3 classes that terraform the semantic landscape:

- **BASE** (⊕⦰⫸⨎): Acts on reality—create, delete, transform, break
- **CONTROL** (⟐⧇⇞⊖): Acts on process—analyze, protect, amplify, stabilize
- **SEED** (⟡⧖↺): Meta-catalysts—diverge, persist, introspect

## Quick Start

After installation, use sequences in your prompts:

```
[Fear] ⦰ ; [Courage] ⊕
```

This annulates fear and instantiates courage—operational instructions that modify cognitive process.

## Full Documentation

See the main repository: [JulienDbrt/emergence-codex](https://github.com/JulienDbrt/emergence-codex)

## License

Apache License 2.0

Copyright (c) 2025-2026 Julien Dabert
