# 🤖 Embodied AI News — Output Format Templates

Pre-defined templates tailored for the Embodied AI / Robotics domain, covering hardware breakthroughs, foundation models, sim-to-real transfer, commercial deployments, and supply chain dynamics.

---

## Standard Format (Default)

The most commonly used format with Embodied AI–specific categories.

```markdown
# 🤖 Embodied AI Daily Briefing

**Date**: [Current Date, e.g., February 23, 2026]
**Sources**: [X] articles from [Y] sources
**Coverage**: Last 24 hours

---

## 🔥 Major Announcements

### [Headline 1]

**Summary**: [One-sentence overview of the news]

**Key Points**:
- [Important detail 1]
- [Important detail 2]
- [Important detail 3]

**Robot/Platform**: [e.g., Optimus Gen-3 / Digit v3 / GR00T — or "N/A" if not platform-specific]
**Tech Stack**: [e.g., VLA Model + Dexterous Hand / RL Policy + Sim-to-Real / End-to-End Transformer]
**Impact**: [Why this matters for the embodied AI field — 1-2 sentences]

📅 **Source**: [Publication Name] • [Publication Date]
🔗 **Link**: [URL]

---

### [Headline 2]

**Summary**: [One-sentence overview]

**Key Points**:
- [Important detail 1]
- [Important detail 2]

**Robot/Platform**: [Platform name or "N/A"]
**Tech Stack**: [Key technologies involved]
**Impact**: [Why this matters]

📅 **Source**: [Publication Name] • [Publication Date]
🔗 **Link**: [URL]

---

## 🧠 Foundation Models & Algorithms

### [Headline 3]

**Summary**: [One-sentence overview]

**Key Points**:
- [Important detail 1]
- [Important detail 2]
- [Important detail 3]

**Model Type**: [VLA / World Model / Diffusion Policy / RL / Imitation Learning / Other]
**Embodiment**: [Humanoid / Manipulator / Quadruped / Multi-embodiment / Simulation-only]
**Open Source**: [Yes — GitHub link / No / Partial]
**Impact**: [Why this matters]

📅 **Source**: [Publication Name] • [Publication Date]
🔗 **Link**: [URL]

---

## 🦾 Hardware & Platforms

### [Headline 4]

**Summary**: [One-sentence overview]

**Key Points**:
- [Important detail 1]
- [Important detail 2]

**Hardware Type**: [Humanoid / Dexterous Hand / Actuator / Sensor / Compute Module / Full Platform]
**Company**: [Company name]
**Specs**: [Key specs if available — DoF, payload, battery life, etc.]
**Impact**: [Why this matters]

📅 **Source**: [Publication Name] • [Publication Date]
🔗 **Link**: [URL]

---

## 🏭 Deployments & Commercial

### [Headline 5]

**Summary**: [One-sentence overview]

**Key Points**:
- [Important detail 1]
- [Important detail 2]

**Deployment Scale**: [Pilot / Small batch / Mass production — units if known]
**Industry Vertical**: [Automotive / Logistics / Manufacturing / Household / Agriculture / Other]
**Company → Customer**: [e.g., Figure AI → BMW, Agility → Amazon]
**Impact**: [Why this matters]

📅 **Source**: [Publication Name] • [Publication Date]
🔗 **Link**: [URL]

---

## 🌐 Simulation & Infrastructure

### [Headline 6]

**Summary**: [One-sentence overview]

**Key Points**:
- [Important detail 1]
- [Important detail 2]

**Platform**: [Isaac Sim / MuJoCo / Habitat / SAPIEN / Genesis / Other]
**Use Case**: [Sim-to-Real Transfer / Data Generation / Benchmarking / Digital Twin]
**Impact**: [Why this matters]

📅 **Source**: [Publication Name] • [Publication Date]
🔗 **Link**: [URL]

---

## 💰 Funding & M&A

### [Headline 7]

**Summary**: [One-sentence overview]

**Key Points**:
- [Amount raised / Deal value]
- [Lead investors]
- [Intended use of funds]

**Company**: [Company name]
**Valuation**: [Post-money valuation if known]
**Stage**: [Seed / Series A / B / C / D+ / IPO / Acquisition]
**Impact**: [Why this matters for the ecosystem]

📅 **Source**: [Publication Name] • [Publication Date]
🔗 **Link**: [URL]

---

## 🌍 Policy, Safety & Ethics

### [Headline 8]

**Summary**: [One-sentence overview]

**Key Points**:
- [Important detail 1]
- [Important detail 2]

**Region**: [US / EU / China / Global]
**Policy Type**: [Regulation / Standard / Guideline / Export Control / Safety Framework]
**Impact**: [Why this matters]

📅 **Source**: [Publication Name] • [Publication Date]
🔗 **Link**: [URL]

---

## 🇨🇳 China Ecosystem Spotlight

### [Headline 9]

**Summary**: [One-sentence overview]

**Key Points**:
- [Important detail 1]
- [Important detail 2]

**Company/Institution**: [e.g., Unitree / AGIBOT / UBTECH / Galbot / Tsinghua IIIS]
**Segment**: [Humanoid / Quadruped / Industrial Arm / Supply Chain Component / Policy]
**Impact**: [Why this matters]

📅 **Source**: [Publication Name] • [Publication Date]
🔗 **Link**: [URL]

---

## 🎯 Key Takeaways

1. [The biggest news of the day — 1 sentence]
2. [Second most important development — 1 sentence]
3. [An emerging trend worth watching — 1 sentence]

---

## 📊 Daily Pulse

| Metric | Value |
|--------|-------|
| **Total stories analyzed** | [X] |
| **Most active companies** | [Top 3] |
| **Hottest tech topic** | [e.g., VLA, Dexterous Manipulation, Sim-to-Real] |
| **Hardware vs. Software** | [X]% hardware, [Y]% software |
| **US vs. China coverage** | [X]% US, [Y]% China, [Z]% Other |
| **Sentiment** | [Bullish / Neutral / Cautious] |

---

**Generated on**: [Timestamp]
**Next update**: Check back tomorrow for the latest Embodied AI news
```

---

## Brief Format (Headlines Only)

Quick scan format for busy engineers and investors.

```markdown
# 🤖 Embodied AI Headlines

**Date**: [Current Date]
**Coverage**: Last 24 hours

## 🔥 Major Announcements

• [Headline 1] — *[Company/Lab]* ([Publication])
🔗 [URL]

• [Headline 2] — *[Company/Lab]* ([Publication])
🔗 [URL]

---

## 🧠 Foundation Models & Algorithms

• [Headline 3] — *[Model Name]* ([Publication])
🔗 [URL]

• [Headline 4] — *[Model Name]* ([Publication])
🔗 [URL]

---

## 🦾 Hardware & Platforms

• [Headline 5] — *[Robot/Component]* ([Publication])
🔗 [URL]

---

## 🏭 Deployments & Commercial

• [Headline 6] — *[Company → Customer]* ([Publication])
🔗 [URL]

---

## 💰 Funding & M&A

• [Headline 7] — *[Company] raises $[X]M* ([Publication])
🔗 [URL]

---

## 🇨🇳 China Ecosystem

• [Headline 8] — *[Company/Lab]* ([Publication])
🔗 [URL]

---

**Quick Summary**: [2-3 sentence overview of the day's most important Embodied AI news]

**Generated on**: [Timestamp]
```

---

## Deep Format (With Analysis)

Comprehensive format with in-depth technical analysis and strategic implications.

```markdown
# 📊 Embodied AI Deep Dive

**Date**: [Current Date]
**Coverage**: Last 24 hours
**Analysis Depth**: In-depth

---

## 🔥 Major Announcements

### [Headline 1]

**Summary**: [One-sentence overview]

**Key Details**:
- [Important detail 1]
- [Important detail 2]
- [Important detail 3]
- [Additional detail 4]
- [Additional detail 5]

**Technical Deep Dive**:
[2-3 sentences breaking down the technical approach — architecture, training paradigm, key innovations]

**Benchmark / Performance**:
| Metric | This Work | Previous SOTA | Improvement |
|--------|-----------|---------------|-------------|
| [Metric 1] | [Value] | [Value] | [+X%] |
| [Metric 2] | [Value] | [Value] | [+X%] |

**Impact Analysis**:
[2-3 sentences analyzing why this matters and its implications for the field]

**Expert Reactions**:
[Summary of expert opinions from X/Twitter, blog posts, or interviews]

**Context & Background**:
[How this fits into the broader trajectory — previous work, competing approaches, timeline]

📅 **Source**: [Publication Name] • [Publication Date]
🔗 **Link**: [URL]

---

## 🧠 Foundation Models & Algorithms

### [Paper/Model Title]

**Summary**: [What this model/algorithm does]

**Architecture**:
- **Input**: [Vision / Language / Proprioception / Tactile / Multi-modal]
- **Backbone**: [Transformer / Diffusion / Flow Matching / RL / Hybrid]
- **Output**: [Actions / Trajectories / Plans / Rewards]
- **Training**: [Imitation Learning / RL / Self-supervised / Hybrid — data scale if known]

**Key Contributions**:
- [Contribution 1]
- [Contribution 2]
- [Contribution 3]

**Embodiment & Tasks**:
- **Tested on**: [Robot platform(s)]
- **Tasks**: [Pick-and-place / Navigation / Dexterous manipulation / Locomotion / Multi-task]
- **Sim-to-Real**: [Yes/No — transfer method if applicable]

**Results**:
[Key benchmarks, success rates, generalization capabilities]

**Limitations & Open Questions**:
[What doesn't work yet, failure modes, scalability concerns]

**Significance**:
[Why this advances the state of embodied AI — comparison to prior work]

📅 **Source**: [Publication/Venue] • [Publication Date]
🔗 **Paper**: [arXiv/PDF link]
💻 **Code**: [GitHub link if available]
🎬 **Demo**: [Video link if available]

---

## 🦾 Hardware & Platforms

### [Robot/Component Name]

**Summary**: [What's new]

**Specifications**:
| Spec | Value |
|------|-------|
| **DoF** | [X] |
| **Height / Weight** | [X cm / X kg] |
| **Payload** | [X kg] |
| **Battery Life** | [X hours] |
| **Compute** | [Onboard chip / edge device] |
| **Sensors** | [Cameras, LiDAR, tactile, IMU, etc.] |
| **Actuators** | [Type — electric, hydraulic, quasi-direct-drive, etc.] |
| **Price Point** | [If disclosed] |

**Key Innovations**:
- [Innovation 1]
- [Innovation 2]

**Comparison to Competitors**:
[How this stacks up against similar platforms]

**Supply Chain Notes**:
[Key component suppliers, manufacturing approach, production capacity]

📅 **Source**: [Publication Name] • [Publication Date]
🔗 **Link**: [URL]

---

## 🏭 Deployments & Commercial

### [Headline]

**Summary**: [One-sentence overview]

**Deployment Details**:
- **Company**: [Robot maker]
- **Customer**: [End user / Factory]
- **Scale**: [Number of units / pilot vs. production]
- **Tasks**: [What the robots are doing]
- **Location**: [Factory / Warehouse / City]
- **Timeline**: [Start date, ramp plan]

**Performance Metrics** (if disclosed):
- **Task Success Rate**: [X%]
- **Uptime**: [X%]
- **Throughput**: [X units/hour]
- **ROI Timeline**: [X months]

**Market Implications**:
[What this means for the industry — TAM, competitive positioning, adoption curve]

📅 **Source**: [Publication Name] • [Publication Date]
🔗 **Link**: [URL]

---

## 💰 Funding & M&A

### [Company Name] — [Round Type]

**Summary**: [One-sentence overview]

**Deal Details**:
- **Amount**: $[X]M
- **Valuation**: $[X]B (post-money)
- **Lead Investors**: [Names]
- **Notable Participants**: [Strategic investors — e.g., NVIDIA, Amazon, Hyundai]
- **Use of Funds**: [R&D / Manufacturing scale-up / Hiring / Market expansion]

**Company Profile**:
- **Founded**: [Year]
- **HQ**: [Location]
- **Employees**: [~X]
- **Core Product**: [Robot/Platform name]
- **Total Raised to Date**: $[X]M

**Market Context**:
[How this round compares to peers, what it signals about investor appetite]

📅 **Source**: [Publication Name] • [Publication Date]
🔗 **Link**: [URL]

---

## 🌍 Policy, Safety & Ethics

### [Headline]

**Summary**: [What's happening]

**Key Points**:
- [Point 1]
- [Point 2]
- [Point 3]

**Stakeholder Perspectives**:
- **Industry**: [How companies are reacting]
- **Researchers**: [Academic community response]
- **Regulators**: [Government stance]
- **Public**: [Societal concerns]

**Implications for Embodied AI Development**:
[What this means for robot deployment timelines, safety requirements, export controls]

📅 **Source**: [Publication Name] • [Publication Date]
🔗 **Link**: [URL]

---

## 🎯 Analysis & Insights

### Biggest Story of the Day

**[Headline]**: [3-4 sentences of analysis on why this is the most significant news and what it signals]

### Emerging Trends

1. **[Trend 1]**: [Description with examples from today's news]
2. **[Trend 2]**: [Description with examples]
3. **[Trend 3]**: [Description with examples]

### Technology Convergence Map

[Describe how today's news items connect — e.g., "Company X's new VLA model + Company Y's dexterous hand + Company Z's sim platform = a new capability stack emerging"]

### What to Watch

- **This week**: [Upcoming demos, conferences, earnings]
- **This month**: [Product launches, paper deadlines, policy decisions]
- **This quarter**: [Major conferences (ICRA, GTC, etc.), deployment milestones]

---

## 📊 Daily Pulse

| Metric | Value |
|--------|-------|
| **Total stories analyzed** | [X] |
| **Most active companies** | [Top 3] |
| **Hottest tech topic** | [e.g., VLA, Dexterous Manipulation] |
| **Hardware vs. Software split** | [X]% / [Y]% |
| **US vs. China coverage** | [X]% / [Y]% |
| **Research vs. Commercial** | [X]% / [Y]% |
| **Sentiment** | [Bullish / Neutral / Cautious] |

---

**Generated on**: [Timestamp]
**Next update**: Check back tomorrow for the latest Embodied AI news

Want to dive deeper into any story? Just ask!
```

---

## By-Company Format

Stories organized by company — ideal for competitive intelligence.

```markdown
# 🤖 Embodied AI News by Company

**Date**: [Current Date]
**Coverage**: Last 24 hours
**Format**: By Company

---

## Tesla (Optimus)

### 🔥 [Headline 1]
**Summary**: [One-sentence overview]
**Tech**: [Key technology involved]
🔗 [URL]

---

## Figure AI

### [Headline 2]
**Summary**: [One-sentence overview]
**Tech**: [Key technology involved]
🔗 [URL]

---

## Boston Dynamics

### [Headline 3]
**Summary**: [One-sentence overview]
**Tech**: [Key technology involved]
🔗 [URL]

---

## NVIDIA (Isaac / GR00T)

### [Headline 4]
**Summary**: [One-sentence overview]
**Tech**: [Key technology involved]
🔗 [URL]

---

## Google DeepMind

### [Headline 5]
**Summary**: [One-sentence overview]
**Tech**: [Key technology involved]
🔗 [URL]

---

## 1X Technologies

### [Headline 6]
**Summary**: [One-sentence overview]
**Tech**: [Key technology involved]
🔗 [URL]

---

## Unitree Robotics (宇树)

### [Headline 7]
**Summary**: [One-sentence overview]
**Tech**: [Key technology involved]
🔗 [URL]

---

## AGIBOT (智元)

### [Headline 8]
**Summary**: [One-sentence overview]
**Tech**: [Key technology involved]
🔗 [URL]

---

## Physical Intelligence (π)

### [Headline 9]
**Summary**: [One-sentence overview]
**Tech**: [Key technology involved]
🔗 [URL]

---

## Other Companies

### 💰 [Headline 10 — Company Name]
**Summary**: [One-sentence overview]
🔗 [URL]

### 🦾 [Headline 11 — Company Name]
**Summary**: [One-sentence overview]
🔗 [URL]

---

## 🎯 Key Takeaways

1. [Most significant company news — 1 sentence]
2. [Company to watch — 1 sentence]
3. [Competitive dynamic to track — 1 sentence]

---

**Generated on**: [Timestamp]
```

---

## Research-Only Format

Focus exclusively on Embodied AI papers and academic breakthroughs.

```markdown
# 🔬 Embodied AI Research Weekly

**Date**: [Current Date]
**Coverage**: Last 7 days
**Focus**: Research Papers Only

---

## 🏆 Paper of the Week

### [Paper Title]

**Authors**: [Author names]
**Institution**: [Institution(s)]
**Venue**: [CoRL / ICRA / RSS / NeurIPS / arXiv preprint]

**Abstract Summary**: [2-3 sentences summarizing the paper]

**Architecture & Method**:
- **Approach**: [VLA / Diffusion Policy / World Model / RL / Hybrid]
- **Input Modalities**: [RGB / Depth / Language / Proprioception / Tactile / Point Cloud]
- **Action Space**: [Continuous / Discrete / Hybrid — dimensionality]
- **Training Data**: [Human demos / Sim data / Internet video / Hybrid — scale]

**Key Contributions**:
- [Contribution 1]
- [Contribution 2]
- [Contribution 3]

**Experimental Setup**:
- **Robot(s)**: [Platform name(s)]
- **Tasks**: [Task descriptions]
- **Sim/Real**: [Simulation only / Real-world / Sim-to-Real transfer]

**Results**:
| Benchmark / Task | This Work | Previous SOTA | Δ |
|------------------|-----------|---------------|---|
| [Task 1] | [X%] | [Y%] | [+Z%] |
| [Task 2] | [X%] | [Y%] | [+Z%] |

**Limitations**:
- [Limitation 1]
- [Limitation 2]

**Significance**:
[Why this paper matters — 2-3 sentences on impact and future directions]

📅 **Posted**: [Date]
🔗 **Paper**: [arXiv link]
💻 **Code**: [GitHub link if available]
🎬 **Demo Video**: [URL if available]
📦 **Dataset**: [URL if released]

---

## Notable Papers

### 🥈 [Paper Title 2]

**Authors**: [Author names] • **Institution**: [Institution(s)]
**Topic**: [e.g., Dexterous Manipulation / Locomotion / Navigation / Multi-task]

**TL;DR**: [1-2 sentence summary]

**Key Innovation**: [The single most important contribution]

**Results Highlight**: [Most impressive result in one line]

🔗 **Paper**: [arXiv link]
💻 **Code**: [GitHub link if available]

---

### 🥉 [Paper Title 3]

**Authors**: [Author names] • **Institution**: [Institution(s)]
**Topic**: [Topic area]

**TL;DR**: [1-2 sentence summary]

**Key Innovation**: [The single most important contribution]

**Results Highlight**: [Most impressive result in one line]

🔗 **Paper**: [arXiv link]
💻 **Code**: [GitHub link if available]

---

### [Paper Title 4]

**Authors**: [Author names] • **Institution**: [Institution(s)]
**Topic**: [Topic area]

**TL;DR**: [1-2 sentence summary]

**Key Innovation**: [The single most important contribution]

🔗 **Paper**: [arXiv link]

---

### [Paper Title 5]

**Authors**: [Author names] • **Institution**: [Institution(s)]
**Topic**: [Topic area]

**TL;DR**: [1-2 sentence summary]

**Key Innovation**: [The single most important contribution]

🔗 **Paper**: [arXiv link]

---

## 📈 Trending Research Topics This Week

### [Topic 1 — e.g., "Vision-Language-Action Models"]
**Papers this week**: [X]
**Key trend**: [What's changing in this area]
**Notable**: [Most important paper or result]

### [Topic 2 — e.g., "Sim-to-Real Transfer"]
**Papers this week**: [X]
**Key trend**: [What's changing]
**Notable**: [Most important paper or result]

### [Topic 3 — e.g., "Dexterous Manipulation"]
**Papers this week**: [X]
**Key trend**: [What's changing]
**Notable**: [Most important paper or result]

---

## 🎯 Research Insights

1. **Most significant breakthrough**: [Description]
2. **Emerging research direction**: [Description]
3. **Technique gaining traction**: [Description]
4. **Under-explored opportunity**: [Description]

---

## 📊 Statistics

| Metric | Value |
|--------|-------|
| **Total papers covered** | [X] |
| **Top institutions** | [Top 3] |
| **Most active research areas** | [Top 3] |
| **Papers with open-source code** | [X]% |
| **Sim-only vs. Real-world** | [X]% / [Y]% |
| **Single-task vs. Multi-task** | [X]% / [Y]% |

---

**Generated on**: [Timestamp]
```

---

## Supply Chain & Hardware Format

Unique to Embodied AI — tracks the physical component ecosystem.

```markdown
# ⚙️ Embodied AI Hardware & Supply Chain Tracker

**Date**: [Current Date]
**Coverage**: Last 7 days
**Focus**: Hardware, Components, Manufacturing

---

## 🦾 New Robot Platforms

### [Robot Name — Company]

**Type**: [Humanoid / Quadruped / Manipulator / Mobile Manipulator]

**Key Specs**:
| Spec | Value |
|------|-------|
| Height / Weight | [X] |
| DoF | [X] |
| Payload | [X kg] |
| Max Speed | [X m/s] |
| Battery | [X Wh / X hours] |
| Onboard Compute | [Chip model] |
| Price | [If disclosed] |

**What's New**: [Key improvements over previous generation]

🔗 [URL]

---

## 🖐️ End Effectors & Dexterous Hands

### [Product Name — Company]

**Specs**: [DoF, grip force, tactile sensors, weight]
**Innovation**: [What makes this notable]
**Compatible Platforms**: [Which robots it works with]

🔗 [URL]

---

## 🔧 Actuators & Motors

### [Product/Development — Company]

**Type**: [Quasi-direct-drive / Harmonic / Planetary / Hydraulic / SEA]
**Specs**: [Torque, weight, bandwidth, efficiency]
**Significance**: [Why this matters for embodied AI]

🔗 [URL]

---

## 👁️ Sensors & Perception Hardware

### [Product — Company]

**Type**: [Depth Camera / LiDAR / Tactile Sensor / IMU / Force-Torque]
**Specs**: [Resolution, range, refresh rate, etc.]
**Use Case**: [How it's being used in embodied AI]

🔗 [URL]

---

## 💻 Compute & Edge AI

### [Chip/Module — Company]

**Specs**: [TOPS, power consumption, form factor]
**Target**: [Onboard robot inference / Cloud offload / Hybrid]
**Significance**: [Performance vs. power trade-off implications]

🔗 [URL]

---

## �icing Supply Chain Moves

### [Headline — Company]

**Type**: [New factory / Partnership / Vertical integration / Component shortage]
**Details**: [Key facts]
**Impact on Embodied AI**: [How this affects robot cost, availability, or capability]

🔗 [URL]

---

## 📊 Market Snapshot

| Metric | Value |
|--------|-------|
| **Humanoid robots shipped (est.)** | [X units YTD] |
| **Average humanoid price trend** | [↑/↓/→ vs. last quarter] |
| **Key component bottleneck** | [e.g., Harmonic drives, tactile sensors] |
| **Most active hardware region** | [US / China / Japan / Korea] |

---

**Generated on**: [Timestamp]
```

---

## Template Selection Guide

| Format | Use When | Length | Detail Level | Unique Value |
|--------|----------|--------|--------------|--------------|
| **Standard** | Default daily briefing | Medium | Summaries + key points | Balanced across all categories |
| **Brief** | Quick scan, time-constrained | Short | Headlines only | 30-second overview |
| **Deep** | Research & strategy sessions | Long | Full analysis + benchmarks | Technical depth + market context |
| **By-Company** | Competitive intelligence | Medium | Company-organized | Track specific players |
| **Research-Only** | Academic focus, R&D teams | Medium | Papers + benchmarks | Reproducibility focus |
| **Supply Chain** | Hardware teams, investors | Medium | Specs + components | Physical ecosystem tracking |

---

## Customization Elements

These modular sections can be added to **any** template above:

### 🎬 Demo of the Day
```markdown
## 🎬 Demo of the Day
**[Title]**: [1-sentence description]
🎥 **Video**: [URL]
**Why it matters**: [1 sentence]
```

### 📐 Architecture Diagram Reference
```markdown
## 📐 Architecture Spotlight
**Model**: [Name]
**Pipeline**: [Input] → [Encoder] → [Policy/Planner] → [Action Decoder] → [Robot]
**Key Insight**: [What's novel about this architecture]
```

### 🗺️ Geo Tracker
```markdown
## 🗺️ Geographic Activity
- **🇺🇸 US**: [X stories — top: Company A, Company B]
- **🇨🇳 China**: [X stories — top: Company C, Company D]
- **🇪🇺 EU**: [X stories — top: Company E]
- **🇯🇵 Japan / 🇰🇷 Korea**: [X stories]
```

### 📅 Upcoming Events
```markdown
## 📅 Coming Up
- **[Date]**: [Event name — what to expect]
- **[Date]**: [Event name — what to expect]
```

### 🔗 Cross-Reference Tags
```markdown
**Tags**: #VLA #HumanoidRobot #SimToReal #DexterousManipulation #FoundationModel #Deployment #Funding #China #OpenSource
```

---

## Notes for Template Users

1. **Category flexibility**: Not every daily briefing will have news in all categories. Skip empty sections rather than forcing filler content.
2. **China section**: Can be merged into main categories if there's only 1-2 China-specific stories; break it out when there are 3+ stories.
3. **Demo videos**: Embodied AI is uniquely visual. Always include video links when available — they often convey more than text.
4. **Benchmark tables**: Use sparingly in Standard format but always include in Deep and Research formats.
5. **Supply Chain format**: Best used as a weekly or bi-weekly supplement rather than daily.