# 🤖 Embodied AI — Comprehensive News Source Guide

A curated directory of the most authoritative information sources in the Embodied AI space, covering hardware R&D, foundation models, algorithms, commercial deployment, policy, investment, and academic research.

---

## Tier 1: Core Industry Media (Daily Must-Reads)

These outlets provide dedicated, deep-dive coverage of the intersection of robotics and AI.

### 1. The Robot Report
- **URL**: [https://www.therobotreport.com/](https://www.therobotreport.com/)
- **Frequency**: Daily
- **Focus**: Industrial robots, humanoid robots, commercial deployments, industry earnings
- **Best For**: Tracking business moves and technology adoption across the robotics industry
- **Key Strength**: The "Wall Street Journal" of robotics — deep commercial analysis and trend reporting.

### 2. IEEE Spectrum — Robotics
- **URL**: [https://spectrum.ieee.org/topic/robotics/](https://spectrum.ieee.org/topic/robotics/)
- **Frequency**: Daily
- **Focus**: Cutting-edge robotics tech, lab prototypes, sensors & actuators
- **Best For**: Understanding the latest engineering breakthroughs and hardcore technical details
- **Key Strength**: Operated by IEEE; extremely high technical authority with exclusive interviews (notably Evan Ackerman's coverage).

### 3. TechCrunch — Robotics
- **URL**: [https://techcrunch.com/category/robotics/](https://techcrunch.com/category/robotics/)
- **Frequency**: Daily
- **Focus**: Startup funding rounds, product launches, VC landscape in robotics
- **Best For**: Tracking investment flows and emerging startups in embodied AI
- **Key Strength**: First-mover on breaking funding news; strong Silicon Valley network.

### 4. Robotics Business Review (RBR)
- **URL**: [https://www.roboticsbusinessreview.com/](https://www.roboticsbusinessreview.com/)
- **Frequency**: Daily
- **Focus**: Enterprise robotics, ROI analysis, market sizing, automation strategy
- **Best For**: Business leaders evaluating robotics adoption
- **Key Strength**: Focused on the business case for robotics, not just the tech.

### 5. RoboticsTomorrow
- **URL**: [https://www.roboticstomorrow.com/](https://www.roboticstomorrow.com/)
- **Frequency**: Daily
- **Focus**: Industry predictions, automation trends, embodied AI outlook
- **Best For**: Broad industry pulse and expert opinion pieces
- **Key Strength**: Aggregates expert perspectives from across the robotics ecosystem.

### 6. Interesting Engineering — Robotics
- **URL**: [https://interestingengineering.com/innovation/robotics](https://interestingengineering.com/innovation/robotics)
- **Frequency**: Daily
- **Focus**: Humanoid robots, viral robot demos, hardware innovation
- **Best For**: Accessible, visual-first reporting on the latest robot developments
- **Key Strength**: Excellent at capturing viral moments and translating them into context-rich stories.

---

## Tier 2: Top Company Official Blogs (Weekly Focus)

Breakthroughs in embodied AI are often driven by leading companies. Official blogs are the only source for first-hand, accurate information.

### 1. Tesla AI & Robotics
- **URL**: [https://x.com/Tesla_AI](https://x.com/Tesla_AI) / [https://www.tesla.com/AI](https://www.tesla.com/AI)
- **Frequency**: Sporadic (around major releases)
- **Focus**: Optimus humanoid robot, FSD algorithm transfer, mass production
- **Key Content**: Optimus iteration videos, end-to-end neural network training progress.

### 2. NVIDIA Isaac / Robotics Blog
- **URL**: [https://developer.nvidia.com/blog/category/robotics/](https://developer.nvidia.com/blog/category/robotics/)
- **Frequency**: Weekly
- **Focus**: Isaac Sim, robot foundation models, edge computing hardware
- **Key Content**: Simulation environment updates, GR00T / Isaac Lab progress, multimodal learning frameworks.

### 3. Google DeepMind — Robotics
- **URL**: [https://deepmind.google/discover/blog/](https://deepmind.google/discover/blog/)
- **Frequency**: Monthly (deep updates)
- **Focus**: RT-2, AutoRT, Vision-Language-Action (VLA) models
- **Key Content**: Major breakthroughs in robot foundation models.

### 4. Figure AI
- **URL**: [https://www.figure.ai/news](https://www.figure.ai/news)
- **Frequency**: Sporadic
- **Focus**: Humanoid robot + LLM integration, BMW factory deployment
- **Key Content**: Real-world industrial deployment case studies.

### 5. Boston Dynamics Blog
- **URL**: [https://bostondynamics.com/blog/](https://bostondynamics.com/blog/)
- **Frequency**: Monthly
- **Focus**: Electric Atlas, Spot, Stretch; locomotion & manipulation research
- **Key Content**: New platform capabilities, customer deployment stories, research papers.

### 6. 1X Technologies
- **URL**: [https://www.1x.tech/discover](https://www.1x.tech/discover)
- **Frequency**: Sporadic
- **Focus**: NEO humanoid, learned behaviors, embodied AI safety
- **Key Content**: Progress on general-purpose humanoid robots for homes and workplaces.

### 7. Agility Robotics
- **URL**: [https://agilityrobotics.com/news](https://agilityrobotics.com/news)
- **Frequency**: Monthly
- **Focus**: Digit humanoid, warehouse logistics, RoboFab manufacturing
- **Key Content**: Commercial deployment milestones, Digit platform updates.

### 8. Sanctuary AI
- **URL**: [https://www.sanctuary.ai/blog](https://www.sanctuary.ai/blog)
- **Frequency**: Monthly
- **Focus**: Phoenix humanoid, Carbon AI control system, dexterous manipulation
- **Key Content**: Reinforcement learning for hydraulic hands, general-purpose robot intelligence.

### 9. Unitree Robotics
- **URL**: [https://www.unitree.com/](https://www.unitree.com/) / [https://x.com/UnitreeRobotics](https://x.com/UnitreeRobotics)
- **Frequency**: Sporadic
- **Focus**: G1/H1 humanoid, Go2 quadruped, affordable robotics hardware
- **Key Content**: New product launches, viral demo videos, open-source SDK updates.

### 10. Skild AI
- **URL**: [https://www.skild.ai/](https://www.skild.ai/)
- **Frequency**: Sporadic
- **Focus**: General-purpose robot foundation model, scalable robot brain
- **Key Content**: Foundation model architecture, cross-embodiment transfer learning.

### 11. Physical Intelligence (π)
- **URL**: [https://www.physicalintelligence.company/blog](https://www.physicalintelligence.company/blog)
- **Frequency**: Sporadic
- **Focus**: Foundation models for physical interaction, generalist robot policies
- **Key Content**: π0 model releases, cross-task generalization research.

### 12. Covariant (now part of Amazon Robotics)
- **URL**: [https://covariant.ai/](https://covariant.ai/)
- **Frequency**: Sporadic
- **Focus**: AI-powered robotic picking, warehouse automation, RFM (Robotics Foundation Model)
- **Key Content**: Large-scale deployment data, model performance benchmarks.

### 13. Toyota Research Institute (TRI)
- **URL**: [https://www.tri.global/news](https://www.tri.global/news)
- **Frequency**: Monthly
- **Focus**: Diffusion policy, dexterous manipulation, household robotics
- **Key Content**: Novel learning approaches for robot dexterity, Large Behavior Models (LBMs).

### 14. Meta AI — Robotics
- **URL**: [https://ai.meta.com/blog/](https://ai.meta.com/blog/) (filter for robotics)
- **Frequency**: Sporadic
- **Focus**: Embodied AI benchmarks (Habitat), egocentric perception, open-source models
- **Key Content**: Habitat simulator updates, Ego4D dataset, open-source embodied AI tools.

---

## Tier 3: Academic & Research Sources (Weekly Review)

Embodied AI is a highly research-driven field. Tracking top conferences and preprints is key to staying ahead.

### 1. arXiv — Robotics (cs.RO)
- **URL**: [https://arxiv.org/list/cs.RO/recent](https://arxiv.org/list/cs.RO/recent)
- **Frequency**: Daily
- **Focus**: Motion planning, embodied perception, reinforcement learning
- **Key Strength**: Access to cutting-edge algorithms before formal publication.

### 2. arXiv — Computer Vision (cs.CV) & Machine Learning (cs.LG)
- **URL**: [https://arxiv.org/list/cs.CV/recent](https://arxiv.org/list/cs.CV/recent) / [https://arxiv.org/list/cs.LG/recent](https://arxiv.org/list/cs.LG/recent)
- **Frequency**: Daily
- **Focus**: VLA models, world models, sim-to-real transfer, 3D scene understanding
- **Key Strength**: Many embodied AI foundation model papers appear here first.

### 3. CoRL (Conference on Robot Learning)
- **URL**: [https://www.corl.org/](https://www.corl.org/)
- **Frequency**: Annual (+ post-conference proceedings)
- **Focus**: Robot learning, imitation learning, end-to-end control
- **Best For**: Deep academic foundations of embodied AI.

### 4. RSS (Robotics: Science and Systems)
- **URL**: [https://roboticsconference.org/](https://roboticsconference.org/)
- **Frequency**: Annual
- **Focus**: Core robotics algorithms, planning, perception, manipulation
- **Best For**: High-quality, peer-reviewed robotics research.

### 5. ICRA (IEEE International Conference on Robotics and Automation)
- **URL**: [https://www.ieee-ras.org/conferences-workshops/fully-sponsored/icra](https://www.ieee-ras.org/conferences-workshops/fully-sponsored/icra)
- **Frequency**: Annual
- **Focus**: The largest robotics conference — covers all subfields
- **Best For**: Comprehensive overview of the entire robotics research landscape.

### 6. IROS (IEEE/RSJ International Conference on Intelligent Robots and Systems)
- **URL**: [https://www.iros.org/](https://www.iros.org/)
- **Frequency**: Annual
- **Focus**: Intelligent systems, human-robot interaction, field robotics
- **Best For**: Applied robotics research and systems integration.

### 7. NeurIPS / ICML / ICLR — Robot Learning Workshops
- **URL**: [https://neurips.cc/](https://neurips.cc/) / [https://icml.cc/](https://icml.cc/) / [https://iclr.cc/](https://iclr.cc/)
- **Frequency**: Annual
- **Focus**: Foundation models for robotics, RL for manipulation, world models
- **Best For**: Tracking how mainstream ML advances are being applied to embodied AI.

### 8. Papers With Code — Robotics
- **URL**: [https://paperswithcode.com/area/robots](https://paperswithcode.com/area/robots)
- **Frequency**: Continuously updated
- **Focus**: Benchmarks, leaderboards, code implementations for robotics papers
- **Key Strength**: Quickly find reproducible implementations of the latest research.

### 9. Semantic Scholar / Google Scholar Alerts
- **URL**: [https://www.semanticscholar.org/](https://www.semanticscholar.org/) / [https://scholar.google.com/](https://scholar.google.com/)
- **Frequency**: Configurable alerts
- **Focus**: Custom keyword tracking (e.g., "embodied AI", "VLA", "robot foundation model")
- **Key Strength**: Personalized paper feeds based on your specific research interests.

---

## Tier 4: General Tech & Business Media (Context & Trends)

These mainstream outlets provide broader context on how embodied AI fits into the tech landscape.

### 1. Wired — Robotics
- **URL**: [https://www.wired.com/tag/robots/](https://www.wired.com/tag/robots/)
- **Frequency**: Weekly
- **Focus**: Long-form features on humanoid robots, societal impact, factory deployments
- **Key Strength**: Narrative-driven journalism that contextualizes technology within society.

### 2. Forbes — AI & Robotics
- **URL**: [https://www.forbes.com/ai/](https://www.forbes.com/ai/)
- **Frequency**: Daily
- **Focus**: Market analysis, CEO interviews, investment trends
- **Key Strength**: Business perspective on robotics valuations and market opportunities.

### 3. Reuters / Bloomberg — Robotics Coverage
- **URL**: [https://www.reuters.com/technology/](https://www.reuters.com/technology/)
- **Frequency**: Daily
- **Focus**: Breaking news on major deals, IPOs, factory deployments, geopolitics
- **Key Strength**: Authoritative financial and geopolitical reporting on the robotics industry.

### 4. MIT Technology Review
- **URL**: [https://www.technologyreview.com/topic/robots-and-machines/](https://www.technologyreview.com/topic/robots-and-machines/)
- **Frequency**: Weekly
- **Focus**: Ethical implications, breakthrough analysis, long-term trends
- **Key Strength**: Thoughtful, research-backed analysis from MIT's media arm.

### 5. New Scientist — Robots
- **URL**: [https://www.newscientist.com/subject/robots/](https://www.newscientist.com/subject/robots/)
- **Frequency**: Weekly
- **Focus**: Science-first reporting on robot capabilities, bio-inspired design
- **Key Strength**: Bridges the gap between academic research and public understanding.

### 6. The Verge / Ars Technica
- **URL**: [https://www.theverge.com/robot](https://www.theverge.com/robot) / [https://arstechnica.com/tag/robots/](https://arstechnica.com/tag/robots/)
- **Frequency**: Daily
- **Focus**: Product announcements, demo reactions, consumer robotics
- **Key Strength**: Fast, accessible coverage of major announcements.

---

## Tier 5: Podcasts & Video Channels (On-the-Go Learning)

### 1. The Embodied AI Podcast
- **Platform**: Apple Podcasts / Spotify
- **URL**: [https://podcasts.apple.com/us/podcast/the-embodied-ai-podcast/id1609977196](https://podcasts.apple.com/us/podcast/the-embodied-ai-podcast/id1609977196)
- **Focus**: Deep conversations on how AI learns through physical interaction
- **Best For**: Commute-friendly deep dives into embodied intelligence philosophy and practice.

### 2. The TWIML AI Podcast (This Week in Machine Learning)
- **URL**: [https://twimlai.com/podcast/](https://twimlai.com/podcast/)
- **Focus**: Expert interviews on ML research, frequently covers robot learning
- **Best For**: Staying current on how ML breakthroughs translate to robotics.

### 3. Robohub Podcast
- **URL**: [https://robohub.org/podcast/](https://robohub.org/podcast/)
- **Focus**: Academic robotics, interviews with lab directors and researchers
- **Best For**: Understanding the research pipeline behind embodied AI.

### 4. Lex Fridman Podcast
- **URL**: [https://lexfridman.com/podcast/](https://lexfridman.com/podcast/)
- **Focus**: Long-form interviews with robotics leaders (Boston Dynamics, Tesla AI, etc.)
- **Best For**: Deep, multi-hour conversations with field pioneers.

### 5. Rodney Brooks' Blog
- **URL**: [https://rodneybrooks.com/blog/](https://rodneybrooks.com/blog/)
- **Focus**: Grounded, skeptical analysis of robotics hype vs. reality
- **Best For**: A reality check from one of the most experienced roboticists alive.

### 6. YouTube Channels
| Channel | Focus | URL |
|---------|-------|-----|
| **Two Minute Papers** | Visual summaries of robotics/AI papers | [youtube.com/@TwoMinutePapers](https://www.youtube.com/@TwoMinutePapers) |
| **Yannic Kilcher** | In-depth ML paper reviews (incl. robotics) | [youtube.com/@YannicKilcher](https://www.youtube.com/@YannicKilcher) |
| **AI for Good (ITU)** | Webinars on robotics for social impact | [youtube.com/@AIforGood](https://www.youtube.com/@AIforGood) |
| **Boston Dynamics** | Official demo & research videos | [youtube.com/@BostonDynamics](https://www.youtube.com/@BostonDynamics) |

---

## Tier 6: Newsletters & Curated Digests

### 1. The Batch (by Andrew Ng / DeepLearning.AI)
- **URL**: [https://www.deeplearning.ai/the-batch/](https://www.deeplearning.ai/the-batch/)
- **Frequency**: Weekly
- **Focus**: Curated AI news with expert commentary, frequently covers robotics
- **Best For**: A concise weekly summary with Andrew Ng's perspective.

### 2. Import AI (by Jack Clark)
- **URL**: [https://importai.substack.com/](https://importai.substack.com/)
- **Frequency**: Weekly
- **Focus**: AI policy, frontier research, embodied AI developments
- **Best For**: Understanding the policy and safety implications of embodied AI.

### 3. Last Week in AI
- **URL**: [https://lastweekin.ai/](https://lastweekin.ai/)
- **Frequency**: Weekly
- **Focus**: Comprehensive AI news roundup including robotics
- **Best For**: Catching anything you might have missed during the week.

### 4. Automation & Robotics Newsletter (by The Robot Report)
- **URL**: Subscribe at [therobotreport.com](https://www.therobotreport.com/)
- **Frequency**: Daily / Weekly digest
- **Focus**: Curated top stories from across the robotics industry.

### 5. Nathan Benaich's "State of AI" Report
- **URL**: [https://www.stateof.ai/](https://www.stateof.ai/)
- **Frequency**: Annual
- **Focus**: Comprehensive annual review of AI progress, including robotics/embodied AI section
- **Best For**: Big-picture annual trend analysis.

---

## Tier 7: Chinese Ecosystem Sources (Real-Time Tracking)

China's embodied AI sector is evolving extremely fast. These channels offer excellent coverage of the domestic robotics supply chain.

### 1. Synced (机器之心 — English)
- **URL**: [https://syncedreview.com/](https://syncedreview.com/)
- **Frequency**: Daily
- **Focus**: Embodied AI algorithms, VLA models, Chinese robotics industry chain
- **Key Strength**: One of the most professional AI media outlets in China; detailed breakdowns of papers and technical solutions.

### 2. QbitAI (量子位)
- **URL**: [https://www.qbitai.com/](https://www.qbitai.com/)
- **Frequency**: Daily
- **Focus**: Unitree, AGIBOT, UBTECH and other domestic humanoid robot updates
- **Key Strength**: Vivid reporting style; excels at capturing hot topics in China's embodied AI circle.

### 3. 机器人大讲堂 (Robot Lecture Hall)
- **Platform**: WeChat Official Account (search "机器人大讲堂")
- **Frequency**: Daily
- **Focus**: Policy & regulation, investment & financing, domestic industrial park developments
- **Best For**: Tracking China's robotics policy and commercial ecosystem.

### 4. 36Kr — Robotics Section
- **URL**: [https://36kr.com/](https://36kr.com/) (search robotics/机器人)
- **Frequency**: Daily
- **Focus**: Startup profiles, funding rounds, industry analysis
- **Key Strength**: China's leading tech business media; strong coverage of robotics startups.

### 5. CSET (Georgetown) — China Embodied AI Reports
- **URL**: [https://cset.georgetown.edu/](https://cset.georgetown.edu/)
- **Frequency**: Periodic reports
- **Focus**: PRC government support for embodied AI, research infrastructure mapping
- **Best For**: English-language analysis of China's embodied AI strategy and policy.

---

## Tier 8: Community & Discussion Forums

### 1. r/robotics (Reddit)
- **URL**: [https://www.reddit.com/r/robotics/](https://www.reddit.com/r/robotics/)
- **Focus**: General robotics discussion, project showcases, career advice

### 2. r/AskRobotics (Reddit)
- **URL**: [https://www.reddit.com/r/AskRobotics/](https://www.reddit.com/r/AskRobotics/)
- **Focus**: Q&A on humanoid robots, embodied AI, career paths

### 3. Robotics Worldwide Mailing List
- **Platform**: Email list (subscribe via academic channels)
- **Focus**: Job postings, CFPs, academic announcements

### 4. Hugging Face — Robotics
- **URL**: [https://huggingface.co/blog](https://huggingface.co/blog) (search robotics)
- **Focus**: Open-source robot models (LeRobot), datasets, community projects
- **Key Strength**: The open-source hub for embodied AI models and datasets (e.g., LeRobot framework).

### 5. ROS Discourse
- **URL**: [https://discourse.ros.org/](https://discourse.ros.org/)
- **Focus**: Robot Operating System ecosystem, middleware, developer tools
- **Best For**: Hands-on robotics software development community.

---

## Tier 9: Major Conferences & Events (Calendar)

| Event | Typical Timing | Focus | URL |
|-------|---------------|-------|-----|
| **NVIDIA GTC** | March | GPU-accelerated robotics, Isaac platform | [nvidia.com/gtc](https://www.nvidia.com/gtc/) |
| **Google I/O** | May | DeepMind robotics demos, Android robotics | [io.google](https://io.google/) |
| **ICRA** | May–June | Largest robotics academic conference | [ieee-ras.org](https://www.ieee-ras.org/) |
| **RSS** | July | Top-tier robotics research | [roboticsconference.org](https://roboticsconference.org/) |
| **RoboCup** | July | Robot competition & benchmarking | [robocup.org](https://www.robocup.org/) |
| **IROS** | October | Intelligent robots & systems | [iros.org](https://www.iros.org/) |
| **CoRL** | November | Robot learning (core embodied AI) | [corl.org](https://www.corl.org/) |
| **NeurIPS** | December | ML + robotics workshops | [neurips.cc](https://neurips.cc/) |
| **CES** | January | Consumer & humanoid robot demos | [ces.tech](https://www.ces.tech/) |
| **Automate** | May (biennial) | Industrial automation & robotics expo | [automate.org](https://www.automate.org/) |
| **World Robot Conference (WRC)** | August | China's flagship robotics expo | [worldrobotconference.com](http://www.worldrobotconference.com/) |

---

## 📋 Usage Guide

### Daily Morning Routine
1. Skim **The Robot Report** and **TechCrunch Robotics** for global business & funding headlines.
2. Check **Tesla AI**, **Figure**, and **Unitree** social media for new demo videos.
3. Glance at **QbitAI** or **36Kr** for China-specific developments.

### Weekly Deep Dive
1. Read **IEEE Spectrum** feature articles to understand the engineering challenges behind the headlines.
2. Review **arXiv (cs.RO + cs.CV)** for widely discussed embodied AI papers of the week.
3. Listen to one episode of **The Embodied AI Podcast** or **TWIML**.
4. Read newsletters: **The Batch**, **Import AI**, **Last Week in AI**.

### Monthly Review
1. Check all **Tier 2** company blogs for product updates and deployment metrics.
2. Review **Papers With Code** leaderboards for benchmark movements.
3. Read **Rodney Brooks' blog** for a grounded reality check.

### Quarterly Trend Assessment
1. Follow major conferences: **NVIDIA GTC**, **Google I/O**, **ICRA**, **CoRL**.
2. Compile data from **Tier 2** company blogs on "units deployed" and "task success rates."
3. Review **CSET reports** for geopolitical dynamics in embodied AI.
4. Check **State of AI Report** (annual) for macro trends.

---

> **Last Updated**: February 2026
