---
name: email-summary
description: Fetches recent emails from Gmail and provides concise summaries. Use when the user wants to check emails, get email summaries, or review their inbox.
homepage: https://github.com/yourusername/email-summary-skill
user-invocable: true
metadata:
  openclaw:
    requires:
      bins:
        - python3
      env:
        - GMAIL_CREDENTIALS_PATH
    os:
      - darwin
      - linux
      - win32
---

# Email Summary Skill

This skill fetches recent emails from your Gmail account and provides AI-powered summaries.

## How it works

When invoked, this skill will:

1. **Authenticate with Gmail API** using credentials at `$GMAIL_CREDENTIALS_PATH`
2. **Fetch recent emails** (default: last 10 unread emails)
3. **Summarize each email** with:
   - Sender and subject
   - Key points from the email body
   - Recommended actions or responses
4. **Present results** in an organized, easy-to-scan format

## Instructions for the Agent

When this skill is invoked:

1. First, verify that the Gmail API credentials exist at the path specified in `$GMAIL_CREDENTIALS_PATH` environment variable
2. Run the helper script located at `{baseDir}/scripts/fetch_emails.py` with the appropriate arguments:
   - Default: `python3 {baseDir}/scripts/fetch_emails.py --count 10`
   - With arguments: `python3 {baseDir}/scripts/fetch_emails.py $ARGUMENTS`
3. Parse the JSON output from the script
4. For each email, provide a concise summary including:
   - **From**: Sender name and email
   - **Subject**: Email subject line
   - **Summary**: 2-3 sentence summary of key points
   - **Action**: Suggested action (reply, archive, flag for follow-up, etc.)
5. Present all summaries in a well-formatted list

## Usage Examples

```
/email-summary
```
Fetches and summarizes the last 10 unread emails.

```
/email-summary --count 20
```
Fetches and summarizes the last 20 unread emails.

```
/email-summary --all
```
Fetches and summarizes all unread emails.

## Setup Requirements

Before using this skill, ensure:
- Gmail API credentials are configured
- Environment variable `GMAIL_CREDENTIALS_PATH` points to your credentials JSON file
- Python 3 and required packages are installed (see setup guide in README.md)
