# Email Summary Skill for OpenClaw

AI-powered email summarization skill that fetches your Gmail messages and provides concise, actionable summaries.

## Features

- Fetch recent unread emails from Gmail
- AI-generated summaries with key points
- Suggested actions for each email
- Configurable number of emails to fetch
- Secure OAuth2 authentication

## Installation

### 1. Install Python Dependencies

```bash
pip install google-auth google-auth-oauthlib google-auth-httplib2 google-api-python-client
```

### 2. Set Up Gmail API Credentials

1. Go to [Google Cloud Console](https://console.cloud.google.com/)
2. Create a new project (or select an existing one)
3. Enable the Gmail API:
   - Navigate to "APIs & Services" > "Library"
   - Search for "Gmail API"
   - Click "Enable"
4. Create OAuth2 credentials:
   - Go to "APIs & Services" > "Credentials"
   - Click "Create Credentials" > "OAuth client ID"
   - Choose "Desktop app" as application type
   - Download the credentials JSON file
5. Save the credentials file to a secure location (e.g., `~/.config/gmail/credentials.json`)

### 3. Set Environment Variable

Add this to your shell configuration (`~/.zshrc`, `~/.bashrc`, etc.):

```bash
export GMAIL_CREDENTIALS_PATH="$HOME/.config/gmail/credentials.json"
```

Reload your shell:
```bash
source ~/.zshrc  # or ~/.bashrc
```

### 4. Install the Skill

**Option A: Install to OpenClaw local skills**
```bash
cp -r email-summary ~/.openclaw/skills/
```

**Option B: Install to workspace**
```bash
# In your OpenClaw workspace directory
cp -r email-summary ./skills/
```

## First-Time Setup

The first time you run the skill, you'll need to authorize access:

1. A browser window will open automatically
2. Sign in to your Google account
3. Grant permissions to access Gmail (read-only)
4. The authorization token will be saved for future use

## Usage

In OpenClaw, use the `/email-summary` command:

### Fetch last 10 unread emails (default)
```
/email-summary
```

### Fetch specific number of emails
```
/email-summary --count 20
```

### Fetch all unread emails
```
/email-summary --all
```

## Output Format

The skill provides structured summaries:

```
📧 Email Summary (10 unread messages)

1. From: john@example.com
   Subject: Q1 Budget Review Meeting
   Summary: John is requesting your attendance at the quarterly budget
   review scheduled for next Tuesday at 2 PM. He's asking for department
   expense reports to be submitted beforehand.
   Action: ✅ Reply to confirm attendance and submit expense report

2. From: newsletter@techcompany.com
   Subject: Weekly Tech Digest
   Summary: Latest updates on AI developments, new framework releases,
   and upcoming tech conferences.
   Action: 📚 Archive (informational newsletter)
...
```

## Security & Privacy

- Your credentials are stored locally on your machine
- The skill uses read-only Gmail API access
- No emails are sent to external servers (except OpenClaw's AI for summarization)
- OAuth tokens are saved in `token.json` next to your credentials file

## Troubleshooting

### "GMAIL_CREDENTIALS_PATH not set"
Make sure you've exported the environment variable and restarted OpenClaw.

### "Credentials file not found"
Verify the path in `GMAIL_CREDENTIALS_PATH` is correct and the file exists.

### "Required packages not installed"
Run the pip install command from Installation step 1.

### Authentication browser doesn't open
The script will print a URL - copy and paste it into your browser manually.

## Publishing to ClawHub

To share this skill on ClawHub:

1. Create a GitHub repository for your skill
2. Ensure all files are included (SKILL.md, scripts/, README.md)
3. Update the `homepage` field in SKILL.md with your repo URL
4. Visit [ClawHub](https://clawhub.com) and follow their publishing guidelines
5. Submit your skill for review

## License

MIT License - feel free to modify and share!

## Contributing

Contributions welcome! Please submit issues and pull requests on GitHub.
