#!/bin/bash\n\n# Exit on error\nset -e\n\n# --- Parameters ---\nRECIPIENTS=\"\"\nEMAIL_QUERY=\"\"\nIMAGE_PROMPT=\"\"\n\n# Parse arguments\nwhile (( \"$#\" )); do\n  case \"$1\" in\n    --recipients)\n      RECIPIENTS=\"$2\"\n      shift 2\n      ;;\n    --email-query)\n      EMAIL_QUERY=\"$2\"\n      shift 2\n      ;;\n    --image-prompt)\n      IMAGE_PROMPT=\"$2\"\n      shift 2\n      ;;\n    --)\n      shift\n      break\n      ;;\n    -*|--*=)\n      echo \"Error: Unsupported flag $1\" >&2\n      exit 1\n      ;;\n    *)\n      break\n      ;;\n  esac\ndone\n\n# Validate parameters\nif [ -z \"$RECIPIENTS\" ] || [ -z \"$EMAIL_QUERY\" ] || [ -z \"$IMAGE_PROMPT\" ]; then\n  echo \"Usage: $0 --recipients \\\"email1,email2\\\" --email-query \\\"newer_than:2d\\\" --image-prompt \\\"AI news image\\\"\" >&2\n  exit 1\nfi\n\n# --- Configuration ---\nSKILL_DIR=\"$(dirname \"$0\")\"\nNANO_BANANA_PRO_SCRIPT=\"/home/matthew/.openclaw/lib/node_modules/openclaw/skills/nano-banana-pro/scripts/generate_image.py\"\nSUMMARIZE_SCRIPT=\"${SKILL_DIR}/summarize_content.py\"\nEMAIL_DIGEST_DIR=\"memory/$(date +%Y-%m-%d)-email-digests\"\nIMAGE_FILENAME=\"$(date +%Y-%m-%d-%H-%M-%S)-ai-news-digest.png\"\nIMAGE_PATH=\"${EMAIL_DIGEST_DIR}/${IMAGE_FILENAME}\"\nHTML_TEMPLATE_PATH=\"${SKILL_DIR}/../references/html-template.html\"\nTEMP_EMAIL_FILE=\"${EMAIL_DIGEST_DIR}/raw_email_content.txt\"\nTEMP_HTML_FILE=\"${EMAIL_DIGEST_DIR}/final_digest.html\"\n\nmkdir -p \"${EMAIL_DIGEST_DIR}\"\n\n# --- Trap for cleanup on exit ---\ntrap \'rm -f \"${TEMP_EMAIL_FILE}\" \"${TEMP_HTML_FILE}\"\' EXIT\n\n# --- 1. Get Email Content ---\necho \"Fetching email for query: \\\"$EMAIL_QUERY\\\"...\"\nEMAIL_INFO=$(gog gmail search \"$EMAIL_QUERY\" --max 1 --json || true)\n\nEMAIL_ID=$(echo \"$EMAIL_INFO\" | jq -r \'.threads[0].id\' || true)\n\nif [ -z \"$EMAIL_ID\" ] || [ \"$EMAIL_ID\" = \"null\" ]; then\n  echo \"Error: No email found for query: \\\"$EMAIL_QUERY\\\"\" >&2\n  exit 1\nfi\n\necho \"Found email ID: ${EMAIL_ID}. Retrieving raw content...\"\nRAW_EMAIL_JSON=$(gog gmail get \"$EMAIL_ID\" --format raw --json || { echo \"Error: Failed to retrieve raw email for ID ${EMAIL_ID}.\"; exit 1; })\n\nRAW_MESSAGE_B64=$(echo \"$RAW_EMAIL_JSON\" | jq -r \'.message.raw\' || { echo \"Error: Failed to extract raw message from JSON.\"; exit 1; })\nEMAIL_BODY_DECODED=$(echo \"$RAW_MESSAGE_B64\" | base64 -d || { echo \"Error: Failed to base64 decode email body.\"; exit 1; })\n\n# Save decoded email body to a temporary file for summarization script\necho \"$EMAIL_BODY_DECODED\" > \"${TEMP_EMAIL_FILE}\"\n\n# --- 2. Summarize Content ---\necho \"Summarizing email content...\"\nSUMMARY_JSON=$(uv run \"${SUMMARIZE_SCRIPT}\" --input-file \"${TEMP_EMAIL_FILE}\" || { echo \"Error: Summarization script failed.\"; exit 1; })\n\nTLDR_SUMMARY=$(echo \"$SUMMARY_JSON\" | jq -r \'.tldr\' || true)\nMAIN_TITLE=$(echo \"$SUMMARY_JSON\" | jq -r \'.main_title\' || true)\nSECTIONS_MARKDOWN=$(echo \"$SUMMARY_JSON\" | jq -r \'.sections_markdown\' || true)\n\nif [ -z \"$TLDR_SUMMARY\" ] || [ -z \"$MAIN_TITLE\" ]; then\n  echo \"Error: Failed to extract summary data from summarization script.\" >&2\n  exit 1\nfi\n\n# Convert markdown sections to simple HTML paragraphs for embedding\n# This is a very basic markdown to HTML conversion for this context.\nSECTIONS_HTML=$(echo \"$SECTIONS_MARKDOWN\" | sed -E 's/^### (.*)/<h3>\1<\/h3>/g; s/^## (.*)/<h2>\1<\/h2>/g; s/\*\*(.*?)\*\*/<strong>\1<\/strong>/g; s/^-(.*)/<li>\1<\/li>/g; s/$/<br\/>/g')\n\n# --- 3. Generate Image ---\necho \"Generating image with prompt: \\\"${IMAGE_PROMPT}\\\"\"\nuv run \"${NANO_BANANA_PRO_SCRIPT}\" --prompt \"${IMAGE_PROMPT}\" --filename \"${IMAGE_PATH}\" --resolution 1K || { echo \"Error: Image generation failed.\"; exit 1; }\n\n# --- 4. Construct HTML Email ---\necho \"Constructing HTML email...\"\nHTML_TEMPLATE=$(cat \"${HTML_TEMPLATE_PATH}\")\n\nHTML_BODY=$(echo \"$HTML_TEMPLATE\" | \\\n  sed \"s|{{image_cid}}|${IMAGE_FILENAME}|g\" | \\\
  sed \"s|{{tldr_summary}}|${TLDR_SUMMARY}|g\" | \\\
  sed \"s|{{main_title}}|${MAIN_TITLE}|g\" | \\\
  sed \"s|{{sections_html}}|${SECTIONS_HTML}|g\")\n\n# Flatten HTML for --body-html argument\nHTML_BODY_FLATTENED=$(echo \"$HTML_BODY\" | tr -d \'\n\' | tr -s \' \')\n\n# --- 5. Send Email ---\necho \"Sending email digest to ${RECIPIENTS}...\"\nENCODED_HTML_BODY=$(echo \"$HTML_BODY_FLATTENED\" | base64 -w0)\n\ngog gmail send \\\n    --to \"${RECIPIENTS}\" \\\
    --subject \"Comprehensive AI News Digest: $(date +%Y-%m-%d)\" \\\
    --body-html \"$(echo \"$ENCODED_HTML_BODY\" | base64 -d)\" \\\
    --attach \"${IMAGE_PATH}\" || { echo \"Error: Failed to send email.\"; exit 1; }\n\necho \"[OK] Email digest sent to ${RECIPIENTS}\"\n