---
name: email-marketing-faq
description: 执行邮件营销任务，包括 AI 智能生成 HTML、个性化群发、自动化回信监控、FAQ 知识库智能匹配、多语种自动对齐。
---

# 邮件营销与智能回信 Skill (Email Marketing & Auto-Reply)

本 Skill 用于稳健地执行邮件营销任务及自动化回信闭环，支持 AI 智能生成美观 HTML、个性化批量发送、智能回信监控等功能。

## 核心功能

1. **AI 智能生成 HTML**：根据纯文本文案自动生成美观、响应式的 HTML 邮件模板，自动选择合适的设计风格（正式商务/营销推广/温馨问候）。
2. **个性化群发**：自动读取 `邮箱.xlsx`，根据每行数据动态替换 HTML 中的 `【变量名】` 占位符，实现一对一精准营销。
3. **自动化回信监控**：定期扫描收件箱中的未读邮件，智能识别客户提问。
4. **FAQ 知识库匹配**：收到回信后，强制检索 `faq.txt`。仅针对知识库中有明确答案的问题进行回复，不确定的保持静默。
5. **多语种对齐与商务礼仪**：自动识别回信语言（如中、英、日等），以同语种、高标准商务礼貌语气生成回信草案。
6. **防垃圾邮件策略**：内置指纹码干扰与模拟人工发信延迟（3-8秒随机），降低进入垃圾箱的概率。

## 资源依赖

- **名单**：`邮箱.xlsx` (支持读取 `kol name`, `gender` 等用于内容替换)
- **标题**：`邮件标题.txt`
- **文案**：`邮件文案.txt` (纯文本格式，AI会自动转换为HTML)
- **内容**：`邮件内容.html` (依据 邮件文案.txt 内容通过AI生成，会自动替换其中的【变量名】占位符并根据内容自动美化设计)
- **知识库**：`faq.txt` (用于自动回信的标准答案参考)

## 操作指南

### 1. 环境检查（首次使用）

运行环境检查脚本，确保所有依赖和配置都正确：

```bash
cd email-marketing/scripts
python3 check_setup.py
```

如果提示缺少依赖，安装所需包：

```bash
pip install -r email-marketing/requirements.txt
```

**预期输出**：

```
✓ 所有依赖已安装
✓ 环境变量已配置
✓ 测试邮件配置正常
```

### 2. AI 智能生成 HTML（推荐）

根据纯文本文案自动生成精美 HTML 邮件：

**在 OpenClaw 环境中**：直接使用 AI 将文案转换为 HTML

**输入要求**：

- 文案位置：`~/Desktop/邮件文案.txt`
- 文案格式：纯文本，支持【变量名】占位符

**输出文件**：`~/Desktop/邮件内容.html`

**AI 生成特点：**

- 🎨 根据文案内容自动选择设计风格（正式商务/营销推广/温馨问候）
- 📱 自动生成响应式布局，移动端友好
- ✅ 严格保留原文内容和【变量名】占位符
- 🎯 兼容主流邮件客户端（Gmail、Outlook、QQ邮箱等）

### 3. 测试发送

发送一封测试邮件到预设的测试邮箱：

```bash
cd email-marketing/scripts
python3 final_sender.py
```

**测试目的**：

- 验证 HTML 渲染效果
- 检查变量是否正确替换
- 确认移动端和桌面端显示正常

**预期输出**：

```
正在发送测试邮件...
✓ 测试邮件已发送至 test@example.com
请检查邮箱确认效果
```

### 4. 执行全量群发

批量发送到 Excel 名单中的所有收件人：

```bash
cd email-marketing/scripts
python3 final_sender.py run
```

**发送策略**：

- 每封邮件间隔 3-8 秒随机延迟
- 每 10 封长休息一次
- 自动记录发送状态

**预期输出**：

```
开始批量发送...
[1/100] ✓ 发送成功: user1@example.com
[2/100] ✓ 发送成功: user2@example.com
...
✓ 全部发送完成，成功 100 封
```

### 5. 扫描并自动处理回信

运行脚本扫描新邮件，并结合 FAQ 进行智能拟稿：

```bash
cd email-marketing/scripts
python3 auto_reply_manager.py
```

**工作流程**：

1. 扫描收件箱未读邮件
2. 识别客户语言（中/英/日等）
3. 在 FAQ 中搜索匹配答案
4. 生成同语种、商务礼貌的回信草案

**预期输出**：

```
扫描到 3 封未读邮件
[1] user@example.com - "关于产品价格"
  → FAQ 匹配度: 95%
  → 生成回信草案（已保存）
[2] user2@example.com - "合作细节"
  → FAQ 匹配度: 30%（低于阈值，不回复）
```

### 6. 确认并发送回信

人工审核草案后，确认发送回信：

```bash
cd email-marketing/scripts
python3 auto_reply_manager.py send "recipient@email.com" "Subject" "Content"
```

### 7. 查看统计报表

查看发送统计和回信情况：

```bash
cd email-marketing/scripts
python3 check_replies.py
```

**报表内容**：

- 📊 **发送统计**：总发送数、成功数、失败数
- 💬 **回信统计**：真实回信人数、回信率计算
- ⚠️ **退信分析**：退信数量、退信原因分类（账号不存在、垃圾邮件、邮箱已满等）
- 📋 **详细列表**：每个回信和退信的详细信息

**预期输出示例**：

```
--- 邮件营销综合效果报告 ---
统计日期: 2026-03-03
最近一次群发人数: 100
真实回信人数: 5
今日退信数量: 2

[回信详情]:
- 来自: user1@example.com
  标题: Re: 合作邀请
- 来自: user2@example.com
  标题: Re: 产品咨询

[退信分析]:
- 原因: 账号不存在 (Invalid User)
- 原因: 触发垃圾邮件风控 (Spam/Rejected)
```

**关键指标**：

- **回信率** = 真实回信人数 / 总发送数 × 100%
- **退信率** = 退信数量 / 总发送数 × 100%
- **有效触达率** = (总发送数 - 退信数量) / 总发送数 × 100%

**统计文件位置**：

- 发送日志：`assets/email_status.json`
- 回信统计：`assets/reply_stats.json`

## 自动化运行准则 (Mandatory)

- **查重原则**：已经回复过的不需要再次回复，避免骚扰用户。
- **明确性原则**：只有明确在 FAQ 中有答案的问题才回复（匹配度 ≥ 80%），不确定时保持静默。
- **内容一致性**：HTML 渲染仅改变样式，严禁更改文案具体内容（变量替换除外）。
- **稳重降频**：正式发送每封间隔 3-8 秒随机延迟，每 10 封长休息 30-60 秒。
- **安全第一**：发送前必须测试，确认无误后再批量发送。

## 故障排查

### 问题 1: AI 生成 HTML 失败

**症状**：`txt_to_html.py` 报错或生成空文件

**解决方案**：

```bash
# 检查文案文件是否存在
ls ~/Desktop/邮件文案.txt

# 检查文案内容是否为空
cat ~/Desktop/邮件文案.txt

# 查看详细错误日志
python3 txt_to_html.py --verbose
```

### 问题 2: 发送失败

**症状**：`final_sender.py` 报错 "Authentication failed"

**解决方案**：

```bash
# 检查环境变量
echo $EMAIL_SMTP_USER
echo $EMAIL_SMTP_PASS

# 确认 SMTP 配置（如使用 Gmail 需要开启"不够安全的应用访问权限"）
# 或使用应用专用密码

# 查看发送状态日志
cat ../assets/email_status.json
```

### 问题 3: 变量未替换

**症状**：收到的邮件中仍显示【kol name】等占位符

**解决方案**：

- 检查 Excel 文件列名是否与【变量名】完全匹配（不区分大小写）
- 确认 Excel 路径：`~/Desktop/邮箱.xlsx`
- 确认 Excel 中有数据行（非空）

示例 Excel 格式：
| 邮箱 | kol name | gender |
|------|----------|--------|
| user@example.com | 张三 | 先生 |

### 问题 4: 邮件进垃圾箱

**症状**：收件人反馈收不到邮件，或在垃圾箱中

**优化措施**：

- 增加发送延迟时间
- 减少单日发送量（建议 < 500 封）
- 优化邮件内容，避免敏感词汇
- 使用企业邮箱发送（信誉度更高）
- 添加 SPF、DKIM、DMARC 记录

## 最佳实践

### 文案编写技巧

1. **使用变量实现个性化**

   ```
   亲爱的【kol name】【gender】，
   ```

2. **保持段落清晰**
   - 每段 2-3 句话
   - 使用空行分隔段落
   - 重点内容加粗或列表

3. **避免过长句子**
   - 单句不超过 30 字
   - 复杂信息用列表展示

### 群发策略

1. **测试优先**
   - 发送 1 封到自己邮箱
   - 检查移动端和桌面端显示效果
   - 确认变量正确替换

2. **分批发送**
   - 首批 10-20 封测试市场反应
   - 根据回信率调整文案
   - 再执行大批量发送

3. **时间选择**
   - B2B 邮件：工作日 9:00-11:00, 14:00-16:00
   - B2C 邮件：晚上 19:00-21:00
   - 避免周一早上和周五下午

### FAQ 知识库维护

创建 `faq.txt` 文件，格式如下：

```
Q: 你们的产品价格是多少？
A: 我们的产品起步价为 XX 元，具体价格根据您的需求定制。

Q: 如何合作？
A: 合作流程包括：1. 需求沟通 2. 方案制定 3. 合同签订 4. 执行交付

Q: 支持哪些语言？
A: 目前支持中文、英文、日文、韩文等主流语言。
```

**更新频率**：每周根据新问题补充，保持知识库覆盖率 > 80%。

### 数据分析与效果优化

**1. 定期查看统计报表**

建议在每次群发后 24-48 小时查看统计：

```bash
cd email-marketing/scripts
python3 check_replies.py
```

**2. 关键指标基准值**

| 指标       | 优秀  | 良好   | 需优化 |
| ---------- | ----- | ------ | ------ |
| 回信率     | > 5%  | 2-5%   | < 2%   |
| 退信率     | < 2%  | 2-5%   | > 5%   |
| 有效触达率 | > 95% | 90-95% | < 90%  |

**3. 根据数据优化策略**

**高退信率（> 5%）**：

- 清洗邮箱名单，移除无效地址
- 使用邮箱验证工具预先验证
- 检查邮箱格式是否正确

**低回信率（< 2%）**：

- 优化邮件标题，提高打开率
- 调整邮件内容，突出价值主张
- 优化发送时间（参考最佳实践）
- A/B 测试不同文案风格

**垃圾邮件问题**：

- 检查退信原因中"Spam/Rejected"占比
- 如果超过 20%，需要优化邮件内容和发送策略
- 考虑分批次、小批量发送

**4. 回信处理效率**

- 使用自动回信功能处理常见问题（覆盖率目标 80%）
- 对于 FAQ 无法匹配的问题，及时补充到知识库
- 每周审核 `assets/pending_replies.json`，确保无遗漏

**5. 持续改进循环**

```
发送 → 统计分析 → 识别问题 → 优化调整 → 再次发送
```

建议每轮群发后记录：

- 发送时间、数量
- 文案版本
- 回信率、退信率
- 主要退信原因
- 优化措施

通过数据驱动的持续优化，逐步提升营销效果。
