---
name: email-marketing
description: 执行邮件营销任务，包括群发营销邮件、自动化回信监控、FAQ 知识库智能匹配、语种自动对齐。
---

# 邮件营销与智能回信 Skill (Email Marketing & Auto-Reply)

本 Skill 用于稳健地执行邮件营销任务及自动化回信闭环。

## 核心功能

1. **个性化群发**：自动读取 `邮箱.xlsx`，根据每行数据动态替换 HTML 中的 `【变量名】` 占位符，实现一对一精准营销。
2. **自动化回信监控**：定期扫描收件箱中的未读邮件，识别客户提问。
3. **FAQ 知识库匹配**：收到回信后，强制检索 `faq.txt`。仅针对知识库中有明确答案的问题进行回复，不确定的保持静默。
4. **语种对齐与商务礼仪**：自动识别回信语言（如中、英、日等），以同语种、高标准商务礼貌语气生成回信草案。
5. **测试发信与防拦截**：内置干扰指纹码与模拟人工发信延迟，降低进入垃圾箱的概率。

## 资源依赖

*   **名单**：`邮箱.xlsx` (支持读取 `kol name`, `gender` 等用于内容替换)
*   **标题**：`邮件标题.txt`
*   **内容**：`邮件内容.html`
*   **知识库**：`faq.txt` (用于自动回信的标准答案参考)

## 操作指南

### 1. 测试发送
`python3 final_sender.py`

### 2. 执行全量群发
`python3 final_sender.py run`

### 3. 扫描并自动处理回信
运行脚本扫描新邮件，并结合 FAQ 进行智能拟稿：
`python3 auto_reply_manager.py`

### 4. 确认并发送回信
`python3 auto_reply_manager.py send "recipient@email.com" "Subject" "Content"`

### 5. 查看统计报表
`python3 check_replies.py`

## 自动化运行准则 (Mandatory)
*   **查重原则**：已经回复过的不需要再次回复。
*   **明确性原则**：只有明确在 FAQ 中有答案的问题才回复，不确定无需回复。
*   **内容一致性**：HTML 渲染仅改变样式，严禁更改文案具体内容（变量除外）。
*   **稳重降频**：正式发送每封间隔 3-8 秒随机延迟，每 10 封长休息。
