---
name: email-marketing
description: Build and execute email marketing campaigns for a solopreneur business. Use when building an email list, writing email sequences (welcome, nurture, sales), designing broadcast campaigns, improving open and click rates, or setting up email automation. Covers list building, segmentation, email copywriting, sequence design, deliverability, and metrics. Trigger on "email marketing", "email campaign", "email sequence", "email list", "newsletter", "email automation", "improve email open rates", "nurture emails", "welcome email".
---

# Email Marketing

## Overview
Email is the highest-ROI marketing channel for solopreneurs — you own the list, the engagement is direct, and the cost is near zero. But most solopreneur email marketing fails because it's either too salesy (instant unsubscribes) or too timid (no conversions). This playbook builds an email system that nurtures relationships and drives revenue.

---

## Step 1: Build Your Email List

You can't do email marketing without subscribers. List building is priority #1.

**Where to capture emails:**

| Source | How | Conversion Tip |
|---|---|---|
| **Website (lead magnet)** | Offer something valuable (checklist, template, guide) in exchange for email | Make the lead magnet hyper-specific to your ICP's #1 pain |
| **Blog posts** | Inline or end-of-post signup form | Offer a content upgrade related to the post topic |
| **Landing pages** | Dedicated page for a specific offer | Single focus — no navigation, one CTA only |
| **Social media bio** | Link to signup page in bio | Tease the value in your bio copy |
| **Webinars or events** | Registration form captures email | Deliver value on the webinar, follow up with email sequence |
| **Gated content** | Require email to access resource | Only gate high-value content (not every blog post) |

**Lead magnet ideas (choose based on your ICP):**
- Checklist (quick win, actionable)
- Template (saves time, immediately useful)
- Guide or ebook (educational, positions you as expert)
- Swipe file (examples or case studies)
- Calculator or tool (interactive, high perceived value)
- Mini-course (5 days of lessons via email)

**Rule:** The more specific the lead magnet, the higher the conversion AND the more qualified the subscriber. "Free marketing guide" is generic. "Cold email template that gets 20%+ reply rates for SaaS founders" is specific.

---

## Step 2: Choose Your Email Platform

Start simple. Pick a tool that handles the basics well and doesn't overcomplicate.

**Recommended for solopreneurs (ranked by simplicity):**
1. **ConvertKit** (best for creators, simple automation, clean design)
2. **Mailchimp** (free tier, beginner-friendly, good templates)
3. **Beehiiv** (great for newsletters, built-in monetization, fast growth features)
4. **MailerLite** (affordable, solid automation, decent UI)

**Features you need:** Automation (sequences), segmentation (tags or lists), deliverability tracking, and basic analytics (opens, clicks). Avoid tools with complex enterprise features you'll never use.

---

## Step 3: Design Your Core Email Sequences

Automated sequences do the heavy lifting. Set them up once, they run forever.

### Sequence 1: Welcome Sequence (5-7 emails over 7-10 days)
**Goal:** Introduce yourself, deliver value, build trust, set expectations.

```
EMAIL 1 (Day 0): Deliver the lead magnet + set expectations
  - Give them what they signed up for
  - Tell them what to expect (frequency, topics)
  - One small ask: reply and tell me what you're working on

EMAIL 2 (Day 2): Deliver unexpected value
  - Share a tip, insight, or resource they didn't ask for
  - Build goodwill before you ask for anything

EMAIL 3 (Day 4): Tell your story (briefly)
  - Why you built this business
  - What problem you solve and for whom
  - Keep it short — 3-4 paragraphs max

EMAIL 4 (Day 6): Social proof
  - Share a case study or testimonial
  - Or: share a relevant win or result

EMAIL 5 (Day 8): Soft CTA
  - Invite them to take the next step (book a call, try the product, read a key resource)
  - Low-pressure: "If you're interested, here's how we can work together."

(Optional) EMAIL 6-7: Answer top 2 objections or FAQs
```

**Key rule:** Don't sell hard in the welcome sequence. Build trust first, sell later.

### Sequence 2: Nurture Sequence (ongoing, every 7-14 days)
**Goal:** Stay top of mind, provide ongoing value, occasionally pitch.

Structure: 80% value, 20% pitch. For every 5 emails, 4 are purely educational/helpful, 1 is a pitch or CTA.

**Value emails:**
- Tips, how-tos, frameworks
- Case studies or customer stories
- Industry insights or trends
- Curated resources

**Pitch emails:**
- Product launch or feature announcement
- Limited-time offer or discount
- "Here's how we can help you with [specific problem]"

### Sequence 3: Sales Sequence (5-7 emails over 10 days after a specific action)
**Goal:** Convert warm leads (trial signups, demo requests, proposal sent) into customers.

Triggered when someone takes a high-intent action (starts trial, downloads pricing, books a call).

```
EMAIL 1 (Day 0): Confirm the action, set expectations
EMAIL 2 (Day 2): Deliver a quick win (show them how to get value fast)
EMAIL 3 (Day 4): Handle objection #1 (usually price or "will this work for me?")
EMAIL 4 (Day 6): Social proof (testimonial or case study)
EMAIL 5 (Day 8): Handle objection #2 (usually implementation time or complexity)
EMAIL 6 (Day 10): Urgency (trial ending, offer expiring, limited availability)
```

**Key rule:** Each email should accomplish ONE thing. Don't cram multiple messages into one email.

---

## Step 4: Write Email Copy That Converts

Email copy is different from landing page copy — it's more personal, more conversational, and shorter.

**Email structure:**

```
SUBJECT LINE:   Get them to open (curiosity, value, or urgency)
PREVIEW TEXT:   First line of email — hook them further
BODY:           Short paragraphs (2-3 sentences max), one idea per email
CTA:            One clear action (click, reply, book, buy)
SIGNATURE:      Your name, your role, your business
P.S.:           Restate the CTA or add a bonus (P.S. lines get read more than body copy)
```

**Subject line formulas:**

| Type | Example |
|---|---|
| **Curiosity** | "The one metric that predicted our best customers" |
| **Value** | "5-min read: how to automate client reporting" |
| **Personalization** | "Hey [Name], quick question for you" |
| **Urgency** | "Ending tonight: [offer]" |
| **Question** | "Still struggling with [pain point]?" |

**Body copy rules:**
- Start with a hook (first sentence must grab them)
- Write like you're talking to one person (use "you" and "I", not "we" and "our users")
- Keep it scannable (short paragraphs, bold key phrases, use line breaks generously)
- One CTA per email (multiple CTAs split attention and kill conversions)
- End with a P.S. (seriously, it works — restate your offer or add urgency)

---

## Step 5: Segment Your List

Sending the same email to everyone is lazy and ineffective. Segmented emails get 3x higher engagement.

**How to segment:**

| Segment By | Example | Why It Matters |
|---|---|---|
| **Behavior** | Opened last 3 emails vs didn't | Send re-engagement campaigns to cold subscribers |
| **Stage in funnel** | Subscriber vs trial user vs customer | Different messages for different stages |
| **Interest / topic** | Tagged based on lead magnet they downloaded | Send relevant content only |
| **Purchase history** | Bought Product A, hasn't bought Product B | Targeted upsell/cross-sell |
| **Engagement level** | High engagers vs low engagers | VIP content for high engagers, win-back campaigns for low |

**Rule:** Start simple with 2-3 segments. Don't over-complicate. "Engaged subscribers" and "cold subscribers" is a good starting point.

---

## Step 6: Improve Deliverability

If your emails land in spam, nothing else matters. Deliverability is hygiene — get it right or your metrics will tank.

**Deliverability checklist:**

- [ ] Use a custom domain for sending (not @gmail.com). Set up SPF, DKIM, and DMARC records.
- [ ] Warm up your domain (don't send to 10,000 people on day 1 — start small, ramp up gradually).
- [ ] Clean your list regularly. Remove bounces and unengaged subscribers every 3-6 months.
- [ ] Avoid spam trigger words in subject lines ("FREE!!!", "ACT NOW", "LIMITED TIME OFFER!!!").
- [ ] Make it easy to unsubscribe. Hiding the unsubscribe link gets you marked as spam.
- [ ] Monitor your sender reputation (tools: Google Postmaster, Sender Score).

**If your open rates suddenly drop:** Check spam. Send a test email to yourself at Gmail, Outlook, and Yahoo. If it lands in spam, you have a deliverability problem.

---

## Step 7: Measure Performance and Iterate

Track these metrics monthly:

| Metric | What It Means | Healthy Range |
|---|---|---|
| **Open rate** | % of recipients who opened the email | 15-25% (varies by industry) |
| **Click rate** | % of recipients who clicked a link | 2-5% |
| **Unsubscribe rate** | % who unsubscribed | < 0.5% per email |
| **Bounce rate** | % of emails that didn't deliver | < 2% |
| **Conversion rate** | % who took the desired action (signup, purchase, etc.) | Varies by offer |

**What to do with the data:**

- **Low open rates?** Test subject lines (A/B test 2-3 variations). Check deliverability (landing in spam?). Clean your list (remove unengaged subscribers).
- **Low click rates?** Weak CTA or irrelevant content. Test CTA placement and wording. Segment better (send more targeted emails).
- **High unsubscribe rates?** Sending too often, content isn't relevant, or tone is off. Survey unsubscribers to understand why.

**Iteration rule:** Test one variable at a time. Subject line one week, CTA placement the next. Measure, learn, repeat.

---

## Email Marketing Mistakes to Avoid
- Not sending consistently. If you email once a quarter, people forget who you are. Aim for at least monthly.
- Selling in every email. You'll burn out your list. 80% value, 20% pitch is the rule.
- Not segmenting. Sending the same message to everyone means it's relevant to no one.
- Ignoring unengaged subscribers. They drag down your metrics and hurt deliverability. Remove or re-engage them.
- Not having a welcome sequence. The first 7 days after signup are the highest-engagement window. Use it.
- Writing generic subject lines. "Newsletter #47" gets ignored. Make every subject line earn the open.
