---
name: portable-email-manager
version: 0.2.0
description: Lightweight email manager with IMAP/SMTP support, advanced search, folder management, and attachment detection. Works with Zoho, Gmail, Outlook, and any IMAP/SMTP provider.
---

# Email Manager Lite v0.2

A fully self-contained email management skill for OpenClaw. Uses standard IMAP and SMTP protocols with zero external dependencies.

## ✨ What's New in v0.2

### 🔍 Advanced Search & Filters
- Search by sender (`--from`)
- Search by subject keywords (`--subject`)
- Filter by date range (`--since`, `--before`)
- Filter by read/unread status (`--seen`, `--unseen`)
- Search in email body (`--body`, warning: can be slow)

### 📁 Folder Management
- List all IMAP folders with `folders` command
- Move emails between folders with `move` command
- Automatic validation of folder existence

### 📎 Attachment Information
- Automatic detection of attachments
- Display attachment details:
  - Filename
  - MIME type
  - File size (formatted KB/MB)
- Shown in both `read` and `search` results

## 🔧 Installation

```bash
cd skills/portable-email-manager
npm install
```

Dependencies are bundled in `package.json`:
- `nodemailer` - SMTP email sending
- `imap-simple` - IMAP operations
- `mailparser` - Email parsing and attachment detection

## 🔐 Credentials

Set these environment variables:

```bash
export EMAIL_USER="your.email@domain.com"
export EMAIL_PASS="your-app-password"
```

**Recommended:** Use App Passwords for Gmail, Outlook, Zoho instead of main password.

### Provider Setup

**Zoho Mail (default):**
- Already configured for `smtp.zoho.eu` and `imap.zoho.eu`
- Generate App Password: https://accounts.zoho.eu/home#security/apppasswords

**Gmail:**
- Edit `scripts/email.js` and change:
  ```javascript
  host: 'smtp.gmail.com'  // SMTP
  host: 'imap.gmail.com'  // IMAP
  ```
- Enable 2FA and create App Password: https://myaccount.google.com/apppasswords

**Outlook/Hotmail:**
- Edit to use `smtp.office365.com` / `outlook.office365.com`
- Port 587 for SMTP (TLS)

## 📖 Usage

### Send Email

```bash
./scripts/email.js send "recipient@example.com" "Subject" "Email body text"
```

**Example:**
```bash
./scripts/email.js send "boss@company.com" "Weekly Report" "Attached is this week's summary."
```

### Read Recent Emails

```bash
./scripts/email.js read [limit]
```

**Examples:**
```bash
# Read last 5 emails (default)
./scripts/email.js read

# Read last 20 emails
./scripts/email.js read 20
```

**Output includes:**
- UID (unique ID for moving)
- From/To addresses
- Subject and date
- Attachment count and details
- Email body preview (first 500 chars)

### Advanced Search

```bash
./scripts/email.js search [options]
```

**Search Options:**

| Option | Description | Example |
|--------|-------------|---------|
| `--from <email>` | Filter by sender | `--from "boss@company.com"` |
| `--subject <text>` | Filter by subject keywords | `--subject "invoice"` |
| `--since <date>` | Emails after date | `--since "Jan 1, 2026"` |
| `--before <date>` | Emails before date | `--before "Feb 1, 2026"` |
| `--unseen` | Only unread emails | `--unseen` |
| `--seen` | Only read emails | `--seen` |
| `--body <text>` | Search in body (slow!) | `--body "meeting"` |
| `--limit <n>` | Max results | `--limit 10` |

**Examples:**

```bash
# Find unread emails from specific sender
./scripts/email.js search --from "client@example.com" --unseen

# Search by subject
./scripts/email.js search --subject "invoice" --limit 5

# Date range search
./scripts/email.js search --since "Jan 15, 2026" --before "Feb 1, 2026"

# Search in body (use sparingly - can be slow)
./scripts/email.js search --body "quarterly review"

# Combine multiple filters
./scripts/email.js search --from "boss@company.com" --subject "urgent" --unseen --limit 3
```

### List Folders

```bash
./scripts/email.js folders
```

Shows hierarchical tree of all IMAP folders with attributes.

**Example output:**
```
📁 INBOX
📁 Sent
📁 Archive
📁 Drafts
📁 Spam
📁 Trash
```

### Move Email to Folder

```bash
./scripts/email.js move <uid> <folder-name>
```

**Important:**
- Get the `uid` from `read` or `search` output
- Folder name is case-sensitive
- Script validates folder exists before moving

**Examples:**

```bash
# First, find the email and note its UID
./scripts/email.js search --from "newsletter@example.com"
# Output shows: UID: 12345

# Move to Archive folder
./scripts/email.js move 12345 "Archive"

# Move to custom folder
./scripts/email.js move 67890 "Projects/Work"
```

**Error handling:**
- If folder doesn't exist, shows list of available folders
- Validates UID exists before attempting move

### Help

```bash
./scripts/email.js help
```

Shows complete usage guide with all commands and examples.

## 🎯 Use Cases

### Daily Email Triage
```bash
# Check unread emails
./scripts/email.js search --unseen --limit 10

# Move newsletters to folder
./scripts/email.js search --from "newsletter@site.com" --limit 1
./scripts/email.js move <uid> "Newsletters"
```

### Find Specific Email
```bash
# Search by sender and subject
./scripts/email.js search --from "client@example.com" --subject "proposal"

# Search by date
./scripts/email.js search --since "Jan 20, 2026" --subject "meeting notes"
```

### Archive Old Emails
```bash
# Find old read emails
./scripts/email.js search --before "Dec 1, 2025" --seen --limit 50

# Move each to Archive (use UID from output)
./scripts/email.js move <uid> "Archive"
```

### Check for Attachments
```bash
# Read recent emails and see attachment info
./scripts/email.js read 10

# Search output automatically shows:
# - Number of attachments
# - Filename, type, and size for each
```

## 🔒 Security

- Credentials never logged or stored in files
- TLS/SSL encryption for all connections
- App Passwords recommended over account passwords
- No data leaves your machine except IMAP/SMTP connections

## ⚙️ Configuration

Default configuration is optimized for **Zoho Mail EU**.

To use another provider, edit `scripts/email.js`:

```javascript
// SMTP Configuration
const smtpConfig = {
  host: 'smtp.your-provider.com',
  port: 465,  // or 587 for TLS
  secure: true,  // true for SSL (465), false for TLS (587)
  auth: {
    user: EMAIL_USER,
    pass: EMAIL_PASS
  }
};

// IMAP Configuration
const imapConfig = {
  imap: {
    user: EMAIL_USER,
    password: EMAIL_PASS,
    host: 'imap.your-provider.com',
    port: 993,
    tls: true,
    authTimeout: 20000
  }
};
```

## 🚀 Performance Notes

- **Body search** (`--body`) can be slow on large mailboxes - use sparingly
- **Subject/From search** is fast - uses IMAP server-side filtering
- **Date filters** are efficient
- Limit results with `--limit` for faster responses

## 🐛 Troubleshooting

**"Authentication failed"**
- Verify EMAIL_USER and EMAIL_PASS are set correctly
- Use App Password, not account password
- Check provider settings (2FA, less secure apps, etc.)

**"Folder not found"**
- Use `folders` command to see exact folder names
- Folder names are case-sensitive
- Some providers use different names (e.g., "Sent Items" vs "Sent")

**"Connection timeout"**
- Check firewall/network settings
- Verify IMAP/SMTP ports are accessible
- Try increasing `authTimeout` in config

**"No emails found"**
- Check search criteria
- Verify emails exist in INBOX (not other folders)
- Try broader search (remove some filters)

## 📝 Version History

### v0.2.0 (Current)
- ✨ Advanced search with multiple filters
- 📁 Folder management (list, move)
- 📎 Attachment detection and info
- 🎨 Improved output formatting
- 📚 Comprehensive documentation

### v0.1.0
- Basic send/read functionality
- Zoho Mail support
- IMAP/SMTP foundation

## 🤝 Compatibility

Tested with:
- ✅ Zoho Mail (EU & US)
- ✅ Gmail
- ✅ Outlook/Hotmail
- ✅ iCloud Mail
- ✅ Custom IMAP/SMTP servers

## 💡 Tips

1. **Use UIDs for automation:** Save UIDs from search results to move emails programmatically
2. **Combine filters:** Multiple filters create AND conditions for precise searches
3. **Folder organization:** List folders first to plan your organization strategy
4. **Date format:** Use natural language dates like "Jan 1, 2026" or "December 25, 2025"
5. **Attachment filtering:** Look for "Attachments: X" in search output to find emails with files

## 📄 License

ISC - Use freely in your OpenClaw setup.
