# Email Manager Lite v0.2.0

Lightweight, self-contained email manager for OpenClaw with advanced search, folder management, and attachment detection.

## Quick Start

```bash
# 1. Install dependencies
cd skills/portable-email-manager
npm install

# 2. Set credentials
export EMAIL_USER="your@email.com"
export EMAIL_PASS="your-app-password"

# 3. Test it
./scripts/email.js help
./scripts/email.js read 5
```

## New in v0.2

✨ **Advanced Search**
- Filter by sender, subject, date range, read status
- Search in email body
- Combine multiple filters

📁 **Folder Management**
- List all IMAP folders
- Move emails between folders
- Automatic folder validation

📎 **Attachment Info**
- Detect attachments automatically
- Show filename, type, and size
- Displayed in all email listings

## Quick Examples

```bash
# Search unread emails from boss
./scripts/email.js search --from "boss@company.com" --unseen

# List all folders
./scripts/email.js folders

# Move email to Archive (get UID from read/search output)
./scripts/email.js move 12345 "Archive"

# Search by date range
./scripts/email.js search --since "Jan 1, 2026" --limit 10
```

## Documentation

See [SKILL.md](SKILL.md) for complete documentation with all features, examples, and troubleshooting.

## Compatibility

- ✅ Zoho Mail (default config)
- ✅ Gmail
- ✅ Outlook/Hotmail
- ✅ iCloud Mail
- ✅ Custom IMAP/SMTP servers

## Configuration

Default: Zoho Mail EU (`smtp.zoho.eu` / `imap.zoho.eu`)

To change provider, edit `scripts/email.js` and update `smtpConfig` and `imapConfig`.

## Support

- 📚 Full docs: [SKILL.md](SKILL.md)
- 🐛 Issues: Check troubleshooting section in SKILL.md
- 💡 Tips: Run `./scripts/email.js help`
