# Changelog

All notable changes to Email Manager Lite will be documented in this file.

## [0.2.0] - 2026-02-02

### Added
- **Advanced search functionality**
  - Search by sender email (`--from`)
  - Search by subject keywords (`--subject`)
  - Filter by date range (`--since`, `--before`)
  - Filter by read/unread status (`--seen`, `--unseen`)
  - Search in email body (`--body`)
  - Configurable result limit (`--limit`)
  
- **Folder management**
  - `folders` command to list all IMAP folders hierarchically
  - `move` command to move emails between folders
  - Automatic folder existence validation
  - Error handling with helpful folder suggestions

- **Attachment detection and info**
  - Automatic detection of email attachments
  - Display attachment count in listings
  - Detailed attachment info:
    - Filename
    - MIME content type
    - File size (formatted in B/KB/MB)
  - Shown in both `read` and `search` outputs

- **Improved UX**
  - Better formatted output with emojis and separators
  - Help command (`help`) with full usage guide
  - Email body preview (500 chars) to avoid clutter
  - UID display for easy email reference
  - Comprehensive error messages

### Changed
- Version bumped to 0.2.0
- Package name changed to `email-manager-lite`
- Emails no longer auto-marked as read by default
- Improved date sorting (newest first)
- Enhanced error handling with user-friendly messages

### Technical
- Refactored search criteria builder for modularity
- Added command-line argument parser for search options
- Credential check moved to function level (allows `help` without creds)
- Added helper functions for formatting (bytes, attachments)
- Recursive folder existence checker

## [0.1.0] - 2026-02-01

### Initial Release
- Basic email sending via SMTP
- Basic email reading via IMAP
- Support for Zoho Mail (default)
- Support for Gmail, Outlook with config changes
- Environment variable credential management
- Auto-mark emails as read
- Simple CLI interface
  - `send` command
  - `read` command with limit parameter
- Dependencies:
  - nodemailer ^7.0.13
  - imap-simple ^5.1.0
  - mailparser ^3.9.3
