# Triage Guide - Email Management

Use this workflow to classify messages quickly and consistently.

## Classification Buckets

| Bucket | Meaning | Default action |
|--------|---------|----------------|
| Action | Requires user response or decision | Draft reply and log owner/date |
| Waiting | Waiting on someone else | Track follow-up window |
| FYI | Informational with no direct action | Summarize and archive-ready |
| Noise | Promotional or low-value bulk | Batch archive or label |

## Urgency Signals

Mark as urgent only when one or more are true:
- VIP sender with time-sensitive request
- Explicit near-term deadline
- Legal, financial, or customer-impact risk
- Dependency blocking active work

If none apply, do not mark urgent.

## One-Pass Triage Flow

1. Read subject plus first meaningful paragraph.
2. Assign bucket.
3. Extract owner and deadline if present.
4. Decide next action: draft, track, summarize, or archive.
5. Surface top priorities as a short list.

## Output Format

Use this concise structure:
- Priority now (max 3)
- Action queue
- Waiting queue
- FYI summary
- Safe-to-archive list
