---
name: email-importance-content-analysis
description: Judge whether an email is important/urgent using content-based analysis rather than sender name or mailbox labels (which can be spoofed). Use when asked to triage emails, decide priority, detect phishing/social-engineering, or recommend next actions (reply/pay/login/download/click) based on what the message asks the user to do.
---

# Email Importance Content Analysis

Use a **subject/title-first** triage, then perform **technical verification** (headers/links/attachments) only when warranted, and only then validate with **content analysis**. Treat **sender display name, badges, labels, and “From” appearance as untrusted**.

## Workflow (title → technical → content)

### 1) Title/subject + sender triage (cheap first-pass)
Use only: **subject line + sender (display name + email address/domain as shown)**. Do not click anything.

Important: treat sender as **weak signal** (can be spoofed). Use it for triage only.

#### 1A) Fast-drop rules (save time)
If the sender looks **obviously sloppy/spoofed** AND the email is not expected, classify as **Likely scam/ads** and stop (do not spend time on technical verification).
Examples of fast-drop signals:
- Display name claims a bank/government/major brand but the address is from a **free mailbox** (gmail/outlook/163/qq) or unrelated domain
- Lookalike domains / typo-squatting: `paypaI` (I/l), `micros0ft` (0/O), extra `-secure`/`-verify`, weird punctuation
- Suspicious TLDs or brand stuffed into subdomain: `brand.security-check.example.com`
- Very unprofessional local-part patterns (random digits/strings) while claiming official identity
- Pure promo patterns (promo/marketing/news) + obvious sales subject ⇒ treat as ads

#### 1B) Escalate rules (to technical verification)
Escalate for technical verification if **subject OR sender** implies any of:
- **Money/settlement**: 扣款/圈存/付款/退款/發票/帳單/對帳單/繳費
- **Account/security**: 登入/驗證/密碼重設/異常登入/停權/封鎖/安全警告
- **Delivery/download**: 文件下載/取件號碼/包裹/物流失敗
- **Urgency/threat**: 最後通知/24小時內/立即/否則將…
- **Execution**: 附件/請下載/請開啟/啟用巨集

If the subject is clearly marketing/newsletter and no action is implied ⇒ usually **stop here** (Low).

If it triggers the fast-drop rules, you may label it as:
- **Importance**: Low
- **Risk**: Medium–High (spoof attempt)
- **Next step**: Do not click; optionally mark as spam/block

### 2) Technical verification (only for emails that passed title triage)
Prefer evaluating **raw email headers** / “Show original” output (or via gog `gmail get`). Check:
- **Authentication-Results**: SPF / DKIM / DMARC results (`pass|fail|neutral`) and note which domain they authenticate
- **Alignment**: whether DKIM d= domain / SPF MAIL FROM / DMARC aligns with the visible From domain
- **From vs Reply-To** mismatch
- **Links and attachments**:
  - Expand the real target domain (hover/copy link) — don’t trust anchor text
  - Note risky attachments (e.g., .zip, .iso, .js, .vbs, .docm, password-protected archives)

If headers are **not available**, mark Technical verdict = **Unknown** and increase caution.

### 3) Extract the actionable claims (facts only) — only if technical verification passes
From the email body, list:
- What happened / what they claim happened
- What they want the recipient to do (and by when)
- What account/system/money is involved
- What evidence they provide (order id, invoice id, ticket id, last-4 digits, timestamps)

### 4) Classify the required action (drives importance)
Rank higher if it requires any of:
- **Account access / authentication**: login, password reset, 2FA codes, device approval
- **Money movement**: payment, wire, subscription renewal, invoice settlement, refunds
- **Permissions / security posture**: granting access, changing roles, API keys, OAuth consent
- **Software execution**: download/open an attachment, run a file, enable macros
- **Data disclosure**: personal/company info, documents, ID numbers

### 5) Content risk patterns (red flags)
Increase risk if the content shows:
- **Urgency / threat**: “within 24h”, “account will be closed”, “legal action”, “final notice”
- **Secrecy / bypass**: “don’t tell others”, “use personal email”, “avoid normal process”
- **Mismatch / vagueness**: generic greeting, unclear context, missing specifics the real sender would know
- **Odd requests**: asking for OTP, gift cards, crypto, remote access, or direct bank changes
- **Link/attachment pressure**: “click to verify”, “download to view”, “enable macros”

### 6) Choose safe verification (do not trust the email path)
Even if SPF/DKIM/DMARC pass, for sensitive actions recommend **out-of-band verification**:
- Navigate via **known official entry points** (typed URL, app, bookmark), not email links
- If it claims an account issue: check account status by logging in from official site/app
- If it’s a vendor/payment issue: verify using the invoice/order id inside the official portal
- If it’s workplace related: verify via internal chat/phone using known contacts

### 7) Output: priority + next action
Always provide:
- **Title triage verdict**: Escalate / Ignore
- **Technical verdict**: Pass / Fail / Unknown
- **Importance level**: Critical / High / Medium / Low
- **Risk level**: High (likely phishing) / Medium / Low
- **Recommended next step**: what to do *now*, what *not* to do, and how to verify

## Decision Heuristics (quick)
- **Technical FAIL** (SPF/DKIM/DMARC fail or obvious mismatch) + any call-to-action ⇒ **Risk: High** (treat as phishing) regardless of “importance”.
- **Critical**: money/credentials/permissions + urgency OR any request for OTP/macro/remote access.
- **High**: requires action soon, could cause loss of access/service interruption, but can be verified safely via official channels.
- **Medium**: informational but relevant; no immediate sensitive action.
- **Low**: newsletters, marketing, generic updates with no action.

## Response Template (use in replies)
- Title triage (why it escalates / why it can be ignored):
- Technical verification (SPF/DKIM/DMARC + alignment + From/Reply-To + link/attachment notes):
- Summary (1–2 lines):
- What it’s asking you to do:
- Why it may matter (impact if ignored):
- Red flags (if any):
- Safe verification path:
- Recommendation (do / don’t):
