# email-163-com Skill

**版本**: 1.0.0  
**创建日期**: 2026-02-19  
**作者**: OpenClaw  
**描述**: 163 邮箱完整邮件管理工具（Python 实现）

---

## 📧 功能特性

### 核心功能

- ✅ **发送邮件** - 支持纯文本和 HTML 格式
- ✅ **发送附件** - 支持单个或多个附件
- ✅ **读取邮件** - 支持 IMAP ID 认证（163 邮箱要求）
- ✅ **文件夹管理** - 列出、创建、删除文件夹
- ✅ **邮件搜索** - 按发件人、主题、日期等搜索
- ✅ **邮件操作** - 删除、移动、标记已读/未读
- ✅ **附件管理** - 下载、查看附件
- ✅ **配置管理** - 邮箱配置和账户管理

### 技术特点

- ✅ 支持 163 邮箱 IMAP ID 扩展（RFC 2971）
- ✅ TLS/SSL 加密连接
- ✅ 支持中文主题和发件人
- ✅ 支持 HTML 邮件
- ✅ 支持多附件发送
- ✅ 命令行友好界面

---

## 🚀 快速开始

### 1. 安装依赖

```bash
# Python 3.6+ 已包含所需库
# 无需额外安装
```

### 2. 配置邮箱

编辑 `~/.config/email-163-com/config.json`:

```json
{
  "email": "your_email@163.com",
  "password": "your_auth_code",
  "imap_server": "imap.163.com",
  "imap_port": 993,
  "smtp_server": "smtp.163.com",
  "smtp_port": 465
}
```

### 3. 基本使用

```bash
# 查看帮助
email-163-com --help

# 读取邮件
email-163-com read

# 发送邮件
email-163-com send --to friend@example.com --subject "Hello" --body "Hi!"

# 发送附件
email-163-com send --to friend@example.com --subject "File" --attach file.pdf

# 列出文件夹
email-163-com folders
```

---

## 📖 命令参考

### 发送邮件

```bash
# 简单发送
email-163-com send --to <email> --subject <subject> --body <body>

# 发送 HTML 邮件
email-163-com send --to <email> --subject <subject> --html "<h1>Hello</h1>"

# 发送附件
email-163-com send --to <email> --subject <subject> --attach file1.pdf --attach file2.txt

# 从文件读取正文
email-163-com send --to <email> --subject <subject> --file message.txt
```

### 读取邮件

```bash
# 读取最新 5 封
email-163-com read

# 读取指定数量
email-163-com read --count 10

# 读取指定文件夹
email-163-com read --folder "已发送" --count 5

# 读取完整邮件（含正文）
email-163-com read --id 123 --full
```

### 文件夹管理

```bash
# 列出所有文件夹
email-163-com folders

# 创建文件夹
email-163-com folder create "MyFolder"

# 删除文件夹
email-163-com folder delete "MyFolder"
```

### 邮件搜索

```bash
# 按发件人搜索
email-163-com search --from "Cloudflare"

# 按主题搜索
email-163-com search --subject "verify"

# 组合搜索
email-163-com search --from "阿里云" --subject "通知" --count 10
```

### 邮件操作

```bash
# 删除邮件
email-163-com delete --id 123

# 移动邮件
email-163-com move --id 123 --to "已删除"

# 标记已读
email-163-com flag --id 123 --set seen

# 标记未读
email-163-com flag --id 123 --unset seen
```

### 附件管理

```bash
# 列出邮件附件
email-163-com attachments --id 123

# 下载附件
email-163-com attachments --id 123 --download --output ~/Downloads/
```

---

## 🔧 配置文件

### 位置

`~/.config/email-163-com/config.json`

### 格式

```json
{
  "email": "newolf20000@163.com",
  "password": "KZtfcUWCKGNFf9M9",
  "imap_server": "imap.163.com",
  "imap_port": 993,
  "smtp_server": "smtp.163.com",
  "smtp_port": 465,
  "imap_id": {
    "name": "OpenClaw",
    "version": "1.0.0",
    "vendor": "email-163-com",
    "support_email": "newolf20000@163.com"
  },
  "defaults": {
    "folder": "INBOX",
    "count": 5,
    "output_dir": "~/Downloads"
  }
}
```

---

## 💡 使用示例

### 示例 1: 发送日常工作邮件

```bash
email-163-com send \
  --to colleague@example.com \
  --subject "项目进度更新" \
  --file report.txt \
  --attach progress.pdf
```

### 示例 2: 查看未读邮件

```bash
email-163-com read --count 10 --unread
```

### 示例 3: 搜索特定邮件

```bash
email-163-com search \
  --from "Cloudflare" \
  --subject "verify" \
  --count 5
```

### 示例 4: 清理垃圾邮件

```bash
email-163-com search --folder "垃圾邮件" --count 100
email-163-com delete --folder "垃圾邮件" --all
```

---

## 📋 输出格式

### 读取邮件

```
📬 INBOX: 16 messages total

📧 From: 阿里云
   Subject: 域名信息修改成功通知
   Date: Wed, 18 Feb 2026 22:00:53
   ID: 16
   Flags: \Seen
--------------------------------------------------

📧 From: "Cloudflare" <noreply@notify.cloudflare.com>
   Subject: [Action required] Verify your email address
   Date: Wed, 18 Feb 2026 14:17:02
   ID: 15
   Flags: 
--------------------------------------------------
```

### 发送邮件

```
✅ Message sent successfully!
   To: friend@example.com
   Subject: Hello
   Attachments: file.pdf (1.2 MB)
```

---

## 🔐 安全说明

### 授权码

- 不要使用邮箱登录密码
- 使用 163 邮箱的"客户端授权码"
- 获取方式：登录网页版 → 设置 → POP3/SMTP/IMAP

### 配置文件权限

```bash
# 设置配置文件权限（仅自己可读）
chmod 600 ~/.config/email-163-com/config.json
```

### 环境变量（可选）

也可以使用环境变量代替配置文件：

```bash
export EMAIL_163_USER="newolf20000@163.com"
export EMAIL_163_PASS="KZtfcUWCKGNFf9M9"
```

---

## 🐛 故障排查

### 问题 1: IMAP 连接失败

```
Error: SELECT Unsafe Login
```

**解决**: 确保配置了 IMAP ID 信息（默认已配置）

### 问题 2: 认证失败

```
Error: LOGIN failed
```

**解决**: 检查授权码是否正确（不是登录密码）

### 问题 3: 附件发送失败

```
Error: Cannot attach file
```

**解决**: 检查文件路径是否正确，文件是否可读

---

## 📚 技术参考

- **RFC 2971**: IMAP4 ID extension
- **RFC 3501**: IMAP4rev1
- **RFC 5322**: Internet Message Format
- **163 邮箱帮助**: https://help.mail.163.com/

---

## 🔄 更新日志

### v1.0.0 (2026-02-19)

- ✅ 初始版本
- ✅ 支持发送邮件（文本/HTML）
- ✅ 支持发送附件
- ✅ 支持读取邮件（IMAP ID）
- ✅ 支持文件夹管理
- ✅ 支持邮件搜索
- ✅ 支持邮件操作（删除/移动/标记）
- ✅ 支持附件下载

---

## 📞 支持

- **文档**: `~/.openclaw/workspace/skills/email-163-com/README.md`
- **配置**: `~/.config/email-163-com/config.json`
- **脚本**: `~/.openclaw/workspace/skills/email-163-com/email.py`

---

**首次发布**: 2026-02-19  
**维护者**: OpenClaw Team
