# Impulse Waves

## Rules (must not be violated)

1. **Wave 2 never retraces more than 100% of wave 1.**
2. **Wave 3 always travels beyond the end of wave 1.**
3. **Wave 3 is never the shortest among waves 1, 3 and 5.**
4. **Wave 4 never enters the price territory of wave 1** (i.e., no overlap in non‑leveraged cash markets).

## Guidelines (typical but not mandatory)

- Wave 3 is often the longest and is the most frequently extended wave.
- Waves 1 and 5 tend toward equality or a .618 relationship when wave 3 is extended.
- Parallel trend channels can be drawn to contain the impulse.

## Extensions

An extension is an elongated impulse with exaggerated subdivisions. Only one of the three actionary subwaves (1, 3 or 5) normally extends.

- If wave 3 extends, waves 1 and 5 are often simple and roughly equal.
- An extension may produce a total of 9 waves of similar size (e.g., when the extended wave subdivides clearly).
- Extensions warn of dramatic reversals after completion.

## Truncated Fifth (Failure)

A truncated fifth occurs when wave 5 fails to move beyond the end of wave 3. It often follows a powerful third wave and signals weakness.

## Diagonal Triangles

### Ending Diagonal

- Occurs in wave 5 or wave C (rarely).
- Wedge‑shaped within two converging lines.
- Subdivides **3‑3‑3‑3‑3** (all subwaves are zigzags or variations).
- Wave 4 almost always **overlaps** wave 1.
- Often ends with a brief “throw‑over” of the trendline.
- Bullish ending diagonals are followed by sharp declines; bearish ones by sharp advances.

### Leading Diagonal

- Occurs in wave 1 of an impulse or wave A of a zigzag.
- Also wedge‑shaped with converging lines and overlap of waves 1 and 4.
- Subdivides **5‑3‑5‑3‑5** (the subwaves in the direction of the larger trend are fives, the others are threes).
- Indicates continuation rather than termination.