# Guidelines (Probabilistic Observations)

## Alternation

- **Within impulses**: If wave 2 is a sharp correction (zigzag), wave 4 will likely be sideways (flat, triangle, combination) – and vice versa.
- **Within corrections**: If wave A is a flat, wave B will likely be a zigzag (or more complex), and vice versa. Complexity may also alternate.

## Channeling

- Draw a channel by connecting the ends of waves 1 and 3, then a parallel line touching wave 2. This often marks the boundary for wave 4.
- After wave 4 completes, adjust the channel using waves 2 and 4 to estimate wave 5.
- Use semilogarithmic scale for long‑term channels; arithmetic is acceptable for short‑term moves.

## Volume

- Volume typically peaks in wave 3 and diminishes in wave 5 (unless wave 5 extends).
- In ending diagonals, volume decreases during the pattern but spikes at the throw‑over.
- At lower degrees, volume in a fifth wave below Primary degree is usually less than in wave 3. If equal or greater, a fifth‑wave extension may be forming.

## Wave Personality (Mass Psychology)

- **Wave 1**: Often a basing process; many still believe the prior trend is intact; short‑selling common.
- **Wave 2**: Sharp retracement, fear returns; often tests the prior low; volume dries up.
- **Wave 3**: Strongest and broadest; clear trend; highest volume; most extended.
- **Wave 4**: Sideways; builds base for final leg; non‑confirmations may appear.
- **Wave 5**: Less dynamic than wave 3; optimism high but breadth narrow; may diverge with momentum.
- **Wave A**: Believed to be a pullback; technically damaging cracks appear.
- **Wave B**: “Phony” rally; sucker play; often narrow participation; unconfirmed by other averages.
- **Wave C**: Destructive; persistent and broad; resembles wave 3 in the opposite direction.
- **Wave D** (in triangles): Phony advance; often accompanied by increased volume.
- **Wave E** (in triangles): False breakdown; strongly bearish sentiment, but signals reversal.

## Throw‑over / Throw‑under

A throw‑over occurs when wave 5 briefly pierces the upper trendline on heavy volume, immediately reversing. A throw‑under (false breakdown) may precede a throw‑over.

## Right Look

A wave count must conform to the appropriate illustration; forcing a five‑wave count where a three‑wave pattern is obvious leads to errors. The overall shape and internal count must be consistent.