# Fibonacci Relationships

The Fibonacci sequence (1,1,2,3,5,8,13,21,34,55,89,144,…) and the Golden Ratio φ = 0.618 (and its inverse 1.618) appear throughout market patterns.

## Retracements

- **Sharp corrections** (zigzags, double zigzags) often retrace **61.8%** or **50%** of the preceding wave.
- **Sideways corrections** (flats, triangles, combinations) often retrace **38.2%** of the preceding impulse wave (especially as wave 4).
- Wave 2 of an impulse often retraces 61.8% of wave 1; wave 4 often retraces 38.2% of wave 3.

## Multiples Within Impulses

- When wave 3 is extended, waves 1 and 5 tend toward **equality** or a **0.618** relationship.
- Wave 5 may be related to the distance from wave 1 through wave 3 by **0.618** or **1.618** (especially when wave 5 is extended).
- Wave 4 often divides the total impulse into the Golden Section: the portion after wave 4 is 0.382 (if wave 5 not extended) or 0.618 (if wave 5 extended) of the whole.

## Multiples Within Corrections

- **Zigzag**: Wave C often equals wave A, or is 1.618 times wave A.
- **Expanded flat**: Wave C is often 1.618 times wave A. Wave B may be 1.236 or 1.382 times wave A.
- **Triangle**: Alternate waves (e.g., c = 0.618 a, d = 0.618 b, e = 0.618 c) are common. In expanding triangles, the multiple is 1.618.
- **Combinations**: Net travel of one simple pattern may equal another or be 0.618 times it.

## Time Sequences

Fibonacci time periods often appear between important turning points. Examples from the PDF:

- 1921 to 1929 = 8 years
- 1929 to 1942 = 13 years
- 1932 to 1937 = 5 years (55 months)
- 1962 to 1974 = 12 years (not Fibonacci, but many others fit)

Use time relationships as confirmation, not as primary signals.

## Practical Application

When multiple Fibonacci relationships converge at the same price level, the likelihood of a reversal increases. Always base measurements on orthodox (pattern) terminations, not nominal extremes.