# Corrective Patterns

Corrections are more varied than impulses. They always unfold in three waves or a combination of three‑wave structures.

## Zigzag (5‑3‑5)

- Single zigzag: A‑B‑C, where A and C are impulses (5‑wave), B is a corrective (3‑wave).
- In a bull market, the top of wave B is noticeably lower than the start of wave A.
- Double zigzag: W‑X‑Y, where W and Y are zigzags, X is any corrective (often another zigzag).
- Triple zigzag: W‑X‑Y‑X‑Z.

## Flat (3‑3‑5)

In a flat, wave A lacks force and subdivides into 3 waves, B retraces most of A (often reaching or exceeding A’s start), and C subdivides into 5 waves.

- **Regular flat**: B ends about at the level of A’s start; C ends slightly beyond A.
- **Expanded flat (irregular)**: B exceeds A’s start; C ends substantially beyond A.
- **Running flat**: B well beyond A’s start, but C fails to reach the end of A (rare; occurs in very strong markets).

## Triangle (3‑3‑3‑3‑3)

Five overlapping waves labelled a‑b‑c‑d‑e, each subdividing into 3 waves. Triangles are usually sideways and indicate a balance of forces.

- **Contracting triangles**: symmetrical, ascending, descending – boundary lines converge.
- **Expanding (reverse symmetrical) triangle**: boundary lines diverge.
- **Running triangle**: wave b exceeds the start of wave a (a type of contracting triangle).
- Triangles almost always precede the final actionary wave of the larger pattern (wave 4, wave B, or final X).
- After a triangle, a “thrust” often follows, approximately equal to the widest part of the triangle.

## Combinations (Double Threes and Triple Threes)

Two or three simple corrective patterns combined, labelled W‑X‑Y (double) or W‑X‑Y‑X‑Z (triple). X waves are corrective (usually zigzags). Rules:

- Only one zigzag per combination.
- Only one triangle per combination, and it must appear as the final pattern.
- Examples: zigzag‑flat, flat‑triangle, flat‑flat‑flat, etc.

## Depth of Corrections

- Corrections (especially fourth waves) tend to end within the price territory of the previous fourth wave of lesser degree.
- Zigzags (especially second waves) may retrace deeply into the prior second wave area.
- Following a fifth‑wave extension, the correction often finds support at the low of wave two of the extension.