# Basic Principles of the Elliott Wave Principle

## The 5‑3 Pattern

- **Impulsive waves** (motive mode) move in the same direction as the trend of one larger degree. They subdivide into **five waves**.
- **Corrective waves** move against the trend of one larger degree. They subdivide into **three waves** (or a variation thereof).

A complete cycle consists of an impulsive wave (5 waves) followed by a corrective wave (3 waves). These cycles link together to form larger versions of the same pattern.

## Wave Degrees

Waves are categorized by relative size. Elliott named nine degrees, from largest to smallest:

- Grand Supercycle
- Supercycle
- Cycle
- Primary
- Intermediate
- Minor
- Minute
- Minuette
- Subminuette

Labels indicate the degree and function:

| Degree              | 5s With the Trend | 3s Against the Trend |
|---------------------|-------------------|----------------------|
| Grand Supercycle    | [I] [II] [III] [IV] [V] | [A] [B] [C] |
| Supercycle          | (I) (II) (III) (IV) (V) | (A) (B) (C) |
| Cycle               | I II III IV V          | A B C       |
| Primary             | [1] [2] [3] [4] [5]    | [A] [B] [C] |
| Intermediate        | (1) (2) (3) (4) (5)    | (a) (b) (c) |
| Minor               | 1 2 3 4 5              | A B C       |
| Minute              | [i] [ii] [iii] [iv] [v]| [a] [b] [c] |
| Minuette            | (i) (ii) (iii) (iv) (v)| (a) (b) (c) |
| Subminuette         | i ii iii iv v          | a b c       |

*Note: Brackets [ ] are used for Primary and Grand Supercycle degrees; parentheses ( ) for Intermediate and Supercycle degrees.*

## Motive vs. Corrective Mode

- **Motive mode**: Waves that propel the market in the direction of the larger trend. They are always five‑wave structures (impulses or diagonal triangles).
- **Corrective mode**: Waves that interrupt the larger trend. They are three‑wave structures or combinations thereof (zigzags, flats, triangles, double/threes).

## Relative Direction

A wave’s function is determined by its direction relative to the next larger trend:

- **Actionary wave** – trends in the same direction as the wave of one larger degree. Labeled with odd numbers (1,3,5) and letters (A,C,E,W,Y,Z).
- **Reactionary wave** – trends opposite to the wave of one larger degree. Labeled with even numbers (2,4) and letters (B,D,X).

All reactionary waves develop in corrective mode. Most actionary waves develop in motive mode, but some (e.g., waves in diagonal triangles, A waves in flats, etc.) develop in corrective mode – these are called **actionary‑corrective** waves.