---
name: elliott-wave-principle
description: Provides expert guidance on applying the Elliott Wave Principle to financial market analysis. Use when the user asks about wave counting, identifying impulse waves, corrective patterns (zigzags, flats, triangles), Fibonacci retracements, wave guidelines (alternation, channeling, volume), wave personality, or any Elliott Wave concepts. This skill includes detailed reference files covering rules, patterns, and examples.
---

# Elliott Wave Principle Skill

This skill helps you apply the Elliott Wave Principle to analyze financial market price data. It contains reference files with detailed rules, pattern descriptions, and guidelines.

## Quick Start

- If the user provides a chart or price data and asks for wave analysis, first determine the trend direction and look for the basic 5‑wave pattern (impulse) followed by a 3‑wave correction.
- Use the reference files to verify rules and identify specific patterns.

## Reference Files

The following files are available in the `references/` directory. Load them as needed based on the user’s question.

- **[basic-principles.md](references/basic-principles.md)** – Fundamental concepts: the 5‑3 wave structure, motive vs. corrective mode, wave degrees, labeling conventions.
- **[impulse-waves.md](references/impulse-waves.md)** – Rules for impulse waves (no overlap, wave 3 not shortest, etc.), extensions, truncations, diagonal triangles (ending and leading).
- **[corrective-patterns.md](references/corrective-patterns.md)** – Detailed descriptions of zigzags (single, double, triple), flats (regular, expanded, running), triangles (contracting, expanding), and combinations (double/triple threes).
- **[guidelines.md](references/guidelines.md)** – Key guidelines: alternation, channeling, volume characteristics, wave personality, and practical application tips.
- **[fibonacci-relationships.md](references/fibonacci-relationships.md)** – Fibonacci ratios in wave relationships (retracements, multiples, time sequences), how to apply them for price targets.
- **[glossary.md](references/glossary.md)** – Definitions of Elliott Wave terms (e.g., throw‑over, truncation, apex, etc.).

## How to Use This Skill

1. **Understand the user’s request**: Determine if they need wave counting, pattern identification, or explanation of concepts.
2. **Load relevant reference(s)**: For example, if the user asks about a specific corrective pattern, load `corrective-patterns.md`. If they ask about wave counting rules, load `impulse-waves.md` and `basic-principles.md`.
3. **Apply the rules**: Use the information to analyze the provided price data. Remember that the Wave Principle is probabilistic; multiple interpretations may be valid.
4. **Provide reasoning**: Explain your wave count, referencing the rules and guidelines used.

## Important Notes

- Always prioritize the **rules** (e.g., wave 3 cannot be shortest, wave 4 cannot overlap wave 1 in an impulse) over guidelines.
- When in doubt, consult the glossary for term definitions.
- The examples in the reference files illustrate typical patterns; actual market patterns may vary.
- For a comprehensive understanding, you may load multiple references. The files are designed to be modular; load only what you need to keep context efficient.