# Values Elicitation

Based on Shalom Schwartz's Theory of Basic Human Values and clinical values work.

## The Schwartz Value Theory

Schwartz identified 10 universal values found across cultures. These values form a circular structure where adjacent values are compatible and opposite values conflict.

## The 10 Universal Values

### 1. Self-Direction
**Core:** Independence of thought and action—choosing, creating, exploring.

*Defining goals:* Creativity, freedom, independence, curiosity, choosing own goals

*People who prioritize this value:*
- Resist being told what to do
- Value autonomy over security
- Prefer novel experiences
- Chafe at restrictions

*Elicitation questions:*
> "How important is it for you to make your own choices, even if they're unconventional?"
> "What does freedom mean to you?"

### 2. Stimulation
**Core:** Excitement, novelty, and challenge in life.

*Defining goals:* Daring, varied life, exciting life

*People who prioritize this value:*
- Seek adventure and risk
- Bore easily with routine
- Need variety to feel alive
- Embrace change

*Elicitation questions:*
> "What gives you a sense of aliveness?"
> "How do you feel about routine and predictability?"

### 3. Hedonism
**Core:** Pleasure and sensuous gratification.

*Defining goals:* Pleasure, enjoying life, self-indulgence

*People who prioritize this value:*
- Prioritize enjoyment
- Seek sensory pleasures
- May resist delayed gratification
- Value the present moment

*Elicitation questions:*
> "What role does pleasure play in how you make decisions?"
> "How do you balance enjoyment now vs. sacrifice for later?"

### 4. Achievement
**Core:** Personal success through demonstrating competence.

*Defining goals:* Success, capability, ambition, influence

*People who prioritize this value:*
- Are driven by accomplishment
- Measure self against standards
- Need to feel competent
- Seek recognition for success

*Elicitation questions:*
> "What does success mean to you?"
> "How important is it to be seen as capable?"

### 5. Power
**Core:** Social status and prestige, control over people and resources.

*Defining goals:* Authority, wealth, social power, preserving public image

*People who prioritize this value:*
- Seek influence and leadership
- Care about status signals
- Value control over circumstances
- May be competitive

*Elicitation questions:*
> "How important is it for you to have influence?"
> "What does it mean to you to be respected?"

### 6. Security
**Core:** Safety, harmony, and stability of society, relationships, and self.

*Defining goals:* Family security, national security, social order, reciprocation of favors, health, sense of belonging

*People who prioritize this value:*
- Need predictability
- Value stability over excitement
- Protect what they have
- Worry about threats

*Elicitation questions:*
> "How important is stability in your life?"
> "What does feeling safe mean to you?"

### 7. Conformity
**Core:** Restraint of actions that might harm others or violate social expectations.

*Defining goals:* Obedience, self-discipline, politeness, honoring parents and elders

*People who prioritize this value:*
- Respect rules and norms
- Avoid causing offense
- Value propriety
- Regulate impulses

*Elicitation questions:*
> "How do you feel about breaking rules or norms?"
> "How important is it to meet others' expectations?"

### 8. Tradition
**Core:** Respect and commitment to cultural or religious customs and ideas.

*Defining goals:* Respect for tradition, humility, devotion, acceptance of life

*People who prioritize this value:*
- Honor heritage and customs
- Value continuity with past
- Respect established institutions
- May resist change

*Elicitation questions:*
> "What traditions or customs are important to you?"
> "How connected do you feel to your cultural or family heritage?"

### 9. Benevolence
**Core:** Preserving and enhancing welfare of close others.

*Defining goals:* Helpfulness, honesty, forgiveness, loyalty, responsibility, friendship, mature love

*People who prioritize this value:*
- Prioritize close relationships
- Care for family and friends
- Are generous with time and resources
- Value loyalty

*Elicitation questions:*
> "What does it mean to be a good friend/family member?"
> "How important is it for you to help people you're close to?"

### 10. Universalism
**Core:** Understanding, appreciation, tolerance, and protection for welfare of all people and nature.

*Defining goals:* Broadmindedness, social justice, equality, world peace, unity with nature, wisdom, environmental protection

*People who prioritize this value:*
- Think beyond in-group
- Care about global issues
- Value diversity and tolerance
- Concerned about environment

*Elicitation questions:*
> "How much do you think about people or issues beyond your immediate circle?"
> "What causes or principles do you care about?"

## The Circular Structure

Values exist in a circular relationship where:
- **Adjacent values** are compatible (Achievement and Power; Benevolence and Universalism)
- **Opposite values** often conflict (Self-Direction vs. Conformity; Stimulation vs. Security)

This creates four higher-order dimensions:

| Dimension | Values | Core Concern |
|-----------|--------|--------------|
| **Openness to Change** | Self-Direction, Stimulation, Hedonism | Independent thought and action |
| **Conservation** | Security, Conformity, Tradition | Order, self-restriction, resistance to change |
| **Self-Enhancement** | Power, Achievement, (Hedonism) | Pursuing own interests |
| **Self-Transcendence** | Universalism, Benevolence | Concern for others' welfare |

## Elicitation Techniques

### The Role Model Technique
> "Who do you admire—someone you look up to? What specifically is it about them?"

The qualities they admire reveal their values.

### The Opposite Day Technique
> "What kind of person could you never be? What would feel like a betrayal of who you are?"

What they reject reveals what they protect.

### Decision Archaeology
> "Think of a hard decision you made—one where you had to give something up. What ultimately tipped the scales?"

Trade-offs reveal value hierarchies.

### Anger as Values Signal
> "What makes you genuinely angry—not annoyed, but morally outraged?"

Anger protects violated values.

### The Deathbed Test
> "Imagine looking back on your life at the very end. What would matter most? What would you regret not doing?"

Ultimate concerns surface here.

### The Lottery Technique
> "If you won enough money that you never had to work again, what would you do? How would you spend your time?"

Remove constraints to reveal intrinsic motivation.

### The Peak Experience
> "When do you feel most alive, most yourself?"

Peak states often align with core values.

### The Anti-Values
> "What do you find most offensive in other people?"

Strong reactions reveal value priorities (the opposite of what offends them).

## Distinguishing Values from Goals

| Values | Goals |
|--------|-------|
| Abstract, enduring | Concrete, time-bound |
| Guide behavior across contexts | Specific to situations |
| Few in number | Many possible |
| "Why" | "What" |

*Example:*
- Goal: "I want to get promoted"
- Value: Could be Achievement (success), Power (status), Security (income), or Self-Direction (autonomy)

Probe to find the value:
> "What would the promotion give you that you don't have now?"

## Values vs. Shoulds

People often confuse what they value with what they think they should value.

*Signs of "should" not value:*
- Intellectualized but no affect
- Inconsistent with behavior
- Comes from external source
- Feels obligatory, not energizing

*Probing for authenticity:*
> "Does that come from you, or from what you think you're supposed to want?"
> "When you imagine living that way, do you feel excited or obligated?"

## Value Conflicts

Internal conflicts often stem from competing values:

- Security vs. Stimulation (stability vs. adventure)
- Achievement vs. Benevolence (success vs. relationship)
- Conformity vs. Self-Direction (fitting in vs. being authentic)

*Eliciting conflict:*
> "It sounds like two things you care about are pulling in different directions."
> "How do you navigate when these values compete?"

## Cultural Considerations

Values exist in every culture, but their expression varies:

- **Individualist cultures** may emphasize Self-Direction, Achievement
- **Collectivist cultures** may emphasize Conformity, Tradition, Benevolence

Don't assume universal expression:
> "What does success look like in your family? Your community?"
> "Are there values you hold that don't fit the culture you grew up in?"

## Key Sources

- Schwartz, S.H. (1992). Universals in the content and structure of values. *Advances in Experimental Social Psychology*
- Schwartz, S.H. (2012). An overview of the Schwartz theory of basic values. *Online Readings in Psychology and Culture*
- Hayes, S.C. et al. (2012). Acceptance and Commitment Therapy (for values work methods)
- Miller, W.R. & C'de Baca, J. (2001). *Quantum Change* (for value transformation)
