# Self-Defining Memories

Based on Jefferson Singer's research on autobiographical memory and personality.

## What Are Self-Defining Memories?

Self-defining memories (SDMs) are a special class of autobiographical memories that form the building blocks of personal identity. They're the memories that come to mind when you think about who you are.

## Five Criteria

A memory is self-defining when it meets these criteria:

### 1. Vivid
Rich in sensory detail. You can see it, hear it, feel it. The scene is clear, not vague or generic.

*Elicitation check:*
> "Can you describe what you saw? What sounds do you remember? What did it feel like physically?"

### 2. Emotionally Intense
Strong affect—positive or negative. The memory still evokes feeling when recalled.

*Elicitation check:*
> "When you think about it now, what do you feel? Is the emotion still there?"

### 3. Frequently Rehearsed
The memory comes to mind often, unbidden. It's been told to others, thought about repeatedly.

*Elicitation check:*
> "Is this something you think about often? Have you told this story before?"

### 4. Linked to Similar Memories
The memory is part of a network—connected to other memories with similar themes.

*Elicitation check:*
> "Does this remind you of other moments in your life? Are there other memories that feel related?"

### 5. Connected to Enduring Concerns
The memory relates to ongoing goals, conflicts, or unresolved issues in the person's life.

*Elicitation check:*
> "Why do you think this one stays with you? What does it connect to in your life now?"

## The Self-Defining Memory Task

Singer's original task asks participants to recall 10 memories meeting these criteria. For conversational elicitation, adapt:

### Standard Prompt
> "Think of memories that are important to your sense of who you are. These might be memories that come to mind when you meet someone new and want them to understand you. They're usually vivid—you can picture them clearly—and they still feel emotionally significant. What memories come to mind?"

### Conversational Frames

**The introduction frame:**
> "When you're getting to know someone and you want them to really understand where you come from, what stories or moments do you find yourself sharing?"

**The keeps-coming-back frame:**
> "Some memories just stay with us—they pop up at unexpected moments, or we find ourselves thinking about them again and again. What memories are like that for you?"

**The if-you-had-to-explain frame:**
> "If you had to explain to someone how you became who you are, what moments or experiences would you point to?"

**The crystallizing frame:**
> "Was there ever a moment where something clicked—where you suddenly understood something about yourself or the world?"

## Memory Specificity

SDMs should be specific—a particular time and place, not a general summary.

| Not specific | Specific |
|--------------|----------|
| "I was always picked last in gym class" | "I remember standing against the wall in 7th grade, watching everyone get picked, knowing I'd be last again" |
| "My parents fought a lot" | "I remember sitting on the stairs at night, listening to them argue about money, feeling like it was my fault" |
| "College was a great time" | "I remember the night we stayed up until dawn talking about what we wanted our lives to be" |

If someone gives a general memory, gently probe:
> "Is there a specific moment that captures that? A particular day or event you can picture?"

## Memory Themes and Personality

### Achievement/Mastery Memories
Stories of success, overcoming obstacles, proving capability.

*Personality link:* High need for achievement, agency motivation

*Example:* "The day I finally solved that problem after weeks of trying—I remember the exact moment it clicked."

### Relationship/Connection Memories
Stories of intimacy, belonging, love, or loss of connection.

*Personality link:* High need for affiliation, communion motivation

*Example:* "When my grandmother held my hand and told me she was proud of me—I can still feel her grip."

### Power/Status Memories
Stories of influence, recognition, or being overlooked.

*Personality link:* High need for power, sensitivity to hierarchy

*Example:* "Getting promoted over people who had been there longer—I knew I had earned it."

### Safety/Threat Memories
Stories of danger, vulnerability, or protection.

*Personality link:* Anxiety sensitivity, security needs

*Example:* "The night someone broke into our house—I still check the locks three times."

### Freedom/Autonomy Memories
Stories of independence, breaking away, self-determination.

*Personality link:* High need for autonomy, resistance to control

*Example:* "The day I drove away from home for the first time—I felt like I could finally breathe."

## Affect Patterns

### Positive SDMs
Dominated by joy, pride, love, peace, excitement.

*Interpretation:* Generally associated with well-being, but probe for complexity.

*Follow-up:*
> "What made that moment so positive? Is there any shadow side to it?"

### Negative SDMs
Dominated by fear, shame, anger, sadness, guilt.

*Interpretation:* May indicate unresolved issues, but also processing and meaning-making.

*Follow-up:*
> "How do you feel about that memory now? Has your relationship to it changed?"

### Mixed/Ambivalent SDMs
Both positive and negative affect present.

*Interpretation:* Often the most psychologically meaningful—integration of complexity.

*Follow-up:*
> "It sounds like that memory has layers. Can you say more about the mixed feelings?"

## Narrative Processing

Singer distinguishes between memories that have been processed for meaning and those that remain unintegrated.

### Integrative Memories
The person has made sense of the experience:
- "I understand now why that happened"
- "That's when I learned that..."
- "Looking back, I can see that..."

*Psychological correlate:* Maturity, well-being, identity coherence

### Non-Integrative Memories
The experience remains confusing or unmetabolized:
- "I still don't understand why..."
- "It just doesn't make sense"
- "I keep thinking about it but..."

*Psychological correlate:* May indicate ongoing processing, trauma, or identity confusion

### Eliciting Integration
> "What sense have you made of that experience? Has your understanding of it changed over time?"

> "If that memory could talk, what would it say about who you are or what matters to you?"

## Memory Chains

SDMs rarely stand alone. They're part of thematic chains—networks of related memories.

### Eliciting Chains
After discussing one SDM:
> "Are there other memories that feel connected to this one? Other times you felt something similar?"

### Chain Analysis
Look for:
- Repeating patterns (always the outsider, always the caretaker)
- Developmental threads (how a theme evolved over time)
- Attempts at resolution (different strategies for same core issue)

## Conversational Guidelines

### Creating Safety
SDMs are intimate. Create conditions for disclosure:
- Normalize sharing: "Many people find these memories define them"
- Give permission to be selective: "Share whatever feels comfortable"
- Validate the significance: "It's clear this mattered to you"

### Pacing
- Don't rush from memory to memory
- Spend time with each memory before moving on
- Allow silence—important memories take time to surface

### Following, Not Leading
- Let them choose which memories to share
- Their selection is data—what they omit is as meaningful as what they include
- Resist the urge to redirect to "more important" memories

### Emotional Attunement
- Notice affect as they recall
- Reflect the feeling: "I can see that still touches you"
- Don't push past their comfort zone

## Key Sources

- Singer, J.A. & Salovey, P. (1993). *The Remembered Self*
- Singer, J.A. (2005). *Memories that Matter*
- Singer, J.A. & Blagov, P. (2004). The integrative function of narrative processing. In D.R. Beike et al. (Eds.), *The Self and Memory*
- Conway, M.A. & Singer, J.A. (2012). Self-defining memories. In T. Habermas (Ed.), *The Development of Autobiographical Reasoning*
