# Question Sequences

Based on Haight's Structured Life Review and Birren's Guided Autobiography.

## The Reminiscence Bump

People have more and more vivid memories from ages 10-30. This "reminiscence bump" is when identity forms.

**Why target the bump:**
- Memories are richer and more accessible
- Identity-defining events cluster here
- First experiences (love, work, independence) are encoded deeply
- Cultural and generational influences are strongest

**Life stages within the bump:**
- Childhood (10-12): Pre-identity, family context
- Adolescence (13-18): Identity exploration, social comparison
- Emerging adulthood (18-25): Independence, career, relationships
- Early adulthood (25-30): Consolidation, commitment

## Haight's Life Review Interview

Barbara Haight developed a structured life review protocol for reminiscence therapy. Adapted for elicitation:

### Childhood (Birth to 12)

**Family context:**
> "What was your family like when you were growing up? What was the feeling in your home?"

> "What were your parents like? How would you describe each of them?"

> "What was your role in the family? Were you the peacekeeper, the rebel, the invisible one?"

**Childhood self:**
> "What were you like as a child? How would people have described you?"

> "What did you love doing most?"

> "What were you afraid of?"

**School and social:**
> "What was school like for you? Were you a good student?"

> "Who were your friends? What did you do together?"

> "Did you feel like you fit in, or were you different somehow?"

**Significant memories:**
> "Is there a memory from childhood that really stands out—something that still feels important?"

> "What's your earliest memory?"

### Adolescence (12-18)

**Physical and identity changes:**
> "How did puberty affect you? How did you feel about the changes in your body?"

> "At what point did you start to feel like your own person, separate from your family?"

**Social world:**
> "What were your friendships like as a teenager? Did you have a best friend?"

> "What was your first crush or romantic interest like?"

> "What groups or activities were you part of?"

**Family dynamics:**
> "How did your relationship with your parents change during this time?"

> "Were there conflicts? What were they about?"

**Dreams and struggles:**
> "What did you dream about becoming?"

> "What was the hardest thing about being a teenager?"

> "Was there a moment when you felt like you really understood something about yourself or the world?"

### Early Adulthood (18-30)

**Transition:**
> "What was leaving home like? Was it gradual or sudden?"

> "How did you decide what to do after high school?"

> "What was the first time you felt truly independent?"

**Work and purpose:**
> "What were your first jobs or career steps? How did you feel about them?"

> "Did you know what you wanted to do, or were you figuring it out?"

> "What was your sense of purpose during this time?"

**Relationships:**
> "What were your first serious relationships like?"

> "How did you meet your partner(s)?"

> "What did you learn about yourself through those relationships?"

**Challenges:**
> "What was the biggest challenge you faced in your 20s?"

> "Were there any failures or setbacks that shaped you?"

> "What are you most proud of from this time?"

### Middle Adulthood (30-60)

**Identity consolidation:**
> "How did your sense of yourself change as you got older?"

> "Were there moments when you questioned the path you were on?"

> "When did you feel most like yourself?"

**Accomplishments:**
> "What do you consider your major accomplishments during this period?"

> "What contributions are you most proud of?"

**Losses:**
> "What losses did you experience? Deaths, divorces, other endings?"

> "How did you cope with those losses?"

**Relationships and roles:**
> "How did your relationships evolve—with partners, children, friends, colleagues?"

> "What roles were you playing? Which ones fit, and which ones didn't?"

**Wisdom gained:**
> "What did you learn about yourself during these years that you didn't know before?"

### Later Life (60+)

**Changes:**
> "How has your daily life changed in recent years?"

> "What's different about how you experience time?"

**What matters:**
> "What matters most to you now? Has that changed from earlier in life?"

> "What are you still curious about or working on?"

**Legacy:**
> "What do you want to be remembered for?"

> "What would you want to pass on to younger generations?"

**Integration:**
> "Looking back, what do you understand now that you didn't before?"

> "What would you tell your younger self if you could?"

## Birren's Guided Autobiography

James Birren developed thematic "sensitizing questions" to elicit autobiography in groups. These can be adapted for one-on-one:

### Major Branching Points

The moments when life could have gone differently:

> "Looking back, what were the major turning points or branching points in your life?"

> "What decisions changed the course of your life?"

> "Were there moments when you almost made a different choice?"

> "How might your life have been different if you'd chosen differently?"

### Family History

Understanding context and inheritance:

> "What was the story of your family—where they came from, what they valued?"

> "What patterns do you see across generations?"

> "What did you inherit from your family—values, traits, struggles?"

> "What did you consciously choose to be different about?"

### Career and Work

Meaning of work across life:

> "What has work meant to you beyond earning a living?"

> "When have you felt most fulfilled in your work?"

> "What work would you do even if you weren't paid?"

> "How has your relationship to work changed over time?"

### Money

Attitudes toward security and resources:

> "What were the messages about money in your family?"

> "What does financial security mean to you?"

> "Have there been times when money—having it or not having it—shaped your choices?"

> "If money were no object, what would you do differently?"

### Health and Body

Physical experience across life:

> "How has your relationship with your body changed over time?"

> "Have there been health experiences that changed how you think about life?"

> "How do you take care of yourself?"

> "What has illness or physical limitation taught you?"

### Loves and Hates

Strong affects as windows:

> "What have you loved most in your life—people, activities, ideas?"

> "What have you hated or been unable to tolerate?"

> "What evokes the strongest feelings in you?"

### Sexual Identity

For appropriate contexts:

> "How did you come to understand yourself as a sexual person?"

> "What has intimacy meant to you?"

> "How has your sense of gender shaped your experience?"

### Death and Ideas About Death

For appropriate contexts:

> "Have you experienced significant losses—people close to you who died?"

> "How have those losses affected how you live?"

> "What are your thoughts about your own mortality?"

> "What do you want to happen when you die?"

### Meaning and Life Purpose

The deepest territory:

> "What gives your life meaning?"

> "What beliefs or values guide you?"

> "What questions are you still trying to answer?"

> "What's your philosophy of life?"

## Sequencing Principles

### Start with Safety
Begin with less threatening territory:
- Factual questions about family context
- Positive memories first
- Present before past (sometimes)

### Spiral Not Linear
Return to themes at different life stages:
- "That feeling of being an outsider—did that show up earlier? Later?"
- "You mentioned independence mattering. When did that start?"

### Follow Energy
Notice what they emphasize and return:
- Topics they elaborate on freely
- Emotions that surface
- Stories they repeat

### Bridge Time
Connect across periods:
> "That pattern you described in your marriage—was there something similar in your family growing up?"

### End with Integration
Close with meaning-making:
> "What do you make of all this? Any patterns or themes you notice?"

## Adaptation for Different Goals

### For Understanding Values
Focus on decisions, turning points, strong affects

### For Understanding Schemas
Focus on childhood, family patterns, recurring difficulties

### For Understanding Motivation
Focus on goals, accomplishments, what energizes

### For Understanding Identity
Focus on the reminiscence bump, transitions, self-defining memories

## Key Sources

- Haight, B.K. & Haight, B.S. (2007). *The Handbook of Structured Life Review*
- Birren, J.E. & Cochran, K.N. (2001). *Telling the Stories of Life through Guided Autobiography Groups*
- Butler, R.N. (1963). The life review: An interpretation of reminiscence in the aged. *Psychiatry*
- Rubin, D.C. et al. (1986). Autobiographical memory across the lifespan. In D.C. Rubin (Ed.), *Autobiographical Memory*
