# Narrative Identity

Based on Dan McAdams' research on life stories and identity.

## Core Concept

**Narrative identity** is the internalized, evolving story you construct about yourself—how you came to be who you are and where your life is going.

Key insight: It's not what happened that shapes identity, but how you story what happened.

## The Life Story Interview

McAdams developed a structured interview to elicit life narratives. The full interview takes 2-3 hours, but core elements can be adapted conversationally.

### The 8 Key Scenes

Ask the person to describe specific scenes—particular moments in time, like scenes in a movie:

1. **High Point**
   > "Please describe a scene, episode, or moment in your life that stands out as an especially positive experience. This might be the high point of your entire life, or just a particularly wonderful moment. What happened? Who was involved? What were you thinking and feeling? Why is this memory important?"

2. **Low Point**
   > "Describe a scene that stands out as a low point—a moment of great pain, sadness, fear, or despair. Even though this memory is unpleasant, I want you to be as honest and detailed as possible."

3. **Turning Point**
   > "Describe a specific moment that marked a significant change in your life story. It might be when you realized something important, made a key decision, or something happened that changed your direction."

4. **Earliest Memory**
   > "What is the earliest memory you have? Describe the scene in as much detail as possible."

5. **Important Childhood Memory**
   > "Describe a vivid memory from childhood (before age 12) that stands out for any reason."

6. **Important Adolescent Memory**
   > "Describe a vivid memory from your teenage years that stands out."

7. **Important Adult Memory**
   > "Describe a significant memory from your adult life that says something about who you are."

8. **One Other Important Memory**
   > "Is there any other memory—from any point in your life—that you feel is especially important for understanding who you are?"

### Probing Questions

For each scene:
- Where and when did this take place?
- Who was there?
- What were you thinking and feeling?
- Why is this scene significant?
- What does it say about who you are or were?

## Narrative Themes

### Agency vs. Communion

Two fundamental motivational themes run through life stories:

**Agency** (individualistic motives):
- Self-mastery and personal achievement
- Power, status, and influence
- Independence and self-reliance
- Personal empowerment and control

*Linguistic markers:*
- "I decided..." "I made it happen..."
- "I pushed through..." "I achieved..."
- "I controlled..." "I mastered..."

**Communion** (social motives):
- Love and intimacy
- Friendship and belonging
- Care and helping others
- Unity and connection

*Linguistic markers:*
- "We were together..." "I felt close to..."
- "They understood me..." "I belonged..."
- "I helped them..." "We connected..."

Most people express both themes, but the balance reveals core motivations.

### Redemption vs. Contamination

The most powerful narrative pattern is how people sequence positive and negative elements:

**Redemption Sequences**
Bad leads to good. Suffering is transformed into growth.

*Structure:* Negative state → Positive outcome

*Examples:*
- "The divorce was devastating, but it forced me to become independent."
- "Getting fired was the best thing that happened—it pushed me to start my own company."
- "I hit rock bottom, but that's when I finally asked for help."

*Psychological correlates:*
- Higher well-being
- Greater generativity (concern for future generations)
- Resilience after adversity

**Contamination Sequences**
Good leads to bad. Positive experiences are spoiled or ruined.

*Structure:* Positive state → Negative outcome

*Examples:*
- "We were so happy until the diagnosis."
- "I thought I had made it, but then everything fell apart."
- "That perfect summer ended when they moved away."

*Psychological correlates:*
- Depression and anxiety
- Unresolved grief or trauma
- Difficulty finding meaning

### Listening for Sequences

When someone tells a story, notice:

1. **Where does it end?** Redemption stories move toward positive resolution. Contamination stories end in darkness.

2. **What transforms what?** In redemption, negative enables positive growth. In contamination, positive is destroyed by negative.

3. **What's the takeaway?** Redemption: "And that's why I'm stronger." Contamination: "And that's why I can't trust."

## Life Story Chapters

People organize their lives into chapters like a book. Ask:

> "If your life were a book, what would the chapters be called? What era are you in now?"

Common chapter structures:
- Chronological (childhood, adolescence, early career, etc.)
- Thematic (the struggling years, the building years, the questioning years)
- Relational (before marriage, during marriage, after divorce)

The chapter structure reveals how someone organizes their identity across time.

## Generativity Script

McAdams found that highly generative adults (those concerned with guiding the next generation) share a common life story structure:

1. **Early advantage** - Sense of being blessed or fortunate
2. **Awareness of suffering** - Recognition that others suffer while they don't
3. **Moral steadfastness** - Commitment to a set of values
4. **Redemption sequences** - Transforming suffering into growth
5. **Prosocial goals** - Desire to give back

*Elicitation:*
> "Do you feel you've had advantages others haven't? How has that affected how you think about your responsibilities?"

## Identity Statuses

Related work by James Marcia identifies four identity statuses based on exploration and commitment:

| Status | Exploration | Commitment | Description |
|--------|-------------|------------|-------------|
| Diffusion | Low | Low | No clear sense of self, drifting |
| Foreclosure | Low | High | Adopted identity without exploring |
| Moratorium | High | Low | Actively exploring, not yet committed |
| Achievement | High | High | Explored and committed to identity |

*Elicitation:*
> "How did you come to be in your current career/relationship/lifestyle? Was it something you chose deliberately, or did it just happen?"

## Narrative Coherence

Well-formed life stories have:

1. **Temporal coherence** - Events are ordered logically in time
2. **Causal coherence** - Events are connected by cause and effect
3. **Thematic coherence** - A consistent theme or message runs through

Fragmented or incoherent narratives may indicate:
- Identity confusion
- Unprocessed trauma
- Developmental challenges

*Assessing coherence:*
- Does the story have a beginning, middle, and end?
- Are transitions explained?
- Is there an overarching meaning or message?

## Conversational Elicitation

### Opening Moves

> "I'm curious about your story—not the resume version, but how you'd tell it to someone who really wanted to understand you."

> "If you had to explain to someone how you became who you are, where would you start?"

### Following the Energy

- Notice what they emphasize and return to it
- Ask about emotions, not just events
- Reflect themes back: "It sounds like independence has always mattered..."

### Bridging Across Time

> "That moment in high school—has something like that happened since?"

> "You mentioned feeling like an outsider. When did that feeling first show up?"

## Key Sources

- McAdams, D.P. (1993). *The Stories We Live By*
- McAdams, D.P. (2006). *The Redemptive Self*
- McAdams, D.P. & McLean, K.C. (2013). Narrative identity. *Current Directions in Psychological Science*
- Marcia, J.E. (1966). Development and validation of ego-identity status. *Journal of Personality and Social Psychology*
