# Motivational Interviewing

Based on Miller & Rollnick's clinical framework, adapted for elicitation.

## Core Philosophy

Motivational Interviewing (MI) is a collaborative conversation style for strengthening a person's own motivation and commitment. Its techniques are powerful for elicitation because they create conditions for authentic disclosure.

**Key principle:** People are more likely to share deeply when they feel understood, not interrogated.

## The Spirit of MI

### Partnership
You're alongside them, not above them. Curious, not expert.

*Not:* "Let me analyze your patterns."
*But:* "Help me understand how you see this."

### Acceptance
Unconditional positive regard. Their experience is valid.

*Not:* "That seems like an overreaction."
*But:* "That really affected you."

### Compassion
Genuine care for their well-being and interests.

*Not:* Clinical detachment
*But:* Warm curiosity

### Evocation
Drawing out what's already there, not installing new content.

*Not:* "Have you considered that maybe..."
*But:* "What do you make of that?"

## OARS: Core Skills

### O - Open Questions

Questions that can't be answered with yes/no. They invite exploration.

| Closed | Open |
|--------|------|
| Did you like growing up there? | What was it like growing up there? |
| Were you close to your parents? | What was your relationship with your parents like? |
| Do you regret that decision? | How do you feel about that decision now? |
| Was that hard? | What was hard about that? |

**Types of open questions:**

*Elaboration:*
> "Tell me more about that."
> "What else comes to mind?"

*Feeling:*
> "What was that like for you?"
> "How did that land?"

*Meaning:*
> "What did that mean to you?"
> "What sense do you make of that?"

*Perspective:*
> "How do you see that now?"
> "What would you tell your younger self?"

### A - Affirmations

Genuine recognition of strengths, efforts, or values. **Not** compliments or praise.

| Compliment (avoid) | Affirmation (use) |
|--------------------|-------------------|
| "That's great!" | "You valued honesty even when it cost you." |
| "Good for you!" | "You found a way to keep going despite everything." |
| "You're so brave!" | "Standing up for yourself wasn't easy, and you did it anyway." |

**Affirmation formula:** Notice something positive + name the quality or value behind it.

*Examples:*
> "You kept trying even when it seemed hopeless—that took real persistence."
> "You made a choice that protected your integrity, even though it was costly."
> "You trusted your instincts when everyone was telling you otherwise."

**When to affirm:**
- When they minimize their own strengths
- When they share something difficult
- When you notice a value in action

### R - Reflections

The most powerful skill. Restating or reframing what they said, showing you heard.

**Reflection-to-question ratio: Aim for 2:1**

For every question you ask, offer at least two reflections. This prevents interrogation and deepens disclosure.

#### Simple Reflections
Repeat back the essence of what they said.

*They said:* "I felt completely invisible in that meeting."
*Simple reflection:* "You felt invisible."

Use when:
- You want to show you're listening
- You want them to continue
- You're not sure what to add

#### Complex Reflections
Add meaning, emotion, or implication beyond what they explicitly said.

*They said:* "I felt completely invisible in that meeting."
*Complex reflection:* "It sounds like being recognized for your contributions really matters to you."

Types of complex reflection:

**Amplified reflection** - Slightly exaggerate to invite correction or nuance:
> They: "I was a little annoyed."
> You: "You were furious."
> They: "Well, not furious, but definitely frustrated."

**Understated reflection** - Understate to invite elaboration:
> They: "It was the worst day of my life."
> You: "That was a difficult day."
> They: "Difficult doesn't even begin to cover it..."

**Double-sided reflection** - Capture ambivalence:
> "On one hand, you wanted to stay. On the other, you knew you had to leave."

**Continuing the paragraph** - Guess what they might say next:
> They: "I grew up always having to..."
> You: "...prove yourself. Like you couldn't just be accepted."

**Reflection of feeling** - Name the emotion:
> They: "I worked so hard on that and they didn't even acknowledge it."
> You: "That was painful. Maybe even a little humiliating."

#### The Art of Reflecting

- Reflect meaning, not just content
- Notice what's unsaid but implied
- It's okay to be wrong—they'll correct you
- End reflections with a falling tone (not a question)
- Leave space after reflecting

### S - Summaries

Periodically gather what you've heard. Creates meaning and invites correction.

**Types of summaries:**

**Collecting summary** - Gather multiple points:
> "So far, you've mentioned the pressure from your family, the difficulty of the move, and how isolating that first year was."

**Linking summary** - Connect themes:
> "It sounds like there's a pattern here—you often found yourself taking care of others, maybe at the expense of your own needs. That showed up with your mom, then in your first relationship, and now at work."

**Transitional summary** - Bridge to new territory:
> "You've shared a lot about your childhood. Before we move on, is there anything else from that time that feels important?"

**When to summarize:**
- After several minutes of exploration
- Before changing topics
- When they seem scattered or overwhelmed
- At the end of a conversation

## The Question Trap

Too many questions create resistance:

*Question trap:*
> Q: "What happened?"
> A: "We had an argument."
> Q: "What was it about?"
> A: "Money."
> Q: "Who started it?"
> A: "She did."
> Q: "How did you react?"
> (Person becomes guarded, answers become shorter)

*OARS pattern:*
> Q: "What happened?"
> A: "We had an argument."
> R: "That was hard."
> A: "It was. We never used to fight like that."
> R: "Something changed in how you argue."
> A: "Yeah, it's like we can't just disagree anymore—it always escalates."
> R: "It's gotten harder to feel heard."
> (Person elaborates, shares more deeply)

## Resistance and Discord

When someone becomes defensive or resistant:

**Don't:**
- Push harder
- Argue your point
- Try to convince

**Do:**
- Reflect their position
- Emphasize autonomy
- Shift focus

*Example:*
> They: "I don't want to talk about my father."
> Wrong: "But it seems like that's important."
> Right: "That's completely up to you. What would you prefer to focus on?"

## Rolling with Resistance

Instead of opposing resistance, align with it:

*They:* "Therapy is stupid. This isn't going to help."

*Opposing (avoid):* "Give it a chance. Many people find it helpful."

*Rolling (use):*
> "You're skeptical that talking about things will make a difference. And you've probably tried other things that didn't work. What would need to happen for this to feel worthwhile?"

## Change Talk and Sustain Talk

In clinical MI, practitioners listen for:

**Change talk** - Arguments for change (desire, ability, reasons, need, commitment)
**Sustain talk** - Arguments for status quo

For elicitation, notice:

**Approach talk** - Movement toward disclosure, exploration, insight
**Avoidance talk** - Deflection, minimization, topic changing

When you hear approach talk, reflect it to deepen. When you hear avoidance talk, don't push—reflect the ambivalence.

## Eliciting Values

Values emerge naturally in MI-style conversations. Notice when they say:

- "I believe..."
- "What matters to me is..."
- "I couldn't live with myself if..."
- "That's just not who I am..."

Reflect these back:
> "Integrity is non-negotiable for you."
> "Being there for family is core to who you are."

## Conversational Flow

A typical OARS sequence:

1. **Open question** to invite exploration
2. **Reflection** to deepen
3. **Reflection** to add meaning
4. **Follow-up question** to probe further
5. **Reflection** to acknowledge
6. **Summary** to consolidate

*Example:*
> Q: "What was that transition like for you—leaving home?"
> A: "It was harder than I expected. I thought I was ready."
> R: "You thought you were prepared, but something surprised you."
> A: "Yeah, I didn't realize how much I depended on my mom. Not for practical stuff—emotionally."
> R: "There was an emotional safety net you didn't know you had until it was gone."
> A: "Exactly. I felt... exposed. Like suddenly everything was on me."
> Q: "What was that exposure like?"
> A: "Terrifying, honestly. But also... I don't know, clarifying? Like I finally had to figure out who I actually was."
> R: "The fear came with a kind of clarity—you couldn't hide from yourself anymore."
> S: "So leaving home was harder than expected because you lost an emotional foundation. But in that vulnerability, there was also a forced self-discovery."

## Key Sources

- Miller, W.R. & Rollnick, S. (2023). *Motivational Interviewing: Helping People Change and Grow* (4th ed.)
- Miller, W.R. & Rollnick, S. (2002). *Motivational Interviewing: Preparing People for Change* (2nd ed.)
- Rosengren, D.B. (2017). *Building Motivational Interviewing Skills* (2nd ed.)
