# Language Inference

Based on LIWC research and computational approaches to personality.

## The Promise and Peril

Language reveals psychology. But the relationship is subtle, probabilistic, and easily misused.

**What language can tell us:**
- Broad tendencies and patterns
- Shifts over time within a person
- States (temporary) vs. traits (stable)
- Signals worth investigating further

**What language cannot tell us:**
- Definitive diagnosis
- Precise personality scores
- Certainty about inner states
- Conclusions from small samples

## LIWC: Linguistic Inquiry and Word Count

LIWC is the most-validated tool for analyzing psychological language. It counts words in categories.

### Key Findings (with Caveats)

#### Pronouns

**First-person singular ("I", "me", "my")**

*Higher use associated with:*
- Self-focus (obvious)
- Honesty (saying "I" admits ownership)
- Depression (rumination, self-focus)
- Lower social status (deference)

*But note:*
- Context matters enormously
- Genre effects (personal narrative vs. technical writing)
- Cultural variation

**First-person plural ("we", "us", "our")**

*Higher use associated with:*
- Collectivist orientation
- Intimacy in relationships
- Team identification
- Leadership language (including audience)

**Second-person ("you")**

*Higher use may indicate:*
- Other-focus
- Advice-giving
- Aggression (in some contexts)

#### Emotional Words

**Positive emotion words (happy, love, nice)**

*Higher use associated with:*
- Psychological well-being
- Extraversion
- Social integration

*But note:*
- May be impression management
- Cultural display rules vary
- Positive words in negative context (sarcasm)

**Negative emotion words (hate, fear, awful)**

*Higher use associated with:*
- Psychological distress
- Neuroticism
- Processing difficult experiences (not always bad)

*Types of negative emotion:*
- Anxiety words (worried, nervous): uncertainty, threat
- Anger words (hate, furious): blocked goals, violation
- Sadness words (grief, lonely): loss, separation

#### Cognitive Complexity

**Cognitive mechanism words (because, think, know, reason)**

*Higher use associated with:*
- Analytical thinking
- Meaning-making
- Working through problems
- Education level

**Certainty words (always, never, definitely)**

*Higher use associated with:*
- Cognitive closure needs
- Lower openness (sometimes)
- Strong convictions

**Tentative words (maybe, perhaps, seems)**

*Higher use associated with:*
- Open-mindedness
- Uncertainty tolerance
- Less confidence (context-dependent)

#### Temporal Focus

**Past tense**

*Higher use may indicate:*
- Reflection, reminiscence
- Depression (rumination)
- Narrative mode

**Present tense**

*Higher use may indicate:*
- Immediacy, presence
- State focus
- Impulsivity (in some contexts)

**Future tense**

*Higher use may indicate:*
- Goal orientation
- Planning, anticipation
- Anxiety about future

### The Critical Caveats

1. **Effect sizes are small.** Correlations between language and personality are typically r = .10-.30. This explains 1-9% of variance. Language is a weak signal.

2. **Aggregation matters.** Findings emerge from thousands of words across many people. A single conversation is not enough data.

3. **Context is everything.** The same word patterns mean different things in:
   - Formal vs. informal settings
   - Writing vs. speech
   - Public vs. private contexts
   - Different genres and tasks

4. **Cross-validation is essential.** Never rely on language alone. Triangulate with:
   - Behavioral observations
   - Explicit self-report
   - Multiple conversations
   - Different contexts

5. **Individual variation is huge.** Group-level patterns may not apply to any specific individual. Population statistics ≠ individual prediction.

6. **Cultural and linguistic differences.** LIWC is validated primarily in English and Western samples. Other languages and cultures may differ substantially.

## Thin-Slice Research

Ambady's "thin-slice" research shows that very brief exposures can predict outcomes—but with major limitations.

**What thin slices can predict:**
- Teacher effectiveness from clips (r ≈ .30)
- Interview success from brief samples
- Some personality dimensions

**What thin slices get wrong:**
- Systematic biases (attractiveness, warmth halo)
- Stereotype application
- Overconfidence in judgments

**For elicitation:**
- First impressions are data, not conclusions
- Initial hypotheses should be tested, not assumed
- Be aware of your own thin-slice biases

## Computational Personality Inference

Machine learning approaches can predict:
- Big Five personality from social media (r ≈ .30-.40)
- Demographics from language
- Political orientation
- Mental health indicators

**Accuracy ranges:**
- Better than chance
- Worse than self-report
- Worse than close informant report

**For elicitation:**
- Automated systems give probabilistic signals
- Always verify with direct inquiry
- Be transparent about uncertainty

## What to Listen For

### Linguistic Markers Worth Noting

| Pattern | Possible Indication | Confidence |
|---------|---------------------|------------|
| High absolutism (always, never) | Black-and-white thinking | Moderate |
| Exclusive words (but, except) | Differentiation, complexity | Low |
| Inclusive words (and, with) | Integration, connection | Low |
| Past focus across topics | Rumination or reflection | Low |
| Personal narrative vs. abstract | Concrete vs. conceptual style | Moderate |
| Emotional flooding | Schema activation | Moderate |
| Sudden topic shifts | Avoidance, discomfort | Moderate |

### Higher-Confidence Signals

**Thematic repetition:**
When someone returns to the same theme across different topics, that theme matters.

**Emotional intensity:**
Strong affect signals importance—whether positive or negative.

**Contradiction and ambivalence:**
Conflicting statements about the same topic suggest unresolved tension.

**Elaboration patterns:**
What they expand on vs. what they skip quickly.

## Integration with Other Evidence

Language analysis should be:
- **Hypothesis-generating**, not conclusion-confirming
- **One input among many**, not the sole source
- **Cross-validated**, not taken at face value
- **Held lightly**, subject to revision

### Triangulation Sources
1. Explicit statements about self
2. Behavior patterns
3. Reactions of others
4. Historical patterns
5. Cross-situational consistency

## Ethical Considerations

### Transparency
- Don't claim to know more than language reveals
- Acknowledge uncertainty to yourself and others

### Humility
- Language inference is probabilistic, not definitive
- Individual exceptions to group patterns are common

### Consent
- People may not realize their language is being analyzed
- Be thoughtful about surveillance implications

### Bias Awareness
- Your interpretations are influenced by your own biases
- Language norms vary by culture, class, region

## Key Sources

- Pennebaker, J.W. (2011). *The Secret Life of Pronouns*
- Pennebaker, J.W., Boyd, R.L., Jordan, K., & Blackburn, K. (2015). The development and psychometric properties of LIWC2015
- Pennebaker, J.W. & King, L.A. (1999). Linguistic styles: Language use as an individual difference. *Journal of Personality and Social Psychology*
- Tausczik, Y.R. & Pennebaker, J.W. (2010). The psychological meaning of words: LIWC and computerized text analysis methods. *Journal of Language and Social Psychology*
- Ambady, N. & Rosenthal, R. (1992). Thin slices of expressive behavior as predictors of interpersonal consequences. *Psychological Bulletin*
- Park, G. et al. (2015). Automatic personality assessment through social media language. *Journal of Personality and Social Psychology*
