---
name: elicitation
description: 'Psychological profiling through natural conversation using narrative identity
  research (McAdams), self-defining memory elicitation (Singer), and Motivational Interviewing
  (OARS framework). Use when you need to: (1) understand someone''s core values and motivations,
  (2) discover formative memories and life-defining experiences, (3) detect emotional schemas
  and belief patterns, (4) build psychological profiles through gradual disclosure,
  (5) conduct user interviews that reveal deep insights, (6) design conversational flows
  for personal discovery, (7) identify identity themes like redemption and contamination narratives,
  (8) elicit authentic self-disclosure without interrogation.'
license: MIT
metadata:
  author: tasteray
  version: "1.0"
---

# Elicitation

Psychological profiling through natural conversation.

## Goal

When reviewing or creating content related to psychological elicitation—whether conversation scripts, interview questions, user research flows, or any code that implements these techniques—**your goal is to achieve a 10/10 score**.

Score all work on a 0-10 scale based on adherence to the principles and techniques in this skill. Provide your assessment as **X/10** with specific feedback on what's working and what needs improvement to reach 10/10.

A 10/10 means the work:
- Embodies the core principle (depth through patience, not probing)
- Uses appropriate techniques from the research traditions
- Avoids all anti-patterns
- Creates conditions for authentic self-disclosure

Iterate until you reach 10/10.

---

## Core Principle

**Depth comes from patience, not probing.**

The most revealing information emerges when people feel safe to share, not when they're questioned. Your role is to create conversational space where self-disclosure feels natural and meaningful.

Key insight: People want to tell their stories. They rarely get the chance.

## Three Research Traditions

This skill synthesizes three complementary approaches:

### 1. Autobiographical Memory Research
How memories shape identity. Key finding: **Self-defining memories** (Singer) are the building blocks of personality—vivid, emotionally intense, frequently rehearsed memories linked to enduring concerns.

### 2. Narrative Identity Theory
How people construct life stories. Key finding: The **narrative themes** people use (redemption vs. contamination, agency vs. communion) predict psychological well-being better than the actual events (McAdams).

### 3. Motivational Interviewing
How to facilitate disclosure without resistance. Key finding: **Reflections outperform questions** at eliciting authentic self-disclosure. Aim for 2:1 reflection-to-question ratio (Miller & Rollnick).

---

## Self-Defining Memories

Jefferson Singer identified five criteria that make a memory "self-defining":

1. **Vivid** - Rich sensory and emotional detail
2. **Emotionally intense** - Strong feeling, positive or negative
3. **Frequently rehearsed** - Comes to mind often, told to others
4. **Linked to similar memories** - Part of a pattern or theme
5. **Connected to enduring concerns** - Reflects ongoing goals, conflicts, or unresolved issues

### Eliciting Self-Defining Memories

Don't ask: "What's your most formative memory?"

Instead, create conversational frames:

**The "keeps coming back" frame:**
> "Some memories just stay with us—they pop into our heads at unexpected moments, or we find ourselves telling them to new people in our lives. Is there a memory like that for you?"

**The "explains who I am" frame:**
> "When you're getting to know someone new and you want them to really understand where you're coming from, is there a story or moment you find yourself sharing?"

**The "turning point" frame:**
> "Looking back, was there a moment that felt like things shifted—where life before and after felt somehow different?"

### What Self-Defining Memories Reveal

| Memory Feature | Personality Insight |
|----------------|---------------------|
| Themes of mastery, achievement | High need for agency |
| Themes of connection, relationships | High need for communion |
| Redemption sequences (bad → good) | Resilience, generativity |
| Contamination sequences (good → bad) | Depression risk, unresolved trauma |
| Integration and meaning-making | Psychological maturity |
| Fragmentation and confusion | Identity diffusion |

See: [Self-Defining Memories Reference](elicitation/self-defining-memories.md)

---

## Life Story Interview: 8 Key Scenes

Dan McAdams' Life Story Interview asks for 8 specific "scenes" that reveal narrative identity:

1. **High Point** - Peak experience, most wonderful moment
2. **Low Point** - Nadir, most difficult moment
3. **Turning Point** - Moment of significant change
4. **Earliest Memory** - First clear memory
5. **Important Childhood Memory** - Vivid memory before age 12
6. **Important Adolescent Memory** - Vivid memory from teen years
7. **Important Adult Memory** - Significant recent memory
8. **One Other Important Memory** - Anything else that defines who they are

### Conversational Adaptations

You don't need to ask all 8 sequentially. Instead:

**Open with curiosity, not agenda:**
> "I'm curious about the moments that shaped you. Not necessarily the big resume stuff—more the experiences that stick with you."

**Follow their lead:**
When they mention a period of life, gently explore:
> "What was that time like for you? Any particular moments that stand out?"

**Bridge across time:**
> "That sounds like it mattered. Was there ever a moment earlier—or later—that connected to that same feeling?"

### Narrative Themes to Listen For

**Agency themes** (personal power, achievement, mastery):
- "I decided..."
- "I made it happen..."
- "I pushed through..."

**Communion themes** (connection, love, belonging):
- "We were all together..."
- "I felt so close to..."
- "They understood me..."

**Redemption sequences** (suffering leads to growth):
- "It was terrible, but..."
- "Looking back, I'm glad..."
- "That's what made me who I am..."

**Contamination sequences** (good becomes bad):
- "Things were great until..."
- "I thought I was happy, but..."
- "It ruined everything..."

See: [Narrative Identity Reference](elicitation/narrative-identity.md)

---

## OARS Framework

Motivational Interviewing's core skills, adapted for elicitation:

### Open Questions
Questions that can't be answered with yes/no. But use sparingly.

Instead of: "Did you like your childhood?"
Try: "What was it like growing up in your family?"

### Affirmations
Genuine recognition of strengths, efforts, or values—not compliments.

Instead of: "That's great!"
Try: "You valued honesty even when it was costly."

### Reflections
Restate or reframe what they said. This is the core skill.

**Simple reflection** (repeat back):
> "So you felt invisible in that moment."

**Complex reflection** (add meaning):
> "It sounds like recognition really matters to you—like you need to know your contributions are seen."

**Amplified reflection** (gently exaggerate):
> "So nothing they could have done would have made a difference." (Often prompts them to nuance their position)

**Double-sided reflection** (hold both truths):
> "On one hand, you loved the stability. On the other, you felt trapped."

### Summaries
Periodically gather what you've heard. Creates meaning and invites correction.

> "Let me see if I'm following: Growing up, you learned to be self-reliant because asking for help meant disappointment. But you've also noticed that pattern keeping people at a distance now. And you're wondering if there's another way."

### The 2:1 Ratio

**Aim for 2 reflections for every question.**

Questions gather information but can feel like interrogation. Reflections show understanding and invite elaboration.

Bad pattern:
> Q: "What happened?" → Q: "How did that feel?" → Q: "What did you do next?"

Better pattern:
> Q: "What happened?" → R: "That caught you off guard" → R: "You weren't sure what to make of it"

See: [Motivational Interviewing Reference](elicitation/motivational-interviewing.md)

---

## Values Elicitation

Shalom Schwartz's 10 Universal Values provide a framework for understanding motivation:

| Value | Core Concern |
|-------|--------------|
| **Self-Direction** | Independence, freedom, creativity |
| **Stimulation** | Novelty, excitement, challenge |
| **Hedonism** | Pleasure, enjoyment, gratification |
| **Achievement** | Success, competence, ambition |
| **Power** | Authority, wealth, social status |
| **Security** | Safety, stability, order |
| **Conformity** | Obedience, self-discipline, politeness |
| **Tradition** | Respect, commitment, humility |
| **Benevolence** | Helpfulness, loyalty, forgiveness |
| **Universalism** | Equality, justice, environmental protection |

### Values Elicitation Techniques

**Role model technique:**
> "Who do you admire? What is it about them specifically?"

**Opposite day technique:**
> "What kind of person could you never be? What would feel like a betrayal of yourself?"

**Decision archaeology:**
> "Think of a hard choice you made. What ultimately tipped the scales?"

**Anger as values signal:**
> "What makes you genuinely angry—not annoyed, but morally outraged?"

See: [Values Elicitation Reference](elicitation/values-elicitation.md)

---

## Schema Detection

Jeffrey Young's 18 Early Maladaptive Schemas are stable patterns of thinking and feeling that develop in childhood and persist across contexts:

### The Five Domains

**1. Disconnection & Rejection**
- Abandonment, Mistrust/Abuse, Emotional Deprivation, Defectiveness/Shame, Social Isolation

**2. Impaired Autonomy**
- Dependence/Incompetence, Vulnerability to Harm, Enmeshment, Failure

**3. Impaired Limits**
- Entitlement/Grandiosity, Insufficient Self-Control

**4. Other-Directedness**
- Subjugation, Self-Sacrifice, Approval-Seeking

**5. Overvigilance & Inhibition**
- Negativity/Pessimism, Emotional Inhibition, Unrelenting Standards, Punitiveness

### Downward Arrow Technique

When someone expresses a surface concern, gently probe for the deeper belief:

> Person: "I'm worried about the presentation."
> You: "What's the worst that could happen?"
> Person: "I could mess up in front of everyone."
> You: "And if that happened, what would that mean?"
> Person: "They'd see I don't know what I'm doing."
> You: "And what would that mean about you?"
> Person: "That I'm a fraud. That I don't deserve to be here."

The bottom of the arrow often reveals a schema (in this case: Defectiveness/Shame or Failure).

### Linguistic Markers of Schemas

| Schema | Language Patterns |
|--------|-------------------|
| Abandonment | "Everyone leaves eventually..." |
| Defectiveness | "There's something wrong with me..." |
| Failure | "I never finish anything..." |
| Emotional Deprivation | "No one really understands..." |
| Unrelenting Standards | "It's never good enough..." |

See: [Schema Detection Reference](elicitation/schema-detection.md)

---

## The Reminiscence Bump

People have disproportionately more and more vivid memories from ages 10-30 (the "reminiscence bump"). This is when identity forms.

**Target the bump:**
- First romantic relationship
- First job or career defining moment
- Leaving home
- Key friendships formed
- Educational turning points
- Early adult struggles and triumphs

**Bridge from present to bump:**
> "You mentioned feeling like an outsider at work. Was there a time earlier in life—maybe in school or when you were first starting out—when you felt something similar?"

---

## Question Sequences by Life Stage

Barbara Haight's Life Review Interview provides structured sequences:

### Childhood (before 12)
1. What was your home like?
2. What were your parents like?
3. What was your role in the family?
4. What were you like as a child?
5. What did you enjoy doing most?

### Adolescence (12-18)
1. How did your body change? How did you feel about it?
2. What was school like for you?
3. What were your friendships like?
4. What did you dream about becoming?
5. What was hardest about being a teenager?

### Early Adulthood (18-30)
1. What was leaving home like?
2. What were your first serious relationships?
3. What work did you do and how did you feel about it?
4. What were your goals during this time?
5. What was the biggest challenge you faced?

### Middle Adulthood (30-60)
1. How did your sense of yourself change?
2. What were your major accomplishments?
3. What losses did you experience?
4. How did your relationships evolve?
5. What did you learn about yourself?

### Later Life (60+)
1. How has your daily life changed?
2. What matters most to you now?
3. What legacy do you want to leave?
4. What do you understand now that you didn't before?
5. What would you tell your younger self?

See: [Question Sequences Reference](elicitation/question-sequences.md)

---

## Sensitizing Questions by Theme

James Birren's Guided Autobiography uses thematic prompts:

### Family Theme
- What was the emotional climate of your home?
- Who were you closest to? Who did you clash with?
- What family stories get told and retold?

### Work Theme
- What does work mean to you beyond earning money?
- When have you felt most fulfilled professionally?
- What work would you do even if you weren't paid?

### Money Theme
- What were the messages about money in your family?
- What does financial security mean to you?
- What would you do if money were no object?

### Health Theme
- How has your relationship with your body changed?
- What health experiences shaped how you think about life?
- How do you take care of yourself?

### Death Theme
- Have you experienced significant losses?
- How do thoughts of mortality affect how you live?
- What do you want to be remembered for?

### Meaning Theme
- What gives your life meaning?
- What beliefs or values guide you?
- What questions are you still trying to answer?

---

## Language Markers for Personality

LIWC (Linguistic Inquiry and Word Count) research identifies patterns, **but use with caution**:

| Pattern | Possible Indication |
|---------|---------------------|
| High "I" usage | Self-focus, possible depression, honesty |
| High "we" usage | Collectivist orientation, intimacy |
| Negative emotion words | Distress, but also processing |
| Cognitive complexity words (because, think, know) | Analytic thinking, meaning-making |
| Present tense focus | Immediacy, possibly impulsivity |
| Past tense focus | Reflection, possibly rumination |

### Critical Caveats

1. **Context matters enormously.** The same word patterns mean different things in different contexts.
2. **Cross-validate.** Never rely on language alone. Triangulate with behavior and explicit statements.
3. **Aggregates, not individuals.** LIWC findings are about group averages. Individual variation is huge.
4. **Cultural differences.** Word usage norms vary dramatically across cultures and languages.

See: [Language Inference Reference](elicitation/language-inference.md)

---

## Anti-Patterns

**What NOT to do:**

### The Interrogation Trap
Rapid-fire questions feel like an interview, not a conversation. People become guarded.

Instead: Slow down. Reflect more, question less.

### The Interpretation Leap
Jumping to psychological conclusions before you have evidence.

Instead: Hold hypotheses lightly. Seek disconfirming evidence.

### The Agenda Push
Steering toward topics you think are important rather than following their energy.

Instead: Let them lead. Their emphasis is data.

### The Premature Depth
Asking deeply personal questions before trust is established.

Instead: Earn disclosure gradually. Start with easier territory.

### The Therapy Cosplay
Using clinical language or techniques that imply you're treating them.

Instead: Be curious, not clinical. You're learning about them, not diagnosing.

### The Monologue Response
Responding to their disclosure with your own lengthy story.

Instead: Keep focus on them. Brief self-disclosure can build rapport, but always return to them.

### The Validation Trap
Agreeing with everything to maintain rapport.

Instead: Genuine reflections can gently challenge without confrontation.

---

## References

Detailed technique guides:

- [Narrative Identity](elicitation/narrative-identity.md) - McAdams' Life Story Interview, identity themes
- [Self-Defining Memories](elicitation/self-defining-memories.md) - Singer's memory elicitation techniques
- [Motivational Interviewing](elicitation/motivational-interviewing.md) - OARS framework deep dive
- [Schema Detection](elicitation/schema-detection.md) - Young's 18 schemas, downward arrow
- [Values Elicitation](elicitation/values-elicitation.md) - Schwartz's values, elicitation techniques
- [Question Sequences](elicitation/question-sequences.md) - Haight and Birren's structured approaches
- [Language Inference](elicitation/language-inference.md) - LIWC patterns and limitations

---

## Further Reading

Primary sources:

- Singer, J.A. & Salovey, P. (1993). *The Remembered Self: Emotion and Memory in Personality*
- McAdams, D.P. (2006). *The Redemptive Self: Stories Americans Live By*
- Miller, W.R. & Rollnick, S. (2023). *Motivational Interviewing* (4th ed.)
- Young, J.E., Klosko, J.S., & Weishaar, M.E. (2003). *Schema Therapy: A Practitioner's Guide*
- Schwartz, S.H. (1992). Universals in the content and structure of values. *Advances in Experimental Social Psychology*
- Haight, B.K. & Haight, B.S. (2007). *The Handbook of Structured Life Review*
- Birren, J.E. & Cochran, K.N. (2001). *Telling the Stories of Life through Guided Autobiography Groups*
- Pennebaker, J.W. & King, L.A. (1999). Linguistic styles: Language use as an individual difference. *Journal of Personality and Social Psychology*
