# ElevenLabs Voice Guide

Detailed descriptions and recommendations for each voice persona.

## English Voices

### Rachel (21m00Tcm4TlvDq8ikWAM)
**Persona:** Warm & Friendly  
**Best for:** General narration, tutorials, conversational content  
**Tone:** Approachable, warm, natural  
**Age:** Young adult  
**Accent:** American English

Rachel is the go-to voice for most applications. She sounds natural, friendly, and engaging without being overly casual. Perfect for content where you want to sound approachable and trustworthy.

**Recommended settings:**
- Stability: 0.75 (balanced)
- Similarity: 0.75 (accurate)
- Style: 0.5 (moderate expression)

---

### Adam (pNInz6obpgDQGcFmaJgB)
**Persona:** Deep Narrator  
**Best for:** Documentaries, audiobooks, serious narration  
**Tone:** Authoritative, deep, commanding  
**Age:** Middle-aged  
**Accent:** American English

Adam has a rich, deep voice that commands attention. Ideal for content that requires gravitas and authority. His voice works exceptionally well for long-form narration.

**Recommended settings:**
- Stability: 0.80 (more consistent)
- Similarity: 0.75 (accurate)
- Style: 0.4 (subtle expression)

---

### Bella (EXAVITQu4vr4xnSDxMaL)
**Persona:** Soft & Young  
**Best for:** Gentle content, meditation, children's stories  
**Tone:** Soft, calming, youthful  
**Age:** Young  
**Accent:** American English

Bella's voice is gentle and soothing, perfect for content meant to calm or comfort. Her youthful quality makes her ideal for children's content or meditation guides.

**Recommended settings:**
- Stability: 0.70 (allows warmth)
- Similarity: 0.80 (high accuracy)
- Style: 0.6 (more expressive)

---

### Antoni (ErXwobaYiN019PkySvjV)
**Persona:** Nice Guy  
**Best for:** Podcasts, casual conversation, storytelling  
**Tone:** Friendly, conversational, relatable  
**Age:** Young adult  
**Accent:** American English

Antoni sounds like your friendly neighbor. His voice is perfect for content that should feel like a one-on-one conversation. Great for podcasts and casual tutorials.

**Recommended settings:**
- Stability: 0.75 (balanced)
- Similarity: 0.75 (accurate)
- Style: 0.5 (moderate expression)

---

### Josh (TxGEqnHWrfWFTfGW9XjX)
**Persona:** Professional  
**Best for:** Business content, presentations, corporate training  
**Tone:** Clear, professional, articulate  
**Age:** Adult  
**Accent:** American English

Josh delivers a professional, no-nonsense tone perfect for business applications. His voice is clear and articulate, making complex information easy to understand.

**Recommended settings:**
- Stability: 0.85 (very consistent)
- Similarity: 0.75 (accurate)
- Style: 0.3 (minimal expression, clear)

---

### Domi (AZnzlk1XvdvUeBnXmlld)
**Persona:** Confident Leader  
**Best for:** Leadership content, motivational speeches, news  
**Tone:** Strong, confident, authoritative  
**Age:** Adult  
**Accent:** American English

Domi's voice exudes confidence and strength. Perfect for motivational content or anything requiring a strong, commanding female voice.

**Recommended settings:**
- Stability: 0.80 (consistent)
- Similarity: 0.75 (accurate)
- Style: 0.4 (subtle expression)

---

### Elli (MF3mGyEYCl7XYWbV9V6O)
**Persona:** Energetic & Dynamic  
**Best for:** Advertising, upbeat content, youth-oriented material  
**Tone:** Energetic, enthusiastic, youthful  
**Age:** Young  
**Accent:** American English

Elli brings energy and enthusiasm to every word. Perfect for content that needs to grab attention and maintain high energy throughout.

**Recommended settings:**
- Stability: 0.70 (allows energy)
- Similarity: 0.80 (accurate)
- Style: 0.7 (high expression)

---

### Callum (N2lVS1w4EtoT3dr4eOWO)
**Persona:** Trustworthy Advisor  
**Best for:** News, financial content, trusted expertise  
**Tone:** Mature, trustworthy, reassuring  
**Age:** Mature adult  
**Accent:** British English

Callum's mature voice conveys trust and credibility. Excellent for content where you need to establish authority and trustworthiness.

**Recommended settings:**
- Stability: 0.85 (very consistent)
- Similarity: 0.75 (accurate)
- Style: 0.3 (minimal expression, clear)

---

## German Voices

### Seraphina
**Persona:** German Professional  
**Best for:** Business, tutorials, news  
**Tone:** Clear, professional, articulate  
**Accent:** Standard German

A professional German female voice ideal for business and educational content in German.

---

### Daniel (onwK4e9ZLuTAKqWW03F9)
**Persona:** German Authority  
**Best for:** Narration, documentaries, authoritative content  
**Tone:** Strong, commanding, clear  
**Accent:** Standard German

Daniel provides an authoritative German male voice perfect for serious narration and professional content.

---

### Clara
**Persona:** Warm German  
**Best for:** Friendly content, tutorials, storytelling  
**Tone:** Warm, approachable, pleasant  
**Accent:** Standard German

Clara offers a warm, friendly German voice perfect for conversational and educational content.

---

## Spanish Voices

### Valentino
**Persona:** Smooth Spanish  
**Best for:** Narration, storytelling, elegant content  
**Tone:** Smooth, refined, elegant  
**Accent:** European Spanish

Valentino's smooth voice is perfect for elegant Spanish narration and storytelling.

---

### Lucia
**Persona:** Elegant Spanish  
**Best for:** Professional content, news, tutorials  
**Tone:** Sophisticated, clear, professional  
**Accent:** European Spanish

Lucia provides an elegant, professional Spanish voice ideal for business and educational content.

---

## Voice Settings Explained

### Stability (0.0 - 1.0)
Controls the consistency and predictability of the voice output.
- **Low (0.3-0.5)**: More variation, emotional, expressive
- **Medium (0.6-0.8)**: Balanced, natural variation
- **High (0.8-1.0)**: Very consistent, minimal variation

**Use high stability for:** Professional content, long narrations, consistent tone  
**Use low stability for:** Expressive storytelling, emotional content, character voices

### Similarity Boost (0.0 - 1.0)
Controls how closely the output matches the original voice characteristics.
- **Low (0.3-0.5)**: More generic, easier to generate
- **Medium (0.6-0.8)**: Balanced accuracy
- **High (0.8-1.0)**: Very accurate to original voice

**Recommendation:** Keep between 0.75-0.85 for best results

### Style (0.0 - 1.0)
Controls the exaggeration of the speaker's style and emotion.
- **Low (0.0-0.3)**: Neutral, clear delivery
- **Medium (0.4-0.6)**: Natural expression
- **High (0.7-1.0)**: Exaggerated, highly expressive

**Use high style for:** Dramatic readings, storytelling, character performances  
**Use low style for:** News, professional content, clear information delivery

## Choosing the Right Voice

### By Content Type
- **Business/Corporate:** Josh, Domi, Seraphina
- **Storytelling:** Antoni, Adam, Bella
- **News/Journalism:** Callum, Domi, Daniel
- **Education/Tutorials:** Rachel, Josh, Clara
- **Meditation/Wellness:** Bella, Rachel
- **Advertising:** Elli, Domi
- **Audiobooks:** Adam, Callum, Antoni

### By Language
- **English (US):** Rachel, Adam, Bella, Antoni, Josh, Domi, Elli
- **English (UK):** Callum
- **German:** Seraphina, Daniel, Clara
- **Spanish:** Valentino, Lucia

### By Persona
- **Warm & Friendly:** Rachel, Antoni, Clara
- **Professional:** Josh, Seraphina, Lucia
- **Authoritative:** Adam, Callum, Domi, Daniel
- **Energetic:** Elli
- **Calming:** Bella
- **Trustworthy:** Callum, Josh

## Tips for Best Results

1. **Match voice to content:** Choose a voice whose natural tone matches your content's mood
2. **Adjust settings carefully:** Small changes in stability and style can significantly impact output
3. **Test with sample text:** Always test with representative text before committing
4. **Consider your audience:** Different demographics respond to different voice types
5. **Consistency matters:** Stick with one voice for a project to maintain brand consistency
